/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.rdf4j.repository;

import it.unibz.inf.ontop.injection.OntopSQLOWLAPIConfiguration;
import it.unibz.inf.ontop.injection.OntopSystemConfiguration;
import it.unibz.inf.ontop.rdf4j.repository.OntopRepository;
import java.io.File;
import java.util.Optional;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.repository.config.AbstractRepositoryImplConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigSchema;

public class OntopRepositoryConfig
extends AbstractRepositoryImplConfig {
    public static final String NAMESPACE = "http://inf.unibz.it/krdb/obda/quest#";
    public static final IRI OWLFILE;
    public static final IRI OBDAFILE;
    public static final IRI PROPERTIESFILE;
    public static final IRI CONSTRAINTFILE;
    public static final IRI EXISTENTIAL;
    private String name;
    private Optional<File> owlFile;
    private File obdaFile;
    private File propertiesFile;
    private Optional<File> constraintFile;
    private OntopRepository repository = null;

    public OntopRepositoryConfig() {
        super("obda:OntopRepository");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void validate() throws RepositoryConfigException {
        this.buildRepository();
    }

    private void validateFields() throws RepositoryConfigException {
        try {
            if (this.owlFile.filter(f -> !f.exists()).isPresent()) {
                throw new RepositoryConfigException(String.format("The OWL file %s does not exist!", this.owlFile.get().getAbsolutePath()));
            }
            if (this.owlFile.filter(f -> !f.canRead()).isPresent()) {
                throw new RepositoryConfigException(String.format("The OWL file %s is not accessible!", this.owlFile.get().getAbsolutePath()));
            }
            if (this.obdaFile == null) {
                throw new RepositoryConfigException(String.format("No mapping file specified for repository creation ", new Object[0]));
            }
            if (!this.obdaFile.exists()) {
                throw new RepositoryConfigException(String.format("The mapping file %s does not exist!", this.obdaFile.getAbsolutePath()));
            }
            if (!this.obdaFile.canRead()) {
                throw new RepositoryConfigException(String.format("The mapping file %s is not accessible!", this.obdaFile.getAbsolutePath()));
            }
            if (this.propertiesFile == null) {
                throw new RepositoryConfigException(String.format("No properties file specified for repository creation ", new Object[0]));
            }
            if (!this.propertiesFile.exists()) {
                throw new RepositoryConfigException(String.format("The properties file %s does not exist!", this.propertiesFile.getAbsolutePath()));
            }
            if (!this.propertiesFile.canRead()) {
                throw new RepositoryConfigException(String.format("The properties file %s is not accessible!", this.propertiesFile.getAbsolutePath()));
            }
            if (this.constraintFile.isPresent()) {
                File file = this.constraintFile.get();
                if (!file.exists()) {
                    throw new RepositoryConfigException(String.format("The implicit key file %s does not exist!", file.getAbsolutePath()));
                }
                if (!file.canRead()) {
                    throw new RepositoryConfigException(String.format("The implicit key file %s is not accessible!", file.getAbsolutePath()));
                }
            }
        }
        catch (SecurityException e) {
            throw new RepositoryConfigException(e.getMessage());
        }
    }

    public OntopRepository buildRepository() throws RepositoryConfigException {
        if (this.repository != null) {
            return this.repository;
        }
        this.validateFields();
        try {
            OntopSQLOWLAPIConfiguration.Builder configurationBuilder = OntopSQLOWLAPIConfiguration.defaultBuilder();
            if (!this.obdaFile.getName().endsWith(".obda")) {
                configurationBuilder.r2rmlMappingFile(this.obdaFile);
            } else {
                configurationBuilder.nativeOntopMappingFile(this.obdaFile);
            }
            this.owlFile.ifPresent(arg_0 -> ((OntopSQLOWLAPIConfiguration.Builder)configurationBuilder).ontologyFile(arg_0));
            configurationBuilder.propertyFile(this.propertiesFile);
            this.constraintFile.ifPresent(arg_0 -> ((OntopSQLOWLAPIConfiguration.Builder)configurationBuilder).basicImplicitConstraintFile(arg_0));
            this.repository = OntopRepository.defaultRepository((OntopSystemConfiguration)configurationBuilder.build());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositoryConfigException("Could not create RDF4J Repository! Reason: " + e.getMessage());
        }
        return this.repository;
    }

    public Resource export(Model graph) {
        Resource implNode = super.export(graph);
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        if (this.owlFile != null) {
            this.owlFile.map(File::getAbsolutePath).ifPresent(arg_0 -> OntopRepositoryConfig.lambda$export$2(graph, implNode, (ValueFactory)vf, arg_0));
        }
        if (this.obdaFile != null) {
            graph.add(implNode, OBDAFILE, (Value)vf.createLiteral(this.obdaFile.getAbsolutePath()), new Resource[0]);
        }
        if (this.propertiesFile != null) {
            graph.add(implNode, PROPERTIESFILE, (Value)vf.createLiteral(this.propertiesFile.getAbsolutePath()), new Resource[0]);
        }
        if (this.constraintFile != null) {
            this.constraintFile.map(File::getAbsolutePath).ifPresent(arg_0 -> OntopRepositoryConfig.lambda$export$3(graph, implNode, (ValueFactory)vf, arg_0));
        }
        return implNode;
    }

    public void parse(Model graph, Resource implNode) throws RepositoryConfigException {
        super.parse(graph, implNode);
        try {
            Models.objectLiteral((Model)graph.filter(null, RepositoryConfigSchema.REPOSITORYID, null, new Resource[0])).ifPresent(lit -> this.setName(lit.getLabel()));
            Models.objectLiteral((Model)graph.filter(implNode, RepositoryConfigSchema.REPOSITORYTYPE, null, new Resource[0])).ifPresent(lit -> this.setType(lit.getLabel()));
            this.owlFile = Models.objectLiteral((Model)graph.filter(implNode, OWLFILE, null, new Resource[0])).filter(l -> !l.getLabel().isEmpty()).map(l -> new File(l.getLabel()));
            Models.objectLiteral((Model)graph.filter(implNode, OBDAFILE, null, new Resource[0])).ifPresent(lit -> {
                this.obdaFile = new File(lit.getLabel());
            });
            Models.objectLiteral((Model)graph.filter(implNode, PROPERTIESFILE, null, new Resource[0])).ifPresent(lit -> {
                this.propertiesFile = new File(lit.getLabel());
            });
            this.constraintFile = Models.objectLiteral((Model)graph.filter(implNode, CONSTRAINTFILE, null, new Resource[0])).filter(l -> !l.getLabel().isEmpty()).map(l -> new File(l.getLabel()));
        }
        catch (Exception e) {
            throw new RepositoryConfigException(e.getMessage(), (Throwable)e);
        }
    }

    private static /* synthetic */ void lambda$export$3(Model graph, Resource implNode, ValueFactory vf, String path) {
        graph.add(implNode, CONSTRAINTFILE, (Value)vf.createLiteral(path), new Resource[0]);
    }

    private static /* synthetic */ void lambda$export$2(Model graph, Resource implNode, ValueFactory vf, String path) {
        graph.add(implNode, OWLFILE, (Value)vf.createLiteral(path), new Resource[0]);
    }

    static {
        SimpleValueFactory factory = SimpleValueFactory.getInstance();
        OWLFILE = factory.createIRI(NAMESPACE, "owlFile");
        OBDAFILE = factory.createIRI(NAMESPACE, "obdaFile");
        PROPERTIESFILE = factory.createIRI(NAMESPACE, "propertiesFile");
        CONSTRAINTFILE = factory.createIRI(NAMESPACE, "constraintFile");
        EXISTENTIAL = factory.createIRI(NAMESPACE, "existential");
    }
}

