/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.sqlparser;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.spec.sqlparser.ApproximateSelectQueryAttributeExtractor;
import it.unibz.inf.ontop.spec.sqlparser.DefaultSelectQueryAttributeExtractor;
import it.unibz.inf.ontop.spec.sqlparser.JSqlParserTools;
import it.unibz.inf.ontop.spec.sqlparser.ParserViewDefinition;
import it.unibz.inf.ontop.spec.sqlparser.RAExpression;
import it.unibz.inf.ontop.spec.sqlparser.SelectQueryParser;
import it.unibz.inf.ontop.spec.sqlparser.exception.InvalidSelectQueryException;
import it.unibz.inf.ontop.spec.sqlparser.exception.UnsupportedSelectQueryException;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.TokenMgrException;
import net.sf.jsqlparser.statement.select.SelectBody;

public class SQLQueryParser {
    private final CoreSingletons coreSingletons;
    private final DBTypeFactory dbTypeFactory;

    @Inject
    public SQLQueryParser(CoreSingletons coreSingletons) {
        this.coreSingletons = coreSingletons;
        this.dbTypeFactory = coreSingletons.getTypeFactory().getDBTypeFactory();
    }

    public RAExpression getRAExpression(String sourceQuery, MetadataLookup metadataLookup) throws InvalidSelectQueryException {
        ImmutableList<QuotedID> attributes;
        SelectQueryParser sqp = new SelectQueryParser(metadataLookup, this.coreSingletons);
        try {
            SelectBody selectBody = JSqlParserTools.parse(sourceQuery);
            try {
                return sqp.parse(selectBody);
            }
            catch (UnsupportedSelectQueryException e) {
                DefaultSelectQueryAttributeExtractor sqae = new DefaultSelectQueryAttributeExtractor(metadataLookup, this.coreSingletons);
                ImmutableMap<QuotedID, ImmutableTerm> attrs = sqae.getRAExpressionAttributes(selectBody).getUnqualifiedAttributes();
                attributes = ImmutableList.copyOf((Collection)attrs.keySet());
            }
        }
        catch (JSQLParserException e) {
            System.out.println(String.format("FAILED TO PARSE: %s %s", sourceQuery, SQLQueryParser.getJSQLParserErrorMessage(sourceQuery, e)));
            ApproximateSelectQueryAttributeExtractor sqae = new ApproximateSelectQueryAttributeExtractor(metadataLookup.getQuotedIDFactory());
            attributes = sqae.getAttributes(sourceQuery);
        }
        catch (UnsupportedSelectQueryException e) {
            ApproximateSelectQueryAttributeExtractor sqae = new ApproximateSelectQueryAttributeExtractor(metadataLookup.getQuotedIDFactory());
            attributes = sqae.getAttributes(sourceQuery);
        }
        System.out.println("PARSER VIEW FOR " + sourceQuery);
        ParserViewDefinition view = new ParserViewDefinition(attributes, sourceQuery, this.dbTypeFactory);
        return sqp.translateParserView((RelationDefinition)view);
    }

    private static String getJSQLParserErrorMessage(String sourceQuery, JSQLParserException e) {
        try {
            Pattern pattern;
            Matcher matcher;
            if (e.getCause() instanceof TokenMgrException && (matcher = (pattern = Pattern.compile("at line (\\d+), column (\\d+)")).matcher(e.getCause().getMessage())).find()) {
                int line = Integer.parseInt(matcher.group(1));
                int col = Integer.parseInt(matcher.group(2));
                String sourceQueryLine = sourceQuery.split("\n")[line - 1];
                int MAX_LENGTH = 40;
                if (sourceQueryLine.length() > 40) {
                    if ((sourceQueryLine = sourceQueryLine.substring(sourceQueryLine.length() - 40)).length() > 80) {
                        sourceQueryLine = sourceQueryLine.substring(0, 80);
                    }
                    col = 40;
                }
                return "FAILED TO PARSE: " + sourceQueryLine + "\n" + Strings.repeat((String)" ", (int)("FAILED TO PARSE: ".length() + col - 2)) + "^\n" + e.getCause();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return e.getCause().toString();
    }
}

