/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.sqlparser;

import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.tools.impl.IQ2CQ;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.spec.sqlparser.RAExpression;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;

public class RAExpression2IQConverter {
    private final TermFactory termFactory;
    private final IntermediateQueryFactory iqFactory;
    private final CoreSingletons coreSingletons;

    @Inject
    private RAExpression2IQConverter(TermFactory termFactory, IntermediateQueryFactory iqFactory) {
        this.termFactory = termFactory;
        this.iqFactory = iqFactory;
        this.coreSingletons = null;
    }

    public RAExpression2IQConverter(CoreSingletons coreSingletons) {
        this.termFactory = coreSingletons.getTermFactory();
        this.iqFactory = coreSingletons.getIQFactory();
        this.coreSingletons = coreSingletons;
    }

    public IQTree convert(RAExpression re) {
        return IQ2CQ.toIQTree((ImmutableList)((ImmutableList)re.getDataAtoms().stream().collect(ImmutableCollectors.toList())), (Optional)this.termFactory.getConjunction(re.getFilterAtoms().stream()), (IntermediateQueryFactory)this.iqFactory);
    }
}

