/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.impl;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeAncestry;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.type.impl.DefaultSQLDBTypeFactory;
import it.unibz.inf.ontop.model.type.impl.NumberDBTermType;
import java.util.Map;

public class DremioSQLDBTypeFactory
extends DefaultSQLDBTypeFactory {
    @AssistedInject
    protected DremioSQLDBTypeFactory(@Assisted TermType rootTermType, @Assisted TypeFactory typeFactory) {
        super(DremioSQLDBTypeFactory.createDremioSQLTypeMap(rootTermType, typeFactory), DremioSQLDBTypeFactory.createDremioSQLCodeMap());
    }

    private static Map<String, DBTermType> createDremioSQLTypeMap(TermType rootTermType, TypeFactory typeFactory) {
        TermTypeAncestry rootAncestry = rootTermType.getAncestry();
        NumberDBTermType decimalType = new NumberDBTermType("DECIMAL", "DECIMAL(60,30)", rootAncestry, (RDFDatatype)typeFactory.getXsdDecimalDatatype(), DBTermType.Category.DECIMAL);
        Map<String, DBTermType> map = DremioSQLDBTypeFactory.createDefaultSQLTypeMap(rootTermType, typeFactory);
        map.put("DECIMAL", (DBTermType)decimalType);
        return map;
    }

    private static ImmutableMap<DefaultSQLDBTypeFactory.DefaultTypeCode, String> createDremioSQLCodeMap() {
        Map<DefaultSQLDBTypeFactory.DefaultTypeCode, String> map = DremioSQLDBTypeFactory.createDefaultSQLCodeMap();
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.STRING, "VARCHAR");
        return ImmutableMap.copyOf(map);
    }

    @Override
    public String getDBTrueLexicalValue() {
        return "true";
    }

    @Override
    public String getDBFalseLexicalValue() {
        return "false";
    }
}

