/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.collect.HashBasedTable;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableTable;
import it.unibz.inf.ontop.com.google.common.collect.Table;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBBooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolSerializer;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBIsTrueFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBTypeConversionFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.NonDeterministicDBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractSQLDBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DBBooleanFunctionSymbolWithSerializerImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultNonDeterministicNullaryFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultSimpleDBCastFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultTimeTzNormalizationFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NonSimplifiableTypedNullFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NullIgnoringDBGroupConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NullRejectingDBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NullToleratingDBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.OneLetterBooleanNormFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.OneLetterDBIsTrueFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.Serializers;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.WithoutParenthesesSimpleTypedDBFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import java.io.Serializable;
import java.util.UUID;
import java.util.function.Function;

public class PostgreSQLDBFunctionSymbolFactory
extends AbstractSQLDBFunctionSymbolFactory {
    private static final String RANDOM_STR = "RANDOM";

    @Inject
    protected PostgreSQLDBFunctionSymbolFactory(TypeFactory typeFactory) {
        super(PostgreSQLDBFunctionSymbolFactory.createPostgreSQLRegularFunctionTable(typeFactory), typeFactory);
    }

    protected static ImmutableTable<String, Integer, DBFunctionSymbol> createPostgreSQLRegularFunctionTable(TypeFactory typeFactory) {
        DBTypeFactory dbTypeFactory = typeFactory.getDBTypeFactory();
        DBTermType abstractRootDBType = dbTypeFactory.getAbstractRootDBType();
        HashBasedTable table = HashBasedTable.create(PostgreSQLDBFunctionSymbolFactory.createDefaultRegularFunctionTable(typeFactory));
        WithoutParenthesesSimpleTypedDBFunctionSymbolImpl nowFunctionSymbol = new WithoutParenthesesSimpleTypedDBFunctionSymbolImpl("CURRENT_TIMESTAMP", dbTypeFactory.getDBDateTimestampType(), abstractRootDBType);
        table.put((Object)"CURRENT_TIMESTAMP", (Object)0, (Object)nowFunctionSymbol);
        table.remove((Object)"REGEXP_LIKE", (Object)2);
        table.remove((Object)"REGEXP_LIKE", (Object)3);
        return ImmutableTable.copyOf((Table)table);
    }

    protected ImmutableTable<DBTermType, RDFDatatype, DBTypeConversionFunctionSymbol> createNormalizationTable() {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        builder.putAll((Table)super.createNormalizationTable());
        DBTermType timeStamp = this.dbTypeFactory.getDBTermType("TIMESTAMP");
        RDFDatatype xsdDatetime = this.typeFactory.getXsdDatetimeDatatype();
        RDFDatatype xsdDatetimeStamp = this.typeFactory.getXsdDatetimeStampDatatype();
        DBTypeConversionFunctionSymbol datetimeNormFunctionSymbol = this.createDateTimeNormFunctionSymbol(timeStamp);
        builder.put((Object)timeStamp, (Object)xsdDatetime, (Object)datetimeNormFunctionSymbol);
        builder.put((Object)timeStamp, (Object)xsdDatetimeStamp, (Object)datetimeNormFunctionSymbol);
        DBTermType timeTZType = this.dbTypeFactory.getDBTermType("TIMETZ");
        DefaultTimeTzNormalizationFunctionSymbol timeTZNormFunctionSymbol = new DefaultTimeTzNormalizationFunctionSymbol(timeTZType, this.dbStringType, (DBFunctionSymbolSerializer & Serializable)(terms, termConverter, termFactory) -> String.format("REGEXP_REPLACE(CAST(%s AS TEXT),'([-+]\\d\\d)$', '\\1:00')", termConverter.apply(terms.get(0))));
        builder.put((Object)timeTZType, (Object)this.typeFactory.getDatatype(XSD.TIME), (Object)timeTZNormFunctionSymbol);
        return builder.build();
    }

    protected DBFunctionSymbol createDBGroupConcat(DBTermType dbStringType, boolean isDistinct) {
        return new NullIgnoringDBGroupConcatFunctionSymbol(dbStringType, isDistinct, (DBFunctionSymbolSerializer & Serializable)(terms, termConverter, termFactory) -> String.format("array_to_string(array_agg(%s%s),%s)", isDistinct ? "DISTINCT " : "", termConverter.apply(terms.get(0)), termConverter.apply(terms.get(1))));
    }

    protected DBFunctionSymbol createTypeNullFunctionSymbol(DBTermType termType) {
        if (termType.getCastName().equals("SERIAL")) {
            return new NonSimplifiableTypedNullFunctionSymbol(termType, this.dbTypeFactory.getDBTermType("INTEGER"));
        }
        return new NonSimplifiableTypedNullFunctionSymbol(termType);
    }

    @Override
    protected DBConcatFunctionSymbol createNullRejectingDBConcat(int arity) {
        return this.createDBConcatOperator(arity);
    }

    @Override
    protected DBConcatFunctionSymbol createDBConcatOperator(int arity) {
        return new NullRejectingDBConcatFunctionSymbol("||", arity, this.dbStringType, this.abstractRootDBType, Serializers.getOperatorSerializer((String)"||"));
    }

    @Override
    protected DBConcatFunctionSymbol createRegularDBConcat(int arity) {
        return new NullToleratingDBConcatFunctionSymbol("CONCAT", arity, this.dbStringType, this.abstractRootDBType, false);
    }

    @Override
    protected DBIsTrueFunctionSymbol createDBIsTrue(DBTermType dbBooleanType) {
        return new OneLetterDBIsTrueFunctionSymbolImpl(dbBooleanType);
    }

    @Override
    protected String serializeDateTimeNorm(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("TO_JSON(%s)#>>'{}'", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected DBTypeConversionFunctionSymbol createBooleanNormFunctionSymbol(DBTermType booleanType) {
        return new OneLetterBooleanNormFunctionSymbolImpl(booleanType, this.dbStringType);
    }

    @Override
    public DBFunctionSymbol getDBSubString2() {
        return this.getRegularDBFunctionSymbol("SUBSTR", 2);
    }

    @Override
    public DBFunctionSymbol getDBSubString3() {
        return this.getRegularDBFunctionSymbol("SUBSTR", 3);
    }

    @Override
    public NonDeterministicDBFunctionSymbol getDBUUID(UUID uuid) {
        return new DefaultNonDeterministicNullaryFunctionSymbol("UUID", uuid, this.dbStringType, (DBFunctionSymbolSerializer & Serializable)(terms, termConverter, termFactory) -> "MD5(RANDOM()::text || CLOCK_TIMESTAMP()::text)::uuid");
    }

    @Override
    protected String getRandNameInDialect() {
        return RANDOM_STR;
    }

    @Override
    protected String getUUIDNameInDialect() {
        throw new UnsupportedOperationException("Should not be used for PostgreSQL");
    }

    protected String serializeContains(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("(POSITION(%s IN %s) > 0)", termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeStrBefore(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        String before = termConverter.apply((ImmutableTerm)terms.get(1));
        return String.format("LEFT(%s,CAST (SIGN(POSITION(%s IN %s))*(POSITION(%s IN %s)-1) AS INTEGER))", str, before, str, before, str);
    }

    protected String serializeStrAfter(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        String after = termConverter.apply((ImmutableTerm)terms.get(1));
        return String.format("SUBSTRING(%s,POSITION(%s IN %s) + LENGTH(%s), CAST( SIGN(POSITION(%s IN %s)) * LENGTH(%s) AS INTEGER))", str, after, str, after, after, str, str);
    }

    protected String serializeMD5(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("MD5(%s)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSHA1(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("encode(digest(%s, 'sha1'), 'hex')", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSHA256(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("encode(digest(%s, 'sha256'), 'hex')", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSHA512(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("encode(digest(%s, 'sha512'), 'hex')", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeTz(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("(LPAD(EXTRACT(TIMEZONE_HOUR FROM %s)::text,2,'0') || ':' || LPAD(EXTRACT(TIMEZONE_MINUTE FROM %s)::text,2,'0'))", str, str);
    }

    @Override
    public DBBooleanFunctionSymbol getDBRegexpMatches2() {
        return new DBBooleanFunctionSymbolWithSerializerImpl("REGEXP_LIKE2", ImmutableList.of((Object)this.abstractRootDBType, (Object)this.abstractRootDBType), this.dbBooleanType, false, Serializers.getOperatorSerializer((String)"~"));
    }

    @Override
    public DBBooleanFunctionSymbol getDBRegexpMatches3() {
        return new DBBooleanFunctionSymbolWithSerializerImpl("REGEXP_LIKE3", ImmutableList.of((Object)this.abstractRootDBType, (Object)this.abstractRootDBType, (Object)this.abstractRootType), this.dbBooleanType, false, (DBFunctionSymbolSerializer & Serializable)(terms, termConverter, termFactory) -> {
            ImmutableFunctionalTerm flagTerm = termFactory.getDBReplace((ImmutableTerm)terms.get(2), (ImmutableTerm)termFactory.getDBStringConstant("s"), (ImmutableTerm)termFactory.getDBStringConstant("n"));
            ImmutableTerm extendedPatternTerm = termFactory.getNullRejectingDBConcatFunctionalTerm(ImmutableList.of((Object)termFactory.getDBStringConstant("(?"), (Object)flagTerm, (Object)termFactory.getDBStringConstant(")"), (Object)terms.get(1))).simplify();
            return String.format("%s ~ %s", termConverter.apply(terms.get(0)), termConverter.apply(extendedPatternTerm));
        });
    }

    @Override
    protected DBTypeConversionFunctionSymbol createStringToStringCastFunctionSymbol(DBTermType inputType, DBTermType targetType) {
        switch (inputType.getName()) {
            case "CHAR": {
                return new DefaultSimpleDBCastFunctionSymbol(inputType, targetType, Serializers.getCastSerializer((DBTermType)targetType));
            }
        }
        return super.createStringToStringCastFunctionSymbol(inputType, targetType);
    }
}

