/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.collect.HashBasedTable;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableTable;
import it.unibz.inf.ontop.com.google.common.collect.Table;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBBooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolSerializer;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBTypeConversionFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractSQLDBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DBBooleanFunctionSymbolWithSerializerImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultImplicitDBCastFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultNumberNormAsBooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultSQLTimestampISONormFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.MySQLEncodeURLorIRIFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NonPostProcessedSimpleDBCastFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NullIgnoringDBGroupConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NullRejectingDBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.Serializers;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import java.io.Serializable;
import java.util.function.Function;

public class MySQLDBFunctionSymbolFactory
extends AbstractSQLDBFunctionSymbolFactory {
    protected static final String UUID_STR = "UUID";
    protected static final String CURRENT_TZ_STR = "REPLACE(TIME_FORMAT(TIMEDIFF(NOW(),CONVERT_TZ(NOW(),@@session.time_zone,'+00:00')),'+%H:%i'),'+-','-')";
    private static final String REGEXP_LIKE_STR = "REGEXP_LIKE";
    private static final String UNSUPPORTED_MSG = "Not supported by MySQL";

    @Inject
    protected MySQLDBFunctionSymbolFactory(TypeFactory typeFactory) {
        super(MySQLDBFunctionSymbolFactory.createMySQLRegularFunctionTable(typeFactory), typeFactory);
    }

    protected static ImmutableTable<String, Integer, DBFunctionSymbol> createMySQLRegularFunctionTable(TypeFactory typeFactory) {
        DBTypeFactory dbTypeFactory = typeFactory.getDBTypeFactory();
        DBTermType dbBooleanType = dbTypeFactory.getDBBooleanType();
        DBTermType dbIntType = dbTypeFactory.getDBLargeIntegerType();
        DBTermType abstractRootDBType = dbTypeFactory.getAbstractRootDBType();
        HashBasedTable table = HashBasedTable.create(MySQLDBFunctionSymbolFactory.createDefaultRegularFunctionTable(typeFactory));
        return ImmutableTable.copyOf((Table)table);
    }

    protected ImmutableTable<DBTermType, RDFDatatype, DBTypeConversionFunctionSymbol> createNormalizationTable() {
        HashBasedTable table = HashBasedTable.create();
        table.putAll((Table)super.createNormalizationTable());
        RDFDatatype xsdDatetime = this.typeFactory.getXsdDatetimeDatatype();
        RDFDatatype xsdDatetimeStamp = this.typeFactory.getXsdDatetimeStampDatatype();
        DBTermType timestamp = this.dbTypeFactory.getDBTermType("TIMESTAMP");
        DBTypeConversionFunctionSymbol timestampNormFunctionSymbol = this.createDateTimeNormFunctionSymbol(timestamp);
        table.put((Object)timestamp, (Object)xsdDatetime, (Object)timestampNormFunctionSymbol);
        table.put((Object)timestamp, (Object)xsdDatetimeStamp, (Object)timestampNormFunctionSymbol);
        RDFDatatype xsdBoolean = this.typeFactory.getXsdBooleanDatatype();
        DBTermType bitOne = this.dbTypeFactory.getDBTermType("BIT", 1);
        table.put((Object)bitOne, (Object)xsdBoolean, (Object)new DefaultNumberNormAsBooleanFunctionSymbol(bitOne, this.dbStringType));
        RDFDatatype xsdYear = this.typeFactory.getDatatype(XSD.GYEAR);
        DBTermType year = this.dbTypeFactory.getDBTermType("YEAR");
        table.put((Object)year, (Object)xsdYear, (Object)new NonPostProcessedSimpleDBCastFunctionSymbol(year, this.dbStringType, Serializers.getCastSerializer((DBTermType)this.dbStringType)));
        return ImmutableTable.copyOf((Table)table);
    }

    protected DBFunctionSymbol createDBGroupConcat(DBTermType dbStringType, boolean isDistinct) {
        return new NullIgnoringDBGroupConcatFunctionSymbol(dbStringType, isDistinct, (DBFunctionSymbolSerializer & Serializable)(terms, termConverter, termFactory) -> String.format("GROUP_CONCAT(%s%s SEPARATOR %s)", isDistinct ? "DISTINCT " : "", termConverter.apply(terms.get(0)), termConverter.apply(terms.get(1))));
    }

    @Override
    protected DBTypeConversionFunctionSymbol createDateTimeDenormFunctionSymbol(DBTermType timestampType) {
        return super.createDateTimeDenormFunctionSymbol(timestampType);
    }

    protected String serializeContains(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("INSTR(%s,%s) > 0", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)));
    }

    protected String serializeStrBefore(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        String before = termConverter.apply((ImmutableTerm)terms.get(1));
        return String.format("LEFT(%s,INSTR(%s,%s)-1)", str, str, before);
    }

    protected String serializeStrAfter(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        String after = termConverter.apply((ImmutableTerm)terms.get(1));
        return String.format("SUBSTRING(%s,LOCATE(%s,%s) + LENGTH(%s), SIGN(LOCATE(%s,%s)) * LENGTH(%s))", str, after, str, after, after, str, str);
    }

    protected String serializeMD5(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("MD5(%s)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSHA1(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("SHA1(%s)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSHA256(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("SHA2(%s,256)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSHA512(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("SHA2(%s,512)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeTz(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        throw new RuntimeException("TODO: support it");
    }

    @Override
    protected String serializeDBRowNumber(Function<ImmutableTerm, String> converter, TermFactory termFactory) {
        return super.serializeDBRowNumber(converter, termFactory);
    }

    @Override
    protected DBTypeConversionFunctionSymbol createDateTimeNormFunctionSymbol(DBTermType dbDateTimestampType) {
        return new DefaultSQLTimestampISONormFunctionSymbol(dbDateTimestampType, this.dbStringType, (DBFunctionSymbolSerializer & Serializable)(terms, converter, factory) -> this.serializeDateTimeNorm(dbDateTimestampType, (ImmutableList<? extends ImmutableTerm>)terms, converter));
    }

    protected String serializeDateTimeNorm(DBTermType dbDateTimestampType, ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter) {
        String dateTimeStringWithoutTz = String.format("REPLACE(CAST(%s AS CHAR(30)),' ', 'T')", termConverter.apply((ImmutableTerm)terms.get(0)));
        return dbDateTimestampType.getName().equals("TIMESTAMP") ? String.format("CONCAT(%s,%s)", dateTimeStringWithoutTz, CURRENT_TZ_STR) : dateTimeStringWithoutTz;
    }

    @Override
    protected String serializeDateTimeNorm(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        throw new UnsupportedOperationException("This method should not be called for MySQL");
    }

    @Override
    protected DBConcatFunctionSymbol createNullRejectingDBConcat(int arity) {
        return (DBConcatFunctionSymbol)this.getRegularDBFunctionSymbol("CONCAT", arity);
    }

    @Override
    protected DBConcatFunctionSymbol createDBConcatOperator(int arity) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    protected DBConcatFunctionSymbol createRegularDBConcat(int arity) {
        return new NullRejectingDBConcatFunctionSymbol("CONCAT", arity, this.dbStringType, this.abstractRootDBType, false);
    }

    @Override
    protected DBTypeConversionFunctionSymbol createDatetimeToDatetimeCastFunctionSymbol(DBTermType inputType, DBTermType targetType) {
        return new DefaultImplicitDBCastFunctionSymbol(inputType, targetType);
    }

    @Override
    protected DBFunctionSymbol createEncodeURLorIRI(boolean preserveInternationalChars) {
        return new MySQLEncodeURLorIRIFunctionSymbolImpl(this.dbStringType, preserveInternationalChars);
    }

    @Override
    protected String getUUIDNameInDialect() {
        return UUID_STR;
    }

    @Override
    public DBBooleanFunctionSymbol getDBRegexpMatches2() {
        return new DBBooleanFunctionSymbolWithSerializerImpl("REGEXP_MATCHES_2", ImmutableList.of((Object)this.abstractRootDBType, (Object)this.abstractRootDBType), this.dbBooleanType, false, (DBFunctionSymbolSerializer & Serializable)(terms, termConverter, termFactory) -> String.format("(%s REGEXP BINARY %s)", termConverter.apply(terms.get(0)), termConverter.apply(terms.get(1))));
    }

    @Override
    public DBBooleanFunctionSymbol getDBRegexpMatches3() {
        return new DBBooleanFunctionSymbolWithSerializerImpl("REGEXP_MATCHES_3", ImmutableList.of((Object)this.abstractRootDBType, (Object)this.abstractRootDBType, (Object)this.abstractRootDBType), this.dbBooleanType, false, this::serializeDBRegexpMatches3);
    }

    protected String serializeDBRegexpMatches3(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String string = termConverter.apply((ImmutableTerm)terms.get(0));
        String pattern = termConverter.apply((ImmutableTerm)terms.get(1));
        ImmutableTerm flagTerm = (ImmutableTerm)terms.get(2);
        if (flagTerm instanceof DBConstant) {
            String flags;
            switch (flags = ((DBConstant)flagTerm).getValue()) {
                case "": {
                    return String.format("(%s REGEXP BINARY %s)", string, pattern);
                }
                case "i": {
                    return String.format("(%s REGEXP %s)", string, pattern);
                }
            }
        }
        return this.getRegularDBFunctionSymbol(REGEXP_LIKE_STR, 3).getNativeDBString(terms, termConverter, termFactory);
    }
}

