/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.collect.HashBasedTable;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableTable;
import it.unibz.inf.ontop.com.google.common.collect.Table;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBBooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolSerializer;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBIsTrueFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractSQLDBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DBBooleanFunctionSymbolWithSerializerImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultSQLSimpleTypedDBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DenodoDBStrStartsWithFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.LowerCaseDBIsTrueFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NullRejectingDBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.SimpleTypedDBFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.WithoutParenthesesSimpleTypedDBFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.TypeFactory;
import java.io.Serializable;
import java.util.function.Function;

public class DenodoDBFunctionSymbolFactory
extends AbstractSQLDBFunctionSymbolFactory {
    private static final String NOT_YET_SUPPORTED_MSG = "Not yet supported for Denodo";

    @Inject
    protected DenodoDBFunctionSymbolFactory(TypeFactory typeFactory) {
        super(DenodoDBFunctionSymbolFactory.createDenodoRegularFunctionTable(typeFactory), typeFactory);
    }

    protected static ImmutableTable<String, Integer, DBFunctionSymbol> createDenodoRegularFunctionTable(TypeFactory typeFactory) {
        DBTypeFactory dbTypeFactory = typeFactory.getDBTypeFactory();
        DBTermType abstractRootDBType = dbTypeFactory.getAbstractRootDBType();
        HashBasedTable table = HashBasedTable.create(DenodoDBFunctionSymbolFactory.createDefaultRegularFunctionTable(typeFactory));
        DefaultSQLSimpleTypedDBFunctionSymbol strlenFunctionSymbol = new DefaultSQLSimpleTypedDBFunctionSymbol("LEN", 1, dbTypeFactory.getDBLargeIntegerType(), false, abstractRootDBType);
        table.put((Object)"CHAR_LENGTH", (Object)1, (Object)strlenFunctionSymbol);
        WithoutParenthesesSimpleTypedDBFunctionSymbolImpl nowFunctionSymbol = new WithoutParenthesesSimpleTypedDBFunctionSymbolImpl("CURRENT_TIMESTAMP", dbTypeFactory.getDBDateTimestampType(), abstractRootDBType);
        table.put((Object)"CURRENT_TIMESTAMP", (Object)0, (Object)nowFunctionSymbol);
        return ImmutableTable.copyOf((Table)table);
    }

    @Override
    public DBFunctionSymbol getDBRight() {
        return new SimpleTypedDBFunctionSymbolImpl("RIGHT", 2, this.dbStringType, false, this.abstractRootDBType, (DBFunctionSymbolSerializer & Serializable)(terms, converter, factory) -> this.serializeDBRight((ImmutableList<? extends ImmutableTerm>)terms, converter));
    }

    public DBBooleanFunctionSymbol getDBStartsWith() {
        return new DenodoDBStrStartsWithFunctionSymbol(this.abstractRootDBType, this.dbBooleanType);
    }

    private String serializeDBRight(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        String length = termConverter.apply((ImmutableTerm)terms.get(1));
        return String.format("SUBSTR(%s,LEN(%s)-%s+1)", str, str, length);
    }

    private String serializeDBStartsWith(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        String sbstr = termConverter.apply((ImmutableTerm)terms.get(1));
        return String.format("SUBSTR(%s,1,LEN(%s)) = %s)", str, sbstr, sbstr);
    }

    protected String serializeStrBefore(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        String before = termConverter.apply((ImmutableTerm)terms.get(1));
        return String.format("SUBSTR(%s, 0, POSITION(%s IN %s))", str, before, str);
    }

    protected String serializeStrAfter(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        String sbstr = termConverter.apply((ImmutableTerm)terms.get(1));
        return String.format("SUBSTR(%s,POSITION(%s IN %s) + LEN(%s),LEN(%s)  * CAST(SIGN(POSITION(%s IN %s)) AS INTEGER))", str, sbstr, str, sbstr, str, sbstr, str);
    }

    protected String serializeMD5(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("HASH(%s)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSHA1(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        throw new UnsupportedOperationException("SHA1: Not yet supported for Denodo");
    }

    protected String serializeSHA256(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        throw new UnsupportedOperationException("SHA256: Not yet supported for Denodo");
    }

    protected String serializeSHA512(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        throw new UnsupportedOperationException("SHA512: Not yet supported for Denodo");
    }

    protected String serializeTz(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        throw new UnsupportedOperationException("TZ: Not yet supported for Denodo");
    }

    @Override
    protected DBConcatFunctionSymbol createNullRejectingDBConcat(int arity) {
        return this.createDBConcatOperator(arity);
    }

    @Override
    protected DBConcatFunctionSymbol createDBConcatOperator(int arity) {
        return new NullRejectingDBConcatFunctionSymbol("||", arity, this.dbStringType, this.abstractRootDBType, true);
    }

    @Override
    protected DBConcatFunctionSymbol createRegularDBConcat(int arity) {
        return new NullRejectingDBConcatFunctionSymbol("CONCAT", arity, this.dbStringType, this.abstractRootDBType, false);
    }

    @Override
    protected String getUUIDNameInDialect() {
        throw new UnsupportedOperationException("UUID: Not yet supported for Denodo");
    }

    @Override
    public DBFunctionSymbol getDBSubString2() {
        return this.getRegularDBFunctionSymbol("SUBSTR", 2);
    }

    @Override
    public DBFunctionSymbol getDBSubString3() {
        return this.getRegularDBFunctionSymbol("SUBSTR", 3);
    }

    @Override
    protected String serializeDateTimeNorm(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("REPLACE(FORMATDATE('yyyy-MM-dd HH:mm:ss.SSSSSSXXX', %s), ' ', 'T')", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeContains(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("(POSITION(%s IN %s) > 0)", termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected DBIsTrueFunctionSymbol createDBIsTrue(DBTermType dbBooleanType) {
        return new LowerCaseDBIsTrueFunctionSymbolImpl(dbBooleanType);
    }

    @Override
    public DBBooleanFunctionSymbol getDBRegexpMatches2() {
        return new DBBooleanFunctionSymbolWithSerializerImpl("REGEXP_LIKE2", ImmutableList.of((Object)this.dbStringType, (Object)this.dbStringType), this.dbBooleanType, false, (DBFunctionSymbolSerializer & Serializable)(terms, converter, factory) -> String.format("%s REGEXP_LIKE %s", converter.apply(terms.get(0)), converter.apply(terms.get(1))));
    }

    @Override
    public DBBooleanFunctionSymbol getDBRegexpMatches3() {
        throw new UnsupportedOperationException("REGEXP_LIKE3: Not yet supported for Denodo");
    }

    @Override
    public DBFunctionSymbol getDBRegexpReplace3() {
        return new DefaultSQLSimpleTypedDBFunctionSymbol("REGEXP", 3, this.dbStringType, false, this.abstractRootDBType);
    }

    @Override
    public DBFunctionSymbol getDBRegexpReplace4() {
        throw new UnsupportedOperationException("REGEXP_REPLACE4: Not yet supported for Denodo");
    }
}

