/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.collect.HashBasedTable;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableTable;
import it.unibz.inf.ontop.com.google.common.collect.Table;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolSerializer;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBIsTrueFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBTypeConversionFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractSQLDBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultCastIntegerToStringFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultNumberNormAsBooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultSimpleDBCastFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.ForcingFloatingDBAvgFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NullRejectingDBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.OneDigitBooleanNormFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.OneDigitDBIsTrueFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.Serializers;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.WithoutParenthesesSimpleTypedDBFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TypeFactory;
import java.io.Serializable;
import java.util.function.Function;

public class DB2DBFunctionSymbolFactory
extends AbstractSQLDBFunctionSymbolFactory {
    private static final String CURRENT_TIMESTAMP_SPACE_STR = "CURRENT TIMESTAMP";
    private static final String CHAR_STR = "CHAR";
    private final DBFunctionSymbolSerializer numberToStringSerializer = (DBFunctionSymbolSerializer & Serializable)(terms, termConverter, termFactory) -> String.format("REPLACE(CHAR(%s),' ', '')", termConverter.apply(terms.get(0)));
    private static final String NOT_YET_SUPPORTED_MSG = "Not yet supported for DB2";

    @Inject
    protected DB2DBFunctionSymbolFactory(TypeFactory typeFactory) {
        super(DB2DBFunctionSymbolFactory.createDB2RegularFunctionTable(typeFactory), typeFactory);
    }

    protected static ImmutableTable<String, Integer, DBFunctionSymbol> createDB2RegularFunctionTable(TypeFactory typeFactory) {
        DBTypeFactory dbTypeFactory = typeFactory.getDBTypeFactory();
        DBTermType abstractRootDBType = dbTypeFactory.getAbstractRootDBType();
        HashBasedTable table = HashBasedTable.create(DB2DBFunctionSymbolFactory.createDefaultRegularFunctionTable(typeFactory));
        WithoutParenthesesSimpleTypedDBFunctionSymbolImpl nowFunctionSymbol = new WithoutParenthesesSimpleTypedDBFunctionSymbolImpl(CURRENT_TIMESTAMP_SPACE_STR, dbTypeFactory.getDBDateTimestampType(), abstractRootDBType);
        table.put((Object)CURRENT_TIMESTAMP_SPACE_STR, (Object)0, (Object)nowFunctionSymbol);
        return ImmutableTable.copyOf((Table)table);
    }

    protected ImmutableTable<DBTermType, RDFDatatype, DBTypeConversionFunctionSymbol> createNormalizationTable() {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        builder.putAll((Table)super.createNormalizationTable());
        RDFDatatype xsdBoolean = this.typeFactory.getXsdBooleanDatatype();
        DBTermType smallIntType = this.dbTypeFactory.getDBTermType("SMALLINT");
        builder.put((Object)smallIntType, (Object)xsdBoolean, (Object)new DefaultNumberNormAsBooleanFunctionSymbol(smallIntType, this.dbStringType));
        return builder.build();
    }

    @Override
    protected DBConcatFunctionSymbol createNullRejectingDBConcat(int arity) {
        return this.createDBConcatOperator(arity);
    }

    @Override
    protected DBConcatFunctionSymbol createDBConcatOperator(int arity) {
        return new NullRejectingDBConcatFunctionSymbol("||", arity, this.dbStringType, this.abstractRootDBType, true);
    }

    @Override
    protected DBConcatFunctionSymbol createRegularDBConcat(int arity) {
        if (arity != 2) {
            throw new UnsupportedOperationException("CONCAT is strictly binary in DB2. Please use the operator instead.");
        }
        return new NullRejectingDBConcatFunctionSymbol("CONCAT", arity, this.dbStringType, this.abstractRootDBType, false);
    }

    @Override
    protected DBIsTrueFunctionSymbol createDBIsTrue(DBTermType dbBooleanType) {
        return new OneDigitDBIsTrueFunctionSymbolImpl(dbBooleanType);
    }

    @Override
    protected String serializeDateTimeNorm(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("REPLACE(VARCHAR_FORMAT(%s,'YYYY-MM-DD HH24:MI:SS.FF'),' ','T')", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected DBTypeConversionFunctionSymbol createBooleanNormFunctionSymbol(DBTermType booleanType) {
        return new OneDigitBooleanNormFunctionSymbolImpl(booleanType, this.dbStringType);
    }

    @Override
    public DBFunctionSymbol getDBSubString2() {
        return this.getRegularDBFunctionSymbol("SUBSTR", 2);
    }

    @Override
    public DBFunctionSymbol getDBSubString3() {
        return this.getRegularDBFunctionSymbol("SUBSTR", 3);
    }

    @Override
    public DBFunctionSymbol getDBCharLength() {
        return this.getRegularDBFunctionSymbol("LENGTH", 1);
    }

    @Override
    public DBFunctionSymbol getDBNow() {
        return this.getRegularDBFunctionSymbol(CURRENT_TIMESTAMP_SPACE_STR, 0);
    }

    @Override
    protected String getUUIDNameInDialect() {
        throw new UnsupportedOperationException("UUID: Not yet supported for DB2");
    }

    protected String serializeContains(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("(LOCATE(%2$s , %1$s) > 0)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)));
    }

    protected String serializeStrBefore(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        String before = termConverter.apply((ImmutableTerm)terms.get(1));
        return String.format("LEFT(%s,SIGN(LOCATE(%s,%s)) * (LOCATE(%s,%s)-1))", str, before, str, before, str);
    }

    protected String serializeStrAfter(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        String after = termConverter.apply((ImmutableTerm)terms.get(1));
        return String.format("RTRIM(SUBSTR(%s,LOCATE(%s,%s)+LENGTH(%s), SIGN(LOCATE(%s,%s))*LENGTH(%s)))", str, after, str, after, after, str, str);
    }

    protected String serializeMD5(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        throw new UnsupportedOperationException("MD5: Not yet supported for DB2");
    }

    protected String serializeSHA1(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        throw new UnsupportedOperationException("SHA1: Not yet supported for DB2");
    }

    protected String serializeSHA256(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        throw new UnsupportedOperationException("SHA256: Not yet supported for DB2");
    }

    protected String serializeSHA512(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        throw new UnsupportedOperationException("SHA512: Not yet supported for DB2");
    }

    protected String serializeTz(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        throw new UnsupportedOperationException("Serialization of the time zone: Not yet supported for DB2");
    }

    @Override
    protected DBTypeConversionFunctionSymbol createIntegerToStringCastFunctionSymbol(DBTermType inputType) {
        return new DefaultCastIntegerToStringFunctionSymbol(inputType, this.dbStringType, this.numberToStringSerializer);
    }

    @Override
    protected DBTypeConversionFunctionSymbol createDecimalToStringCastFunctionSymbol(DBTermType inputType) {
        return this.createNonIntegerNumberToStringCastFunctionSymbol(inputType);
    }

    @Override
    protected DBTypeConversionFunctionSymbol createFloatDoubleToStringCastFunctionSymbol(DBTermType inputType) {
        return this.createNonIntegerNumberToStringCastFunctionSymbol(inputType);
    }

    protected DBTypeConversionFunctionSymbol createNonIntegerNumberToStringCastFunctionSymbol(DBTermType inputType) {
        return new DefaultSimpleDBCastFunctionSymbol(inputType, this.dbStringType, this.numberToStringSerializer);
    }

    @Override
    protected DBTypeConversionFunctionSymbol createDefaultCastToStringFunctionSymbol(DBTermType inputType) {
        return new DefaultSimpleDBCastFunctionSymbol(inputType, this.dbStringType, Serializers.getRegularSerializer((String)CHAR_STR));
    }

    @Override
    protected DBFunctionSymbol createDBAvg(DBTermType inputType, boolean isDistinct) {
        if (inputType.equals(this.dbIntegerType)) {
            return new ForcingFloatingDBAvgFunctionSymbolImpl(inputType, this.dbDecimalType, isDistinct);
        }
        return super.createDBAvg(inputType, isDistinct);
    }
}

