/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableTable;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.InequalityLabel;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBAndFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBBooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBIsNullOrNotFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBIsTrueFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBMathBinaryOperator;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBNotFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBOrFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBStrictEqFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBTypeConversionFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.NonDeterministicDBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractDBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DBBooleanCaseFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DBCountFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DBMaxFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DBMinFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultBooleanDenormFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultBooleanNormFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultCastIntegerToStringFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultDBAndFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultDBBooleanInequalityOperator;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultDBCaseFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultDBCoalesceFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultDBDateInequalityOperator;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultDBDatetimeInequalityOperator;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultDBDefaultInequalityOperator;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultDBIsTrueFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultDBNonStrictDateEqOperator;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultDBNonStrictDatetimeEqOperator;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultDBNonStrictDefaultEqOperator;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultDBNonStrictNumericEqOperator;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultDBNonStrictStringEqOperator;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultDBNotFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultDBNumericInequalityOperator;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultDBOrFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultDBStrictEqFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultDBStrictNEqFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultDBStringInequalityOperator;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultImplicitDBCastFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultNonDeterministicNullaryFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultSQLDBIsNullOrNotFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultSQLEncodeURLorIRIFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultSQLIfThenElseFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultSQLIsStringEmptyFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultSQLSimpleDBBooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultSQLSimpleMultitypedDBFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultSQLSimpleTypedDBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultSQLTimestampISODenormFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultSQLTimestampISONormFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultSimpleDBBooleanCastFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultSimpleDBCastFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultTypedDBMathBinaryOperator;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultUntypedDBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultUntypedDBMathBinaryOperator;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.GeoDBBooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.GeoDBTypedFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NullIfDBFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NullIgnoringDBAvgFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NullIgnoringDBSumFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.RegexpLike3FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.Serializers;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TypeFactory;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;

public abstract class AbstractSQLDBFunctionSymbolFactory
extends AbstractDBFunctionSymbolFactory {
    protected static final String UPPER_STR = "UPPER";
    protected static final String UCASE_STR = "UCASE";
    protected static final String LOWER_STR = "LOWER";
    protected static final String LCASE_STR = "LCASE";
    protected static final String CONCAT_STR = "CONCAT";
    protected static final String REPLACE_STR = "REPLACE";
    protected static final String REGEXP_REPLACE_STR = "REGEXP_REPLACE";
    protected static final String REGEXP_LIKE_STR = "REGEXP_LIKE";
    protected static final String AND_STR = "AND";
    protected static final String RIGHT_STR = "RIGHT";
    protected static final String OR_STR = "OR";
    protected static final String NOT_STR = "NOT";
    protected static final String SUBSTR_STR = "SUBSTR";
    protected static final String SUBSTRING_STR = "SUBSTRING";
    protected static final String CHAR_LENGTH_STR = "CHAR_LENGTH";
    protected static final String LENGTH_STR = "LENGTH";
    protected static final String MULTIPLY_STR = "*";
    protected static final String DIVIDE_STR = "/";
    protected static final String ADD_STR = "+";
    protected static final String SUBTRACT_STR = "-";
    protected static final String ABS_STR = "ABS";
    protected static final String CEIL_STR = "CEIL";
    protected static final String ROUND_STR = "ROUND";
    protected static final String FLOOR_STR = "FLOOR";
    protected static final String RAND_STR = "RAND";
    protected static final String CURRENT_TIMESTAMP_STR = "CURRENT_TIMESTAMP";
    protected static final String COALESCE_STR = "COALESCE";
    protected static final String CONCAT_OP_STR = "||";
    protected static final String NULLIF_STR = "NULLIF";
    protected static final String ST_WITHIN = "ST_WITHIN";
    protected static final String ST_CONTAINS = "ST_CONTAINS";
    protected static final String ST_CROSSES = "ST_CROSSES";
    protected static final String ST_DISJOINT = "ST_DISJOINT";
    protected static final String ST_EQUALS = "ST_EQUALS";
    protected static final String ST_OVERLAPS = "ST_OVERLAPS";
    protected static final String ST_INTERSECTS = "ST_INTERSECTS";
    protected static final String ST_TOUCHES = "ST_TOUCHES";
    protected static final String ST_COVERS = "ST_COVERS";
    protected static final String ST_COVEREDBY = "ST_COVEREDBY";
    protected static final String ST_CONTAINSPROPERLY = "ST_CONTAINSPROPERLY";
    protected static final String ST_DISTANCE = "ST_DISTANCE";
    protected static final String ST_DISTANCE_SPHERE = "ST_DISTANCESPHERE";
    protected static final String ST_DISTANCE_SPHEROID = "ST_DISTANCESPHEROID";
    protected static final String ST_TRANSFORM = "ST_TRANSFORM";
    protected static final String ST_SETSRID = "ST_SETSRID";
    protected static final String ST_FLIP_COORDINATES = "ST_FLIPCOORDINATES";
    protected static final String ST_ASTEXT = "ST_ASTEXT";
    private static final String ST_BUFFER = "ST_BUFFER";
    private static final String ST_INTERSECTION = "ST_INTERSECTION";
    private static final String ST_CONVEXHULL = "ST_CONVEXHULL";
    private static final String ST_BOUNDARY = "ST_BOUNDARY";
    private static final String ST_ENVELOPE = "ST_ENVELOPE";
    private static final String ST_DIFFERENCE = "ST_DIFFERENCE";
    private static final String ST_SYMDIFFERENCE = "ST_SYMDIFFERENCE";
    private static final String ST_UNION = "ST_UNION";
    private static final String ST_RELATE = "ST_RELATE";
    private static final String ST_SRID = "ST_SRID";
    protected DBTypeFactory dbTypeFactory;
    protected final TypeFactory typeFactory;
    protected final DBTermType dbStringType;
    protected final DBTermType dbBooleanType;
    protected final DBTermType dbDoubleType;
    protected final DBTermType dbIntegerType;
    protected final DBTermType dbDecimalType;
    protected final DBTermType abstractRootDBType;
    protected final TermType abstractRootType;
    private final Map<Integer, DBConcatFunctionSymbol> nullRejectingConcatMap;
    private final Map<Integer, DBConcatFunctionSymbol> concatOperatorMap;
    private DBFunctionSymbol ifThenElse;
    private DBBooleanFunctionSymbol isStringEmpty;
    private DBIsNullOrNotFunctionSymbol isNull;
    private DBIsNullOrNotFunctionSymbol isNotNull;
    private DBIsTrueFunctionSymbol isTrue;

    protected AbstractSQLDBFunctionSymbolFactory(ImmutableTable<String, Integer, DBFunctionSymbol> regularFunctionTable, TypeFactory typeFactory) {
        super(regularFunctionTable, typeFactory);
        this.dbTypeFactory = typeFactory.getDBTypeFactory();
        this.typeFactory = typeFactory;
        this.dbStringType = this.dbTypeFactory.getDBStringType();
        this.dbBooleanType = this.dbTypeFactory.getDBBooleanType();
        this.dbDoubleType = this.dbTypeFactory.getDBDoubleType();
        this.dbIntegerType = this.dbTypeFactory.getDBLargeIntegerType();
        this.dbDecimalType = this.dbTypeFactory.getDBDecimalType();
        this.abstractRootDBType = this.dbTypeFactory.getAbstractRootDBType();
        this.abstractRootType = typeFactory.getAbstractAtomicTermType();
        this.nullRejectingConcatMap = Maps.newConcurrentMap();
        this.concatOperatorMap = Maps.newConcurrentMap();
    }

    protected void init() {
        super.init();
        this.ifThenElse = this.createDBIfThenElse(this.dbBooleanType, this.abstractRootDBType);
        this.isStringEmpty = this.createIsStringEmpty(this.dbBooleanType, this.abstractRootDBType);
        this.isNull = this.createDBIsNull(this.dbBooleanType, this.abstractRootDBType);
        this.isNotNull = this.createDBIsNotNull(this.dbBooleanType, this.abstractRootDBType);
        this.isTrue = this.createDBIsTrue(this.dbBooleanType);
    }

    protected DBFunctionSymbol createDBCount(boolean isUnary, boolean isDistinct) {
        DBTermType integerType = this.dbTypeFactory.getDBLargeIntegerType();
        return isUnary ? new DBCountFunctionSymbolImpl(this.abstractRootDBType, integerType, isDistinct) : new DBCountFunctionSymbolImpl(integerType, isDistinct);
    }

    protected DBFunctionSymbol createDBSum(DBTermType termType, boolean isDistinct) {
        return new NullIgnoringDBSumFunctionSymbol(termType, isDistinct);
    }

    protected DBFunctionSymbol createDBAvg(DBTermType inputType, boolean isDistinct) {
        DBTermType targetType = inputType.equals(this.dbIntegerType) ? this.dbDecimalType : inputType;
        return new NullIgnoringDBAvgFunctionSymbol(inputType, targetType, isDistinct);
    }

    protected DBFunctionSymbol createDBMin(DBTermType termType) {
        return new DBMinFunctionSymbolImpl(termType);
    }

    protected DBFunctionSymbol createDBMax(DBTermType termType) {
        return new DBMaxFunctionSymbolImpl(termType);
    }

    protected static ImmutableTable<String, Integer, DBFunctionSymbol> createDefaultRegularFunctionTable(TypeFactory typeFactory) {
        DBTypeFactory dbTypeFactory = typeFactory.getDBTypeFactory();
        DBTermType dbStringType = dbTypeFactory.getDBStringType();
        DBTermType dbIntType = dbTypeFactory.getDBLargeIntegerType();
        DBTermType dbDateTimestamp = dbTypeFactory.getDBDateTimestampType();
        DBTermType abstractRootDBType = dbTypeFactory.getAbstractRootDBType();
        DBTermType dbBooleanType = dbTypeFactory.getDBBooleanType();
        DBTermType dbDoubleType = dbTypeFactory.getDBDoubleType();
        DBTermType dbIntegerType = dbTypeFactory.getDBLargeIntegerType();
        ImmutableTable.Builder builder = ImmutableTable.builder();
        DefaultSQLSimpleTypedDBFunctionSymbol upperFunctionSymbol = new DefaultSQLSimpleTypedDBFunctionSymbol(UPPER_STR, 1, dbStringType, false, abstractRootDBType);
        builder.put((Object)UPPER_STR, (Object)1, (Object)upperFunctionSymbol);
        builder.put((Object)UCASE_STR, (Object)1, (Object)upperFunctionSymbol);
        DefaultSQLSimpleTypedDBFunctionSymbol lowerFunctionSymbol = new DefaultSQLSimpleTypedDBFunctionSymbol(LOWER_STR, 1, dbStringType, false, abstractRootDBType);
        builder.put((Object)LOWER_STR, (Object)1, (Object)lowerFunctionSymbol);
        builder.put((Object)LCASE_STR, (Object)1, (Object)lowerFunctionSymbol);
        DefaultSQLSimpleTypedDBFunctionSymbol replace3FunctionSymbol = new DefaultSQLSimpleTypedDBFunctionSymbol(REPLACE_STR, 3, dbStringType, false, abstractRootDBType);
        builder.put((Object)REPLACE_STR, (Object)3, (Object)replace3FunctionSymbol);
        DefaultSQLSimpleTypedDBFunctionSymbol regexpReplace3FunctionSymbol = new DefaultSQLSimpleTypedDBFunctionSymbol(REGEXP_REPLACE_STR, 3, dbStringType, false, abstractRootDBType);
        builder.put((Object)REGEXP_REPLACE_STR, (Object)3, (Object)regexpReplace3FunctionSymbol);
        DefaultSQLSimpleTypedDBFunctionSymbol regexpReplace4FunctionSymbol = new DefaultSQLSimpleTypedDBFunctionSymbol(REGEXP_REPLACE_STR, 4, dbStringType, false, abstractRootDBType);
        builder.put((Object)REGEXP_REPLACE_STR, (Object)4, (Object)regexpReplace4FunctionSymbol);
        DefaultSQLSimpleTypedDBFunctionSymbol subString2FunctionSymbol = new DefaultSQLSimpleTypedDBFunctionSymbol(SUBSTRING_STR, 2, dbStringType, false, abstractRootDBType);
        builder.put((Object)SUBSTRING_STR, (Object)2, (Object)subString2FunctionSymbol);
        DefaultSQLSimpleTypedDBFunctionSymbol subStr2FunctionSymbol = new DefaultSQLSimpleTypedDBFunctionSymbol(SUBSTR_STR, 2, dbStringType, false, abstractRootDBType);
        builder.put((Object)SUBSTR_STR, (Object)2, (Object)subStr2FunctionSymbol);
        DefaultSQLSimpleTypedDBFunctionSymbol subString3FunctionSymbol = new DefaultSQLSimpleTypedDBFunctionSymbol(SUBSTRING_STR, 3, dbStringType, false, abstractRootDBType);
        builder.put((Object)SUBSTRING_STR, (Object)3, (Object)subString3FunctionSymbol);
        DefaultSQLSimpleTypedDBFunctionSymbol subStr3FunctionSymbol = new DefaultSQLSimpleTypedDBFunctionSymbol(SUBSTR_STR, 3, dbStringType, false, abstractRootDBType);
        builder.put((Object)SUBSTR_STR, (Object)3, (Object)subStr3FunctionSymbol);
        DefaultSQLSimpleTypedDBFunctionSymbol rightFunctionSymbol = new DefaultSQLSimpleTypedDBFunctionSymbol(RIGHT_STR, 2, dbStringType, false, abstractRootDBType);
        builder.put((Object)RIGHT_STR, (Object)2, (Object)rightFunctionSymbol);
        DefaultSQLSimpleTypedDBFunctionSymbol strlenFunctionSymbol = new DefaultSQLSimpleTypedDBFunctionSymbol(CHAR_LENGTH_STR, 1, dbIntType, false, abstractRootDBType);
        builder.put((Object)CHAR_LENGTH_STR, (Object)1, (Object)strlenFunctionSymbol);
        DefaultSQLSimpleTypedDBFunctionSymbol lengthFunctionSymbol = new DefaultSQLSimpleTypedDBFunctionSymbol(LENGTH_STR, 1, dbIntType, false, abstractRootDBType);
        builder.put((Object)LENGTH_STR, (Object)1, (Object)lengthFunctionSymbol);
        DefaultSQLSimpleTypedDBFunctionSymbol nowFunctionSymbol = new DefaultSQLSimpleTypedDBFunctionSymbol(CURRENT_TIMESTAMP_STR, 0, dbDateTimestamp, true, abstractRootDBType);
        builder.put((Object)CURRENT_TIMESTAMP_STR, (Object)0, (Object)nowFunctionSymbol);
        DefaultSQLSimpleDBBooleanFunctionSymbol regexpLike2 = new DefaultSQLSimpleDBBooleanFunctionSymbol(REGEXP_LIKE_STR, 2, dbBooleanType, abstractRootDBType);
        builder.put((Object)REGEXP_LIKE_STR, (Object)2, (Object)regexpLike2);
        RegexpLike3FunctionSymbol regexpLike3 = new RegexpLike3FunctionSymbol(dbBooleanType, abstractRootDBType);
        builder.put((Object)REGEXP_LIKE_STR, (Object)3, (Object)regexpLike3);
        NullIfDBFunctionSymbolImpl nullIfFunctionSymbol = new NullIfDBFunctionSymbolImpl(abstractRootDBType);
        builder.put((Object)NULLIF_STR, (Object)2, (Object)nullIfFunctionSymbol);
        GeoDBBooleanFunctionSymbol withinFunctionSymbol = new GeoDBBooleanFunctionSymbol(ST_WITHIN, 2, dbBooleanType, abstractRootDBType);
        builder.put((Object)ST_WITHIN, (Object)2, (Object)withinFunctionSymbol);
        GeoDBBooleanFunctionSymbol containsFunctionSymbol = new GeoDBBooleanFunctionSymbol(ST_CONTAINS, 2, dbBooleanType, abstractRootDBType);
        builder.put((Object)ST_CONTAINS, (Object)2, (Object)containsFunctionSymbol);
        GeoDBBooleanFunctionSymbol crossesFunctionSymbol = new GeoDBBooleanFunctionSymbol(ST_CROSSES, 2, dbBooleanType, abstractRootDBType);
        builder.put((Object)ST_CROSSES, (Object)2, (Object)crossesFunctionSymbol);
        GeoDBBooleanFunctionSymbol disjointFunctionSymbol = new GeoDBBooleanFunctionSymbol(ST_DISJOINT, 2, dbBooleanType, abstractRootDBType);
        builder.put((Object)ST_DISJOINT, (Object)2, (Object)disjointFunctionSymbol);
        GeoDBBooleanFunctionSymbol equalsFunctionSymbol = new GeoDBBooleanFunctionSymbol(ST_EQUALS, 2, dbBooleanType, abstractRootDBType);
        builder.put((Object)ST_EQUALS, (Object)2, (Object)equalsFunctionSymbol);
        GeoDBBooleanFunctionSymbol intersectsFunctionSymbol = new GeoDBBooleanFunctionSymbol(ST_INTERSECTS, 2, dbBooleanType, abstractRootDBType);
        builder.put((Object)ST_INTERSECTS, (Object)2, (Object)intersectsFunctionSymbol);
        GeoDBBooleanFunctionSymbol overlapsFunctionSymbol = new GeoDBBooleanFunctionSymbol(ST_OVERLAPS, 2, dbBooleanType, abstractRootDBType);
        builder.put((Object)ST_OVERLAPS, (Object)2, (Object)overlapsFunctionSymbol);
        GeoDBBooleanFunctionSymbol touchesFunctionSymbol = new GeoDBBooleanFunctionSymbol(ST_TOUCHES, 2, dbBooleanType, abstractRootDBType);
        builder.put((Object)ST_TOUCHES, (Object)2, (Object)touchesFunctionSymbol);
        GeoDBBooleanFunctionSymbol coversFunctionSymbol = new GeoDBBooleanFunctionSymbol(ST_COVERS, 2, dbBooleanType, abstractRootDBType);
        builder.put((Object)ST_COVERS, (Object)2, (Object)coversFunctionSymbol);
        GeoDBBooleanFunctionSymbol coveredbyFunctionSymbol = new GeoDBBooleanFunctionSymbol(ST_COVEREDBY, 2, dbBooleanType, abstractRootDBType);
        builder.put((Object)ST_COVEREDBY, (Object)2, (Object)coveredbyFunctionSymbol);
        GeoDBBooleanFunctionSymbol containsproperlyFunctionSymbol = new GeoDBBooleanFunctionSymbol(ST_CONTAINSPROPERLY, 2, dbBooleanType, abstractRootDBType);
        builder.put((Object)ST_CONTAINSPROPERLY, (Object)2, (Object)containsproperlyFunctionSymbol);
        GeoDBTypedFunctionSymbol distanceFunctionSymbol = new GeoDBTypedFunctionSymbol(ST_DISTANCE, 2, dbDoubleType, false, abstractRootDBType);
        builder.put((Object)ST_DISTANCE, (Object)2, (Object)distanceFunctionSymbol);
        GeoDBTypedFunctionSymbol distanceSphereFunctionSymbol = new GeoDBTypedFunctionSymbol(ST_DISTANCE_SPHERE, 2, dbDoubleType, false, abstractRootDBType);
        builder.put((Object)ST_DISTANCE_SPHERE, (Object)2, (Object)distanceSphereFunctionSymbol);
        GeoDBTypedFunctionSymbol distanceSpheroidFunctionSymbol = new GeoDBTypedFunctionSymbol(ST_DISTANCE_SPHEROID, 3, dbDoubleType, false, abstractRootDBType);
        builder.put((Object)ST_DISTANCE_SPHEROID, (Object)3, (Object)distanceSpheroidFunctionSymbol);
        DefaultSQLSimpleTypedDBFunctionSymbol asTextSymbol = new DefaultSQLSimpleTypedDBFunctionSymbol(ST_ASTEXT, 1, dbStringType, false, abstractRootDBType);
        builder.put((Object)ST_ASTEXT, (Object)1, (Object)asTextSymbol);
        GeoDBTypedFunctionSymbol bufferSymbol = new GeoDBTypedFunctionSymbol(ST_BUFFER, 2, dbStringType, false, abstractRootDBType);
        builder.put((Object)ST_BUFFER, (Object)2, (Object)bufferSymbol);
        GeoDBTypedFunctionSymbol intersectionSymbol = new GeoDBTypedFunctionSymbol(ST_INTERSECTION, 2, dbStringType, false, abstractRootDBType);
        builder.put((Object)ST_INTERSECTION, (Object)2, (Object)intersectionSymbol);
        GeoDBTypedFunctionSymbol boundarySymbol = new GeoDBTypedFunctionSymbol(ST_BOUNDARY, 1, dbStringType, false, abstractRootDBType);
        builder.put((Object)ST_BOUNDARY, (Object)1, (Object)boundarySymbol);
        GeoDBTypedFunctionSymbol convexhullSymbol = new GeoDBTypedFunctionSymbol(ST_CONVEXHULL, 1, dbStringType, false, abstractRootDBType);
        builder.put((Object)ST_CONVEXHULL, (Object)1, (Object)convexhullSymbol);
        GeoDBTypedFunctionSymbol differenceSymbol = new GeoDBTypedFunctionSymbol(ST_DIFFERENCE, 2, dbStringType, false, abstractRootDBType);
        builder.put((Object)ST_DIFFERENCE, (Object)2, (Object)differenceSymbol);
        GeoDBTypedFunctionSymbol symdifferenceSymbol = new GeoDBTypedFunctionSymbol(ST_SYMDIFFERENCE, 2, dbStringType, false, abstractRootDBType);
        builder.put((Object)ST_SYMDIFFERENCE, (Object)2, (Object)symdifferenceSymbol);
        GeoDBTypedFunctionSymbol envelopeSymbol = new GeoDBTypedFunctionSymbol(ST_ENVELOPE, 1, dbStringType, false, abstractRootDBType);
        builder.put((Object)ST_ENVELOPE, (Object)1, (Object)envelopeSymbol);
        GeoDBTypedFunctionSymbol unionSymbol = new GeoDBTypedFunctionSymbol(ST_UNION, 2, dbStringType, false, abstractRootDBType);
        builder.put((Object)ST_UNION, (Object)2, (Object)unionSymbol);
        GeoDBBooleanFunctionSymbol relateSymbol = new GeoDBBooleanFunctionSymbol(ST_RELATE, 3, dbBooleanType, abstractRootDBType);
        builder.put((Object)ST_RELATE, (Object)3, (Object)relateSymbol);
        GeoDBTypedFunctionSymbol relatematrixSymbol = new GeoDBTypedFunctionSymbol(ST_RELATE, 2, dbStringType, false, abstractRootDBType);
        builder.put((Object)ST_RELATE, (Object)2, (Object)relatematrixSymbol);
        GeoDBTypedFunctionSymbol getsridSymbol = new GeoDBTypedFunctionSymbol(ST_SRID, 1, dbIntType, false, abstractRootDBType);
        builder.put((Object)ST_SRID, (Object)1, (Object)getsridSymbol);
        return builder.build();
    }

    public DBConcatFunctionSymbol getNullRejectingDBConcat(int arity) {
        if (arity < 2) {
            throw new IllegalArgumentException("Arity of CONCAT must be >= 2");
        }
        return this.nullRejectingConcatMap.computeIfAbsent(arity, a -> this.createNullRejectingDBConcat(arity));
    }

    public DBConcatFunctionSymbol getDBConcatOperator(int arity) {
        if (arity < 2) {
            throw new IllegalArgumentException("Arity of CONCAT must be >= 2");
        }
        return this.concatOperatorMap.computeIfAbsent(arity, a -> this.createDBConcatOperator(arity));
    }

    protected abstract DBConcatFunctionSymbol createNullRejectingDBConcat(int var1);

    protected abstract DBConcatFunctionSymbol createDBConcatOperator(int var1);

    protected DBFunctionSymbol createRegularUntypedFunctionSymbol(String nameInDialect, int arity) {
        if (this.isAnd(nameInDialect)) {
            return this.createDBAnd(arity);
        }
        if (this.isOr(nameInDialect)) {
            return this.createDBOr(arity);
        }
        if (this.isConcat(nameInDialect)) {
            return this.createRegularDBConcat(arity);
        }
        return new DefaultUntypedDBFunctionSymbol(nameInDialect, arity, this.dbTypeFactory.getAbstractRootDBType());
    }

    protected DBBooleanFunctionSymbol createRegularBooleanFunctionSymbol(String nameInDialect, int arity) {
        return new DefaultSQLSimpleDBBooleanFunctionSymbol(nameInDialect, arity, this.dbBooleanType, this.abstractRootDBType);
    }

    protected boolean isConcat(String nameInDialect) {
        return nameInDialect.equals(CONCAT_STR);
    }

    protected boolean isAnd(String nameInDialect) {
        return nameInDialect.equals(AND_STR);
    }

    protected boolean isOr(String nameInDialect) {
        return nameInDialect.equals(OR_STR);
    }

    protected boolean isCoalesce(String nameInDialect) {
        return nameInDialect.equals(COALESCE_STR);
    }

    protected abstract DBConcatFunctionSymbol createRegularDBConcat(int var1);

    protected DBBooleanFunctionSymbol createDBAnd(int arity) {
        return new DefaultDBAndFunctionSymbol(AND_STR, arity, this.dbBooleanType);
    }

    protected DBBooleanFunctionSymbol createDBOr(int arity) {
        return new DefaultDBOrFunctionSymbol(OR_STR, arity, this.dbBooleanType);
    }

    protected DBNotFunctionSymbol createDBNotFunctionSymbol(DBTermType dbBooleanType) {
        return new DefaultDBNotFunctionSymbol(NOT_STR, dbBooleanType);
    }

    protected DBFunctionSymbol createDBIfThenElse(DBTermType dbBooleanType, DBTermType abstractRootDBType) {
        return new DefaultSQLIfThenElseFunctionSymbol(dbBooleanType, abstractRootDBType);
    }

    protected DBBooleanFunctionSymbol createIsStringEmpty(DBTermType dbBooleanType, DBTermType abstractRootDBType) {
        return new DefaultSQLIsStringEmptyFunctionSymbol(dbBooleanType, abstractRootDBType);
    }

    protected DBIsNullOrNotFunctionSymbol createDBIsNull(DBTermType dbBooleanType, DBTermType rootDBTermType) {
        return new DefaultSQLDBIsNullOrNotFunctionSymbol(true, dbBooleanType, rootDBTermType);
    }

    protected DBIsNullOrNotFunctionSymbol createDBIsNotNull(DBTermType dbBooleanType, DBTermType rootDBTermType) {
        return new DefaultSQLDBIsNullOrNotFunctionSymbol(false, dbBooleanType, rootDBTermType);
    }

    protected DBIsTrueFunctionSymbol createDBIsTrue(DBTermType dbBooleanType) {
        return new DefaultDBIsTrueFunctionSymbol(dbBooleanType);
    }

    protected DBTypeConversionFunctionSymbol createSimpleCastFunctionSymbol(DBTermType targetType) {
        return new DefaultSimpleDBCastFunctionSymbol(this.dbTypeFactory.getAbstractRootDBType(), targetType, Serializers.getCastSerializer((DBTermType)targetType));
    }

    protected DBTypeConversionFunctionSymbol createSimpleCastFunctionSymbol(DBTermType inputType, DBTermType targetType) {
        if (targetType.equals(this.dbBooleanType)) {
            return new DefaultSimpleDBBooleanCastFunctionSymbol(inputType, targetType, Serializers.getCastSerializer((DBTermType)targetType));
        }
        DBTermType.Category inputCategory = inputType.getCategory();
        if (inputCategory.equals((Object)targetType.getCategory())) {
            switch (inputCategory) {
                case INTEGER: {
                    return this.createIntegerToIntegerCastFunctionSymbol(inputType, targetType);
                }
                case DECIMAL: {
                    return this.createDecimalToDecimalCastFunctionSymbol(inputType, targetType);
                }
                case FLOAT_DOUBLE: {
                    return this.createFloatDoubleToFloatDoubleCastFunctionSymbol(inputType, targetType);
                }
                case STRING: {
                    return this.createStringToStringCastFunctionSymbol(inputType, targetType);
                }
                case DATETIME: {
                    return this.createDatetimeToDatetimeCastFunctionSymbol(inputType, targetType);
                }
            }
            return new DefaultSimpleDBCastFunctionSymbol(inputType, targetType, Serializers.getCastSerializer((DBTermType)targetType));
        }
        if (targetType.equals(this.dbStringType)) {
            switch (inputCategory) {
                case INTEGER: {
                    return this.createIntegerToStringCastFunctionSymbol(inputType);
                }
                case DECIMAL: {
                    return this.createDecimalToStringCastFunctionSymbol(inputType);
                }
                case FLOAT_DOUBLE: {
                    return this.createFloatDoubleToStringCastFunctionSymbol(inputType);
                }
            }
            return this.createDefaultCastToStringFunctionSymbol(inputType);
        }
        return new DefaultSimpleDBCastFunctionSymbol(inputType, targetType, Serializers.getCastSerializer((DBTermType)targetType));
    }

    protected DBTypeConversionFunctionSymbol createIntegerToIntegerCastFunctionSymbol(DBTermType inputType, DBTermType targetType) {
        return new DefaultImplicitDBCastFunctionSymbol(inputType, targetType);
    }

    protected DBTypeConversionFunctionSymbol createDecimalToDecimalCastFunctionSymbol(DBTermType inputType, DBTermType targetType) {
        return new DefaultSimpleDBCastFunctionSymbol(inputType, targetType, Serializers.getCastSerializer((DBTermType)targetType));
    }

    protected DBTypeConversionFunctionSymbol createFloatDoubleToFloatDoubleCastFunctionSymbol(DBTermType inputType, DBTermType targetType) {
        return new DefaultSimpleDBCastFunctionSymbol(inputType, targetType, Serializers.getCastSerializer((DBTermType)targetType));
    }

    protected DBTypeConversionFunctionSymbol createStringToStringCastFunctionSymbol(DBTermType inputType, DBTermType targetType) {
        return new DefaultImplicitDBCastFunctionSymbol(inputType, targetType);
    }

    protected DBTypeConversionFunctionSymbol createDatetimeToDatetimeCastFunctionSymbol(DBTermType inputType, DBTermType targetType) {
        return new DefaultSimpleDBCastFunctionSymbol(inputType, targetType, Serializers.getCastSerializer((DBTermType)targetType));
    }

    protected DBTypeConversionFunctionSymbol createIntegerToStringCastFunctionSymbol(DBTermType inputType) {
        return new DefaultCastIntegerToStringFunctionSymbol(inputType, this.dbStringType, Serializers.getCastSerializer((DBTermType)this.dbStringType));
    }

    protected DBTypeConversionFunctionSymbol createDecimalToStringCastFunctionSymbol(DBTermType inputType) {
        return this.createDefaultCastToStringFunctionSymbol(inputType);
    }

    protected DBTypeConversionFunctionSymbol createFloatDoubleToStringCastFunctionSymbol(DBTermType inputType) {
        return this.createDefaultCastToStringFunctionSymbol(inputType);
    }

    protected DBTypeConversionFunctionSymbol createDefaultCastToStringFunctionSymbol(DBTermType inputType) {
        return new DefaultSimpleDBCastFunctionSymbol(inputType, this.dbStringType, Serializers.getCastSerializer((DBTermType)this.dbStringType));
    }

    protected DBFunctionSymbol createDBCase(int arity, boolean doOrderingMatter) {
        return new DefaultDBCaseFunctionSymbol(arity, this.dbBooleanType, this.abstractRootDBType, doOrderingMatter);
    }

    protected DBBooleanFunctionSymbol createDBBooleanCase(int arity, boolean doOrderingMatter) {
        return new DBBooleanCaseFunctionSymbolImpl(arity, this.dbBooleanType, this.abstractRootDBType, doOrderingMatter);
    }

    protected DBFunctionSymbol createCoalesceFunctionSymbol(int arity) {
        return new DefaultDBCoalesceFunctionSymbol(COALESCE_STR, arity, this.abstractRootDBType, Serializers.getRegularSerializer((String)COALESCE_STR));
    }

    protected DBStrictEqFunctionSymbol createDBStrictEquality(int arity) {
        return new DefaultDBStrictEqFunctionSymbol(arity, this.abstractRootType, this.dbBooleanType);
    }

    protected DBBooleanFunctionSymbol createDBStrictNEquality(int arity) {
        return new DefaultDBStrictNEqFunctionSymbol(arity, this.abstractRootType, this.dbBooleanType);
    }

    protected DBFunctionSymbol createEncodeURLorIRI(boolean preserveInternationalChars) {
        return new DefaultSQLEncodeURLorIRIFunctionSymbol(this.dbStringType, preserveInternationalChars);
    }

    protected DBFunctionSymbol createAbsFunctionSymbol(DBTermType dbTermType) {
        return new DefaultSQLSimpleMultitypedDBFunctionSymbolImpl(ABS_STR, 1, dbTermType, false);
    }

    protected DBFunctionSymbol createCeilFunctionSymbol(DBTermType dbTermType) {
        return new DefaultSQLSimpleMultitypedDBFunctionSymbolImpl(CEIL_STR, 1, dbTermType, false);
    }

    protected DBFunctionSymbol createFloorFunctionSymbol(DBTermType dbTermType) {
        return new DefaultSQLSimpleMultitypedDBFunctionSymbolImpl(FLOOR_STR, 1, dbTermType, false);
    }

    protected DBFunctionSymbol createRoundFunctionSymbol(DBTermType dbTermType) {
        return new DefaultSQLSimpleMultitypedDBFunctionSymbolImpl(ROUND_STR, 1, dbTermType, false);
    }

    protected String serializeYearFromDatetime(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return this.serializeYear(terms, termConverter, termFactory);
    }

    protected String serializeYearFromDate(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return this.serializeYear(terms, termConverter, termFactory);
    }

    protected String serializeYear(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("EXTRACT(YEAR FROM %s)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeMonthFromDatetime(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return this.serializeMonth(terms, termConverter, termFactory);
    }

    protected String serializeMonthFromDate(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return this.serializeMonth(terms, termConverter, termFactory);
    }

    protected String serializeMonth(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("EXTRACT(MONTH FROM %s)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeDayFromDatetime(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return this.serializeDay(terms, termConverter, termFactory);
    }

    protected String serializeDayFromDate(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return this.serializeDay(terms, termConverter, termFactory);
    }

    protected String serializeDay(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("EXTRACT(DAY FROM %s)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeHours(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("EXTRACT(HOUR FROM %s)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeMinutes(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("EXTRACT(MINUTE FROM %s)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSeconds(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("EXTRACT(SECOND FROM %s)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected DBTypeConversionFunctionSymbol createDateTimeNormFunctionSymbol(DBTermType dbDateTimestampType) {
        return new DefaultSQLTimestampISONormFunctionSymbol(dbDateTimestampType, this.dbStringType, this::serializeDateTimeNorm);
    }

    protected abstract String serializeDateTimeNorm(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected DBTypeConversionFunctionSymbol createBooleanNormFunctionSymbol(DBTermType booleanType) {
        return new DefaultBooleanNormFunctionSymbol(booleanType, this.dbStringType);
    }

    protected DBTypeConversionFunctionSymbol createDateTimeDenormFunctionSymbol(DBTermType timestampType) {
        return new DefaultSQLTimestampISODenormFunctionSymbol(timestampType, this.dbStringType);
    }

    protected DBTypeConversionFunctionSymbol createBooleanDenormFunctionSymbol() {
        return new DefaultBooleanDenormFunctionSymbol(this.dbBooleanType, this.dbStringType);
    }

    protected DBMathBinaryOperator createMultiplyOperator(DBTermType dbNumericType) {
        return new DefaultTypedDBMathBinaryOperator(MULTIPLY_STR, dbNumericType);
    }

    protected DBMathBinaryOperator createDivideOperator(DBTermType dbNumericType) {
        return new DefaultTypedDBMathBinaryOperator(DIVIDE_STR, dbNumericType);
    }

    protected DBMathBinaryOperator createAddOperator(DBTermType dbNumericType) {
        return new DefaultTypedDBMathBinaryOperator(ADD_STR, dbNumericType);
    }

    protected DBMathBinaryOperator createSubtractOperator(DBTermType dbNumericType) {
        return new DefaultTypedDBMathBinaryOperator(SUBTRACT_STR, dbNumericType);
    }

    protected DBMathBinaryOperator createUntypedMultiplyOperator() {
        return new DefaultUntypedDBMathBinaryOperator(MULTIPLY_STR, this.abstractRootDBType);
    }

    protected DBMathBinaryOperator createUntypedDivideOperator() {
        return new DefaultUntypedDBMathBinaryOperator(DIVIDE_STR, this.abstractRootDBType);
    }

    protected DBMathBinaryOperator createUntypedAddOperator() {
        return new DefaultUntypedDBMathBinaryOperator(ADD_STR, this.abstractRootDBType);
    }

    protected DBMathBinaryOperator createUntypedSubtractOperator() {
        return new DefaultUntypedDBMathBinaryOperator(SUBTRACT_STR, this.abstractRootDBType);
    }

    protected DBBooleanFunctionSymbol createNonStrictNumericEquality() {
        return new DefaultDBNonStrictNumericEqOperator(this.abstractRootDBType, this.dbBooleanType);
    }

    protected DBBooleanFunctionSymbol createNonStrictStringEquality() {
        return new DefaultDBNonStrictStringEqOperator(this.abstractRootDBType, this.dbBooleanType);
    }

    protected DBBooleanFunctionSymbol createNonStrictDatetimeEquality() {
        return new DefaultDBNonStrictDatetimeEqOperator(this.abstractRootDBType, this.dbBooleanType);
    }

    protected DBBooleanFunctionSymbol createNonStrictDateEquality() {
        return new DefaultDBNonStrictDateEqOperator(this.abstractRootDBType, this.dbBooleanType);
    }

    protected DBBooleanFunctionSymbol createNonStrictDefaultEquality() {
        return new DefaultDBNonStrictDefaultEqOperator(this.abstractRootDBType, this.dbBooleanType);
    }

    protected DBBooleanFunctionSymbol createNumericInequality(InequalityLabel inequalityLabel) {
        return new DefaultDBNumericInequalityOperator(inequalityLabel, this.abstractRootDBType, this.dbBooleanType);
    }

    protected DBBooleanFunctionSymbol createBooleanInequality(InequalityLabel inequalityLabel) {
        return new DefaultDBBooleanInequalityOperator(inequalityLabel, this.abstractRootDBType, this.dbBooleanType);
    }

    protected DBBooleanFunctionSymbol createStringInequality(InequalityLabel inequalityLabel) {
        return new DefaultDBStringInequalityOperator(inequalityLabel, this.abstractRootDBType, this.dbBooleanType);
    }

    protected DBBooleanFunctionSymbol createDatetimeInequality(InequalityLabel inequalityLabel) {
        return new DefaultDBDatetimeInequalityOperator(inequalityLabel, this.abstractRootDBType, this.dbBooleanType);
    }

    protected DBBooleanFunctionSymbol createDateInequality(InequalityLabel inequalityLabel) {
        return new DefaultDBDateInequalityOperator(inequalityLabel, this.abstractRootDBType, this.dbBooleanType);
    }

    protected DBBooleanFunctionSymbol createDefaultInequality(InequalityLabel inequalityLabel) {
        return new DefaultDBDefaultInequalityOperator(inequalityLabel, this.abstractRootDBType, this.dbBooleanType);
    }

    public DBFunctionSymbol getDBIfThenElse() {
        return this.ifThenElse;
    }

    public DBFunctionSymbol getDBNullIf() {
        return this.getRegularDBFunctionSymbol(NULLIF_STR, 2);
    }

    public DBFunctionSymbol getDBUpper() {
        return this.getRegularDBFunctionSymbol(UPPER_STR, 1);
    }

    public DBFunctionSymbol getDBLower() {
        return this.getRegularDBFunctionSymbol(LOWER_STR, 1);
    }

    public DBFunctionSymbol getDBReplace() {
        return this.getRegularDBFunctionSymbol(REPLACE_STR, 3);
    }

    public DBFunctionSymbol getDBRegexpReplace3() {
        return this.getRegularDBFunctionSymbol(REGEXP_REPLACE_STR, 3);
    }

    public DBFunctionSymbol getDBRegexpReplace4() {
        return this.getRegularDBFunctionSymbol(REGEXP_REPLACE_STR, 4);
    }

    public DBFunctionSymbol getDBSubString2() {
        return this.getRegularDBFunctionSymbol(SUBSTRING_STR, 2);
    }

    public DBFunctionSymbol getDBSubString3() {
        return this.getRegularDBFunctionSymbol(SUBSTRING_STR, 3);
    }

    public DBFunctionSymbol getDBRight() {
        return this.getRegularDBFunctionSymbol(RIGHT_STR, 2);
    }

    public DBFunctionSymbol getDBCharLength() {
        return this.getRegularDBFunctionSymbol(CHAR_LENGTH_STR, 1);
    }

    public DBAndFunctionSymbol getDBAnd(int arity) {
        if (arity < 2) {
            throw new IllegalArgumentException("Arity of AND must be >= 2");
        }
        return (DBAndFunctionSymbol)this.getRegularDBFunctionSymbol(AND_STR, arity);
    }

    public DBOrFunctionSymbol getDBOr(int arity) {
        if (arity < 2) {
            throw new IllegalArgumentException("Arity of OR must be >= 2");
        }
        return (DBOrFunctionSymbol)this.getRegularDBFunctionSymbol(OR_STR, arity);
    }

    public DBIsNullOrNotFunctionSymbol getDBIsNull() {
        return this.isNull;
    }

    public DBIsNullOrNotFunctionSymbol getDBIsNotNull() {
        return this.isNotNull;
    }

    public DBBooleanFunctionSymbol getDBIsStringEmpty() {
        return this.isStringEmpty;
    }

    public DBIsTrueFunctionSymbol getIsTrue() {
        return this.isTrue;
    }

    public NonDeterministicDBFunctionSymbol getDBRand(UUID uuid) {
        return new DefaultNonDeterministicNullaryFunctionSymbol(this.getRandNameInDialect(), uuid, this.dbDoubleType);
    }

    public NonDeterministicDBFunctionSymbol getDBUUID(UUID uuid) {
        return new DefaultNonDeterministicNullaryFunctionSymbol(this.getUUIDNameInDialect(), uuid, this.dbStringType);
    }

    public DBFunctionSymbol getDBNow() {
        return this.getRegularDBFunctionSymbol(CURRENT_TIMESTAMP_STR, 0);
    }

    public DBBooleanFunctionSymbol getDBRegexpMatches2() {
        return (DBBooleanFunctionSymbol)this.getRegularDBFunctionSymbol(REGEXP_LIKE_STR, 2);
    }

    public DBBooleanFunctionSymbol getDBRegexpMatches3() {
        return (DBBooleanFunctionSymbol)this.getRegularDBFunctionSymbol(REGEXP_LIKE_STR, 3);
    }

    public DBBooleanFunctionSymbol getDBSTWithin() {
        return (DBBooleanFunctionSymbol)this.getRegularDBFunctionSymbol(ST_WITHIN, 2);
    }

    public DBBooleanFunctionSymbol getDBSTContains() {
        return (DBBooleanFunctionSymbol)this.getRegularDBFunctionSymbol(ST_CONTAINS, 2);
    }

    public DBBooleanFunctionSymbol getDBSTCrosses() {
        return (DBBooleanFunctionSymbol)this.getRegularDBFunctionSymbol(ST_CROSSES, 2);
    }

    public DBBooleanFunctionSymbol getDBSTDisjoint() {
        return (DBBooleanFunctionSymbol)this.getRegularDBFunctionSymbol(ST_DISJOINT, 2);
    }

    public DBBooleanFunctionSymbol getDBSTEquals() {
        return (DBBooleanFunctionSymbol)this.getRegularDBFunctionSymbol(ST_EQUALS, 2);
    }

    public DBBooleanFunctionSymbol getDBSTIntersects() {
        return (DBBooleanFunctionSymbol)this.getRegularDBFunctionSymbol(ST_INTERSECTS, 2);
    }

    public DBBooleanFunctionSymbol getDBSTOverlaps() {
        return (DBBooleanFunctionSymbol)this.getRegularDBFunctionSymbol(ST_OVERLAPS, 2);
    }

    public DBBooleanFunctionSymbol getDBSTTouches() {
        return (DBBooleanFunctionSymbol)this.getRegularDBFunctionSymbol(ST_TOUCHES, 2);
    }

    public DBBooleanFunctionSymbol getDBSTCoveredBy() {
        return (DBBooleanFunctionSymbol)this.getRegularDBFunctionSymbol(ST_COVEREDBY, 2);
    }

    public DBBooleanFunctionSymbol getDBSTCovers() {
        return (DBBooleanFunctionSymbol)this.getRegularDBFunctionSymbol(ST_COVERS, 2);
    }

    public DBBooleanFunctionSymbol getDBSTContainsProperly() {
        return (DBBooleanFunctionSymbol)this.getRegularDBFunctionSymbol(ST_CONTAINSPROPERLY, 2);
    }

    public DBFunctionSymbol getDBSTDistance() {
        return this.getRegularDBFunctionSymbol(ST_DISTANCE, 2);
    }

    public DBFunctionSymbol getDBSTDistanceSphere() {
        return this.getRegularDBFunctionSymbol(ST_DISTANCE_SPHERE, 2);
    }

    public DBFunctionSymbol getDBSTDistanceSpheroid() {
        return this.getRegularDBFunctionSymbol(ST_DISTANCE_SPHEROID, 3);
    }

    public FunctionSymbol getDBAsText() {
        return this.getRegularDBFunctionSymbol(ST_ASTEXT, 1);
    }

    public FunctionSymbol getDBSTFlipCoordinates() {
        return this.getRegularDBFunctionSymbol(ST_FLIP_COORDINATES, 1);
    }

    public FunctionSymbol getDBBuffer() {
        return this.getRegularDBFunctionSymbol(ST_BUFFER, 2);
    }

    public FunctionSymbol getDBIntersection() {
        return this.getRegularDBFunctionSymbol(ST_INTERSECTION, 2);
    }

    public FunctionSymbol getDBBoundary() {
        return this.getRegularDBFunctionSymbol(ST_BOUNDARY, 1);
    }

    public FunctionSymbol getDBConvexHull() {
        return this.getRegularDBFunctionSymbol(ST_CONVEXHULL, 1);
    }

    public FunctionSymbol getDBDifference() {
        return this.getRegularDBFunctionSymbol(ST_DIFFERENCE, 2);
    }

    public FunctionSymbol getDBEnvelope() {
        return this.getRegularDBFunctionSymbol(ST_ENVELOPE, 1);
    }

    public FunctionSymbol getDBSymDifference() {
        return this.getRegularDBFunctionSymbol(ST_SYMDIFFERENCE, 2);
    }

    public FunctionSymbol getDBUnion() {
        return this.getRegularDBFunctionSymbol(ST_UNION, 2);
    }

    public DBBooleanFunctionSymbol getDBRelate() {
        return (DBBooleanFunctionSymbol)this.getRegularDBFunctionSymbol(ST_RELATE, 3);
    }

    public FunctionSymbol getDBRelateMatrix() {
        return this.getRegularDBFunctionSymbol(ST_RELATE, 2);
    }

    public DBFunctionSymbol getDBGetSRID() {
        return this.getRegularDBFunctionSymbol(ST_SRID, 1);
    }

    public DBFunctionSymbol getDBSTTransform() {
        return this.getRegularDBFunctionSymbol(ST_TRANSFORM, 2);
    }

    public DBFunctionSymbol getDBSTSetSRID() {
        return this.getRegularDBFunctionSymbol(ST_SETSRID, 2);
    }

    protected String getRandNameInDialect() {
        return RAND_STR;
    }

    protected abstract String getUUIDNameInDialect();

    protected String serializeDBRowNumber(Function<ImmutableTerm, String> converter, TermFactory termFactory) {
        return "ROW_NUMBER() OVER ()";
    }
}

