/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.normalization.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.generation.normalization.DialectExtraNormalizer;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonGroundTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Map;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class WrapProjectedOrOrderByExpressionNormalizer
extends DefaultRecursiveIQTreeVisitingTransformer
implements DialectExtraNormalizer {
    private final SubstitutionFactory substitutionFactory;
    private final TermFactory termFactory;

    @Inject
    protected WrapProjectedOrOrderByExpressionNormalizer(IntermediateQueryFactory iqFactory, SubstitutionFactory substitutionFactory, TermFactory termFactory) {
        super(iqFactory);
        this.substitutionFactory = substitutionFactory;
        this.termFactory = termFactory;
    }

    @Override
    public IQTree transform(IQTree tree, VariableGenerator variableGenerator) {
        return this.transform(tree);
    }

    public IQTree transformConstruction(IQTree tree, ConstructionNode rootNode, IQTree child) {
        IQTree newChild = this.transform(child);
        ImmutableMap initialSubstitutionMap = rootNode.getSubstitution().getImmutableMap();
        ImmutableMap newSubstitutionMap = (ImmutableMap)initialSubstitutionMap.entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.transformDefinition((ImmutableTerm)e.getValue())));
        ConstructionNode newRootNode = newSubstitutionMap.equals((Object)initialSubstitutionMap) ? rootNode : this.iqFactory.createConstructionNode(rootNode.getVariables(), this.substitutionFactory.getSubstitution(newSubstitutionMap));
        return newRootNode == rootNode && child == newChild ? tree : this.iqFactory.createUnaryIQTree((UnaryOperatorNode)newRootNode, newChild);
    }

    private ImmutableTerm transformDefinition(ImmutableTerm definition) {
        return definition instanceof ImmutableExpression ? this.transformExpression((ImmutableExpression)definition) : definition;
    }

    public IQTree transformOrderBy(IQTree tree, OrderByNode rootNode, IQTree child) {
        ImmutableList newComparators;
        IQTree newChild = this.transform(child);
        ImmutableList initialComparators = rootNode.getComparators();
        OrderByNode newRootNode = initialComparators.equals((Object)(newComparators = (ImmutableList)initialComparators.stream().map(c -> this.iqFactory.createOrderComparator(this.transformOrderTerm(c.getTerm()), c.isAscending())).collect(ImmutableCollectors.toList()))) ? rootNode : this.iqFactory.createOrderByNode(newComparators);
        return newRootNode == rootNode && child == newChild ? tree : this.iqFactory.createUnaryIQTree((UnaryOperatorNode)newRootNode, newChild);
    }

    private NonGroundTerm transformOrderTerm(NonGroundTerm term) {
        if (term instanceof ImmutableExpression) {
            return (NonGroundTerm)this.transformExpression((ImmutableExpression)term);
        }
        return term;
    }

    protected ImmutableFunctionalTerm transformExpression(ImmutableExpression definition) {
        return this.termFactory.getDBCaseElseNull(Stream.of(Maps.immutableEntry((Object)definition, (Object)this.termFactory.getDBBooleanConstant(true)), Maps.immutableEntry((Object)this.termFactory.getDBNot(definition), (Object)this.termFactory.getDBBooleanConstant(false))), false);
    }
}

