/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.normalization.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.generation.normalization.DialectExtraNormalizer;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.SliceNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonGroundTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.db.NonDeterministicDBFunctionSymbol;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class ProjectOrderByTermsNormalizer
implements DialectExtraNormalizer {
    private final boolean onlyInPresenceOfDistinct;
    private final SubstitutionFactory substitutionFactory;
    private final IntermediateQueryFactory iqFactory;

    protected ProjectOrderByTermsNormalizer(boolean onlyInPresenceOfDistinct, CoreSingletons coreSingletons) {
        this.onlyInPresenceOfDistinct = onlyInPresenceOfDistinct;
        this.substitutionFactory = coreSingletons.getSubstitutionFactory();
        this.iqFactory = coreSingletons.getIQFactory();
    }

    @Override
    public IQTree transform(IQTree tree, VariableGenerator variableGenerator) {
        return this.analyze(tree).map(a -> this.normalize(tree, (Analysis)a, variableGenerator)).orElse(tree);
    }

    private Optional<Analysis> analyze(IQTree tree) {
        QueryNode rootNode = tree.getRootNode();
        Optional<SliceNode> sliceNode = Optional.of(rootNode).filter(n -> n instanceof SliceNode).map(n -> (SliceNode)n);
        IQTree firstNonSliceTree = sliceNode.map(n -> ((UnaryIQTree)tree).getChild()).orElse(tree);
        Optional<DistinctNode> distinctNode = Optional.of(firstNonSliceTree).map(IQTree::getRootNode).filter(n -> n instanceof DistinctNode).map(n -> (DistinctNode)n);
        IQTree firstNonSliceDistinctTree = distinctNode.map(n -> ((UnaryIQTree)firstNonSliceTree).getChild()).orElse(firstNonSliceTree);
        Optional<ConstructionNode> constructionNode = Optional.of(firstNonSliceDistinctTree).map(IQTree::getRootNode).filter(n -> n instanceof ConstructionNode).map(n -> (ConstructionNode)n);
        IQTree firstNonSliceDistinctConstructionTree = constructionNode.map(n -> ((UnaryIQTree)firstNonSliceDistinctTree).getChild()).orElse(firstNonSliceDistinctTree);
        Optional<OrderByNode> orderByNode = Optional.of(firstNonSliceDistinctConstructionTree).map(IQTree::getRootNode).filter(n -> n instanceof OrderByNode).map(n -> (OrderByNode)n);
        return orderByNode.filter(o -> distinctNode.isPresent() || !this.onlyInPresenceOfDistinct).map(o -> new Analysis(distinctNode.isPresent(), constructionNode, o.getComparators()));
    }

    private IQTree normalize(IQTree tree, Analysis analysis, VariableGenerator variableGenerator) {
        ImmutableSet projectedVariables = tree.getVariables();
        ImmutableSet alreadyDefinedTerms = analysis.constructionNode.map(c -> (ImmutableSet)Stream.concat(projectedVariables.stream(), c.getSubstitution().getImmutableMap().values().stream()).collect(ImmutableCollectors.toSet())).orElseGet(() -> tree.getVariables());
        ImmutableSet newBindings = (ImmutableSet)analysis.sortConditions.stream().map(OrderByNode.OrderComparator::getTerm).filter(t -> !alreadyDefinedTerms.contains(t)).map(t -> t instanceof Variable ? Maps.immutableEntry((Object)((Variable)t), (Object)t) : Maps.immutableEntry((Object)variableGenerator.generateNewVariable(), (Object)t)).collect(ImmutableCollectors.toSet());
        if (newBindings.isEmpty()) {
            return tree;
        }
        if (!this.isSupported((ImmutableSet<Variable>)projectedVariables, analysis, (ImmutableSet<Map.Entry<Variable, NonGroundTerm>>)newBindings)) {
            throw new DistinctOrderByDialectLimitationException();
        }
        ImmutableSet newProjectedVariables = (ImmutableSet)Stream.concat(projectedVariables.stream(), newBindings.stream().map(Map.Entry::getKey)).collect(ImmutableCollectors.toSet());
        ImmutableSubstitution newSubstitution = this.substitutionFactory.getSubstitution((ImmutableMap)Stream.concat(newBindings.stream().filter(e -> !((Variable)e.getKey()).equals(e.getValue())).map(e -> e), analysis.constructionNode.map(c -> c.getSubstitution().getImmutableMap().entrySet().stream()).orElseGet(Stream::empty)).collect(ImmutableCollectors.toMap()));
        ConstructionNode newConstructionNode = this.iqFactory.createConstructionNode(newProjectedVariables, newSubstitution);
        return analysis.constructionNode.map(n -> this.updateTopConstructionNode(tree, newConstructionNode)).orElseGet(() -> this.insertConstructionNode(tree, newConstructionNode));
    }

    protected boolean isSupported(ImmutableSet<Variable> projectedVariables, Analysis analysis, ImmutableSet<Map.Entry<Variable, NonGroundTerm>> newBindings) {
        if (!analysis.hasDistinct) {
            return true;
        }
        ImmutableSet alreadyProjectedTerms = (ImmutableSet)Stream.concat(projectedVariables.stream(), analysis.constructionNode.map(c -> c.getSubstitution().getImmutableMap().values().stream()).orElseGet(Stream::empty)).collect(ImmutableCollectors.toSet());
        return newBindings.stream().map(Map.Entry::getValue).noneMatch(t -> this.mayImpactDistinct((ImmutableTerm)t, (ImmutableSet<ImmutableTerm>)alreadyProjectedTerms));
    }

    protected boolean mayImpactDistinct(ImmutableTerm term, ImmutableSet<ImmutableTerm> alreadyProjectedTerms) {
        if (term instanceof ImmutableFunctionalTerm) {
            ImmutableFunctionalTerm functionalTerm = (ImmutableFunctionalTerm)term;
            if (functionalTerm.getFunctionSymbol() instanceof NonDeterministicDBFunctionSymbol) {
                return true;
            }
            if (alreadyProjectedTerms.contains((Object)term)) {
                return false;
            }
            return functionalTerm.getTerms().stream().anyMatch(t -> this.mayImpactDistinct((ImmutableTerm)t, alreadyProjectedTerms));
        }
        if (term instanceof Variable) {
            return !alreadyProjectedTerms.contains((Object)term);
        }
        return false;
    }

    private IQTree updateTopConstructionNode(IQTree tree, ConstructionNode newConstructionNode) {
        QueryNode rootNode = tree.getRootNode();
        if (rootNode instanceof ConstructionNode) {
            return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)newConstructionNode, ((UnaryIQTree)tree).getChild());
        }
        if (rootNode instanceof UnaryOperatorNode) {
            return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)rootNode, this.updateTopConstructionNode(((UnaryIQTree)tree).getChild(), newConstructionNode));
        }
        throw new MinorOntopInternalBugException("Was expected to reach a ConstructionNode before a non-unary node");
    }

    private IQTree insertConstructionNode(IQTree tree, ConstructionNode newConstructionNode) {
        QueryNode rootNode = tree.getRootNode();
        if (rootNode instanceof DistinctNode || rootNode instanceof SliceNode) {
            return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)rootNode, this.insertConstructionNode(((UnaryIQTree)tree).getChild(), newConstructionNode));
        }
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)newConstructionNode, tree);
    }

    private static class DistinctOrderByDialectLimitationException
    extends OntopInternalBugException {
        protected DistinctOrderByDialectLimitationException() {
            super("The dialect requires ORDER BY conditions to be projected but a DISTINCT prevents some of them");
        }
    }

    private static class Analysis {
        private final boolean hasDistinct;
        private final Optional<ConstructionNode> constructionNode;
        private final ImmutableList<OrderByNode.OrderComparator> sortConditions;

        private Analysis(boolean hasDistinct, Optional<ConstructionNode> constructionNode, ImmutableList<OrderByNode.OrderComparator> sortConditions) {
            this.hasDistinct = hasDistinct;
            this.constructionNode = constructionNode;
            this.sortConditions = sortConditions;
        }
    }
}

