/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.OntopViewDefinition;
import it.unibz.inf.ontop.dbschema.impl.json.JsonBasicView;
import it.unibz.inf.ontop.dbschema.impl.json.JsonOpenObject;
import it.unibz.inf.ontop.dbschema.impl.json.JsonSQLView;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.model.atom.impl.AtomPredicateImpl;
import it.unibz.inf.ontop.model.type.TermType;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;

@JsonDeserialize(using=JSONViewDeSerializer.class)
public abstract class JsonView
extends JsonOpenObject {
    @Nonnull
    public final List<String> name;

    public JsonView(List<String> name) {
        this.name = name;
    }

    public abstract OntopViewDefinition createViewDefinition(DBParameters var1, MetadataLookup var2) throws MetadataExtractionException;

    public abstract void insertIntegrityConstraints(NamedRelationDefinition var1, ImmutableList<NamedRelationDefinition> var2, MetadataLookup var3) throws MetadataExtractionException;

    public static class JSONViewDeSerializer
    extends JsonDeserializer<JsonView> {
        public JsonView deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            Class instanceClass;
            String type;
            ObjectMapper mapper = (ObjectMapper)jp.getCodec();
            JsonNode node = (JsonNode)mapper.readTree(jp);
            switch (type = node.get("type").asText()) {
                case "BasicViewDefinition": {
                    instanceClass = JsonBasicView.class;
                    break;
                }
                case "SQLViewDefinition": {
                    instanceClass = JsonSQLView.class;
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported type of Ontop views: " + type);
                }
            }
            return (JsonView)mapper.treeToValue((TreeNode)node, instanceClass);
        }
    }

    protected static class TemporaryViewPredicate
    extends AtomPredicateImpl {
        protected TemporaryViewPredicate(String name, ImmutableList<TermType> baseTypesForValidation) {
            super(name, baseTypesForValidation);
        }
    }
}

