/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.dbschema.impl.json.JsonMetadata;
import it.unibz.inf.ontop.dbschema.impl.json.JsonOpenObject;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "determinants", "isPrimaryKey"})
public class JsonUniqueConstraint
extends JsonOpenObject {
    public final String name;
    public final List<String> determinants;
    public final Boolean isPrimaryKey;

    @JsonCreator
    public JsonUniqueConstraint(@JsonProperty(value="name") String name, @JsonProperty(value="determinants") List<String> determinants, @JsonProperty(value="isPrimaryKey") Boolean isPrimaryKey) {
        this.name = name;
        this.determinants = determinants;
        this.isPrimaryKey = isPrimaryKey;
    }

    public JsonUniqueConstraint(UniqueConstraint uc) {
        this.name = uc.getName();
        this.isPrimaryKey = uc.isPrimaryKey();
        this.determinants = JsonMetadata.serializeAttributeList(uc.getAttributes().stream());
    }

    public void insert(NamedRelationDefinition relation, QuotedIDFactory idFactory) throws MetadataExtractionException {
        FunctionalDependency.Builder builder = UniqueConstraint.builder((NamedRelationDefinition)relation, (String)this.name);
        JsonMetadata.deserializeAttributeList(idFactory, this.determinants, arg_0 -> ((FunctionalDependency.Builder)builder).addDeterminant(arg_0));
        builder.build();
    }
}

