/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Lists;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.OntopViewDefinition;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.dbschema.impl.AbstractRelationDefinition;
import it.unibz.inf.ontop.dbschema.impl.OntopViewDefinitionImpl;
import it.unibz.inf.ontop.dbschema.impl.RawQuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.json.JsonMetadata;
import it.unibz.inf.ontop.dbschema.impl.json.JsonOpenObject;
import it.unibz.inf.ontop.dbschema.impl.json.JsonView;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.type.NotYetTypedEqualityTransformer;
import it.unibz.inf.ontop.iq.type.UniqueTermTypeExtractor;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.spec.sqlparser.RAExpression;
import it.unibz.inf.ontop.spec.sqlparser.RAExpression2IQConverter;
import it.unibz.inf.ontop.spec.sqlparser.SQLQueryParser;
import it.unibz.inf.ontop.spec.sqlparser.exception.InvalidSelectQueryException;
import it.unibz.inf.ontop.spec.sqlparser.exception.UnsupportedSelectQueryException;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.sf.jsqlparser.JSQLParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonPropertyOrder(value={"relations"})
@JsonDeserialize(as=JsonSQLView.class)
public class JsonSQLView
extends JsonView {
    @Nonnull
    public final String query;
    @Nonnull
    public final UniqueConstraints uniqueConstraints;
    @Nonnull
    public final OtherFunctionalDependencies otherFunctionalDependencies;
    @Nonnull
    public final ForeignKeys foreignKeys;
    protected static final Logger LOGGER = LoggerFactory.getLogger(JsonSQLView.class);

    @JsonCreator
    public JsonSQLView(@JsonProperty(value="name") List<String> name, @JsonProperty(value="query") String query, @JsonProperty(value="uniqueConstraints") UniqueConstraints uniqueConstraints, @JsonProperty(value="otherFunctionalDependencies") OtherFunctionalDependencies otherFunctionalDependencies, @JsonProperty(value="foreignKeys") ForeignKeys foreignKeys) {
        super(name);
        this.query = query;
        this.uniqueConstraints = uniqueConstraints;
        this.otherFunctionalDependencies = otherFunctionalDependencies;
        this.foreignKeys = foreignKeys;
    }

    @Override
    public OntopViewDefinition createViewDefinition(DBParameters dbParameters, MetadataLookup parentCacheMetadataLookup) throws MetadataExtractionException {
        QuotedIDFactory quotedIDFactory = dbParameters.getQuotedIDFactory();
        RelationID relationId = quotedIDFactory.createRelationID(this.name.toArray(new String[0]));
        IQ iq = this.createIQ(relationId, dbParameters, parentCacheMetadataLookup);
        RelationDefinition.AttributeListBuilder attributeBuilder = this.createAttributeBuilder(iq, dbParameters);
        return new OntopViewDefinitionImpl(ImmutableList.of((Object)relationId), attributeBuilder, iq, 1, dbParameters.getCoreSingletons());
    }

    @Override
    public void insertIntegrityConstraints(NamedRelationDefinition relation, ImmutableList<NamedRelationDefinition> baseRelations, MetadataLookup metadataLookupForFK) throws MetadataExtractionException {
        QuotedIDFactory idFactory = metadataLookupForFK.getQuotedIDFactory();
        this.insertUniqueConstraints(relation, idFactory, this.uniqueConstraints.added);
        this.insertFunctionalDependencies(relation, idFactory, this.otherFunctionalDependencies.added);
    }

    private IQ createIQ(RelationID relationId, DBParameters dbParameters, MetadataLookup parentCacheMetadataLookup) throws MetadataExtractionException {
        IQTree iqTree;
        RAExpression raExpression;
        CoreSingletons coreSingletons = dbParameters.getCoreSingletons();
        TermFactory termFactory = coreSingletons.getTermFactory();
        IntermediateQueryFactory iqFactory = coreSingletons.getIQFactory();
        AtomFactory atomFactory = coreSingletons.getAtomFactory();
        RAExpression2IQConverter raExpression2IQConverter = new RAExpression2IQConverter(coreSingletons);
        try {
            raExpression = this.extractRAExpression(dbParameters, parentCacheMetadataLookup);
            iqTree = raExpression2IQConverter.convert(raExpression);
        }
        catch (InvalidSelectQueryException | UnsupportedSelectQueryException | JSQLParserException e2) {
            throw new MetadataExtractionException("Unsupported expression for :\n" + e2);
        }
        ImmutableMap map1 = (ImmutableMap)raExpression.getAttributes().asMap().entrySet().stream().collect(ImmutableCollectors.toMap(e -> termFactory.getVariable(((ImmutableTerm)e.getValue()).toString()), e -> termFactory.getVariable(((QualifiedAttributeID)e.getKey()).getAttribute().getName())));
        SubstitutionFactory substitutionFactory = coreSingletons.getSubstitutionFactory();
        InjectiveVar2VarSubstitution injectiveVar2VarSubstitution = substitutionFactory.getInjectiveVar2VarSubstitution(map1);
        IQTree iqTreeRenamedVariables = iqTree.applyFreshRenaming(injectiveVar2VarSubstitution);
        NotYetTypedEqualityTransformer notYetTypedEqualityTransformer = coreSingletons.getNotYetTypedEqualityTransformer();
        IQTree iqTreeTransformed = notYetTypedEqualityTransformer.transform(iqTreeRenamedVariables);
        ImmutableSet iqTreeVariables = iqTree.getVariables();
        ArrayList targetList = Lists.newArrayList((Iterable)iqTreeVariables);
        ImmutableList projectedVariables = ImmutableList.copyOf((Collection)targetList);
        AtomPredicate tmpPredicate = this.createTemporaryPredicate(relationId, projectedVariables.size(), coreSingletons);
        DistinctVariableOnlyDataAtom projectionAtom = atomFactory.getDistinctVariableOnlyDataAtom(tmpPredicate, projectedVariables);
        DistinctVariableOnlyDataAtom projectionAtomWithSubstitution = injectiveVar2VarSubstitution.applyToDistinctVariableOnlyDataAtom(projectionAtom);
        return iqFactory.createIQ(projectionAtomWithSubstitution, iqTreeTransformed).normalizeForOptimization();
    }

    private RAExpression extractRAExpression(DBParameters dbParameters, MetadataLookup metadataLookup) throws JSQLParserException, UnsupportedSelectQueryException, InvalidSelectQueryException {
        CoreSingletons coreSingletons = dbParameters.getCoreSingletons();
        SQLQueryParser sq = new SQLQueryParser(coreSingletons);
        return sq.getRAExpression(this.query, metadataLookup);
    }

    private AtomPredicate createTemporaryPredicate(RelationID relationId, int arity, CoreSingletons coreSingletons) {
        DBTermType dbRootType = coreSingletons.getTypeFactory().getDBTypeFactory().getAbstractRootDBType();
        return new JsonView.TemporaryViewPredicate(relationId.getSQLRendering(), (ImmutableList<TermType>)((ImmutableList)IntStream.range(0, arity).boxed().map(i -> dbRootType).collect(ImmutableCollectors.toList())));
    }

    private RelationDefinition.AttributeListBuilder createAttributeBuilder(IQ iq, DBParameters dbParameters) throws MetadataExtractionException {
        UniqueTermTypeExtractor uniqueTermTypeExtractor = dbParameters.getCoreSingletons().getUniqueTermTypeExtractor();
        QuotedIDFactory quotedIdFactory = dbParameters.getQuotedIDFactory();
        DBTypeFactory dbTypeFactory = dbParameters.getDBTypeFactory();
        RelationDefinition.AttributeListBuilder builder = AbstractRelationDefinition.attributeListBuilder();
        IQTree iqTree = iq.getTree();
        RawQuotedIDFactory rawQuotedIqFactory = new RawQuotedIDFactory(quotedIdFactory);
        for (Variable v : iqTree.getVariables()) {
            builder.addAttribute(rawQuotedIqFactory.createAttributeID(v.getName()), (DBTermType)uniqueTermTypeExtractor.extractUniqueTermType((ImmutableTerm)v, iqTree).orElseGet(() -> ((DBTypeFactory)dbTypeFactory).getAbstractRootDBType()), iqTree.getVariableNullability().isPossiblyNullable(v));
        }
        return builder;
    }

    private void insertUniqueConstraints(NamedRelationDefinition relation, QuotedIDFactory idFactory, List<AddUniqueConstraints> addUniqueConstraints) throws MetadataExtractionException {
        for (AddUniqueConstraints addUC : addUniqueConstraints) {
            if (addUC.isPrimaryKey != null && addUC.isPrimaryKey.booleanValue()) {
                LOGGER.warn("Primary key set in the view file for " + addUC.name);
            }
            FunctionalDependency.Builder builder = UniqueConstraint.builder((NamedRelationDefinition)relation, (String)addUC.name);
            JsonMetadata.deserializeAttributeList(idFactory, addUC.determinants, arg_0 -> ((FunctionalDependency.Builder)builder).addDeterminant(arg_0));
            builder.build();
        }
    }

    private void insertFunctionalDependencies(NamedRelationDefinition relation, QuotedIDFactory idFactory, List<AddFunctionalDependency> addFunctionalDependencies) throws MetadataExtractionException {
        for (AddFunctionalDependency addFD : addFunctionalDependencies) {
            FunctionalDependency.Builder builder = FunctionalDependency.defaultBuilder((NamedRelationDefinition)relation);
            try {
                JsonMetadata.deserializeAttributeList(idFactory, addFD.determinants, arg_0 -> ((FunctionalDependency.Builder)builder).addDeterminant(arg_0));
                JsonMetadata.deserializeAttributeList(idFactory, addFD.dependents, arg_0 -> ((FunctionalDependency.Builder)builder).addDependent(arg_0));
                builder.build();
            }
            catch (MetadataExtractionException e) {
                throw new MetadataExtractionException(String.format("Cannot find attribute for Functional Dependency %s", addFD.determinants));
            }
        }
    }

    @JsonPropertyOrder(value={"relation", "columns"})
    public static class ForeignKeyPart
    extends JsonOpenObject {
        public final List<String> relation;
        public final List<String> columns;

        @JsonCreator
        public ForeignKeyPart(@JsonProperty(value="relation") List<String> relation, @JsonProperty(value="columns") List<String> columns) {
            this.relation = relation;
            this.columns = columns;
        }
    }

    @JsonPropertyOrder(value={"determinants", "dependents"})
    private static class AddForeignKey
    extends JsonOpenObject {
        @Nonnull
        public final String name;
        @Nonnull
        public final String from;
        @Nonnull
        public final ForeignKeyPart to;

        public AddForeignKey(@JsonProperty(value="name") String name, @JsonProperty(value="from") String from, @JsonProperty(value="to") ForeignKeyPart to) {
            this.name = name;
            this.from = from;
            this.to = to;
        }
    }

    private static class ForeignKeys
    extends JsonOpenObject {
        @Nonnull
        public final List<AddForeignKey> added;

        @JsonCreator
        public ForeignKeys(@JsonProperty(value="added") List<AddForeignKey> added) {
            this.added = added;
        }
    }

    @JsonPropertyOrder(value={"determinants", "dependents"})
    private static class AddFunctionalDependency
    extends JsonOpenObject {
        @Nonnull
        public final List<String> determinants;
        @Nonnull
        public final List<String> dependents;

        public AddFunctionalDependency(@JsonProperty(value="determinants") List<String> determinants, @JsonProperty(value="dependents") List<String> dependents) {
            this.determinants = determinants;
            this.dependents = dependents;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddFunctionalDependency other = (AddFunctionalDependency)obj;
            return Objects.equals(ImmutableMap.of(this.determinants, this.dependents), ImmutableMap.of(other.determinants, other.dependents));
        }

        public int hashCode() {
            return Objects.hash(ImmutableMap.of(this.determinants, this.dependents));
        }
    }

    private static class OtherFunctionalDependencies
    extends JsonOpenObject {
        @Nonnull
        public final List<AddFunctionalDependency> added;

        @JsonCreator
        public OtherFunctionalDependencies(@JsonProperty(value="added") List<AddFunctionalDependency> added) {
            this.added = added;
        }
    }

    @JsonPropertyOrder(value={"name", "determinants", "isPrimaryKey"})
    private static class AddUniqueConstraints
    extends JsonOpenObject {
        @Nonnull
        public final String name;
        @Nonnull
        public final List<String> determinants;
        public final Boolean isPrimaryKey;

        @JsonCreator
        public AddUniqueConstraints(@JsonProperty(value="name") String name, @JsonProperty(value="determinants") List<String> determinants, @JsonProperty(value="isPrimaryKey") Boolean isPrimaryKey) {
            this.name = name;
            this.determinants = determinants;
            this.isPrimaryKey = isPrimaryKey;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddUniqueConstraints other = (AddUniqueConstraints)obj;
            return Objects.equals(this.determinants, other.determinants);
        }

        public int hashCode() {
            return Objects.hash(this.determinants);
        }
    }

    @JsonPropertyOrder(value={"added"})
    private static class UniqueConstraints
    extends JsonOpenObject {
        @Nonnull
        public final List<AddUniqueConstraints> added;

        @JsonCreator
        public UniqueConstraints(@JsonProperty(value="added") List<AddUniqueConstraints> added) {
            this.added = added;
        }
    }
}

