/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableBiMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.AttributeNotFoundException;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.ImmutableMetadata;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.DremioQuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.MySQLCaseNotSensitiveTableNamesQuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.MySQLCaseSensitiveTableNamesQuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.PostgreSQLQuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.SQLServerQuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.SQLStandardQuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.json.JsonDatabaseTable;
import it.unibz.inf.ontop.dbschema.impl.json.JsonOpenObject;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.stream.Stream;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"relations"})
public class JsonMetadata
extends JsonOpenObject {
    public final List<JsonDatabaseTable> relations;
    public final Parameters metadata;

    @JsonCreator
    public JsonMetadata(@JsonProperty(value="relations") List<JsonDatabaseTable> relations, @JsonProperty(value="metadata") Parameters metadata) {
        this.relations = relations;
        this.metadata = metadata;
    }

    public JsonMetadata(ImmutableMetadata metadata) {
        this.relations = (List)metadata.getAllRelations().stream().map(JsonDatabaseTable::new).collect(ImmutableCollectors.toList());
        this.metadata = new Parameters(metadata.getDBParameters());
    }

    public static ImmutableList<String> serializeRelationID(RelationID id) {
        return ((ImmutableList)id.getComponents().stream().map(QuotedID::getSQLRendering).collect(ImmutableCollectors.toList())).reverse();
    }

    public static RelationID deserializeRelationID(QuotedIDFactory idFactory, List<String> o) {
        return idFactory.createRelationID(o.toArray(new String[0]));
    }

    public static List<String> serializeAttributeList(Stream<Attribute> attributes) {
        return (List)attributes.map(a -> a.getID().getSQLRendering()).collect(ImmutableCollectors.toList());
    }

    public static void deserializeAttributeList(QuotedIDFactory idFactory, List<String> ids, AttributeConsumer consumer) throws MetadataExtractionException {
        try {
            for (String id : ids) {
                consumer.add(idFactory.createAttributeID(id));
            }
        }
        catch (AttributeNotFoundException e) {
            throw new MetadataExtractionException((Exception)((Object)e));
        }
    }

    public static interface AttributeConsumer {
        public void add(QuotedID var1) throws AttributeNotFoundException;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonPropertyOrder(value={"dbmsProductName", "dbmsVersion", "driverName", "driverVersion", "quotationString", "extractionTime"})
    public static class Parameters
    extends JsonOpenObject {
        public final String dbmsProductName;
        public final String dbmsVersion;
        public final String driverName;
        public final String driverVersion;
        public final String quotationString;
        public final String extractionTime;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public final String idFactoryType;
        private static final ImmutableBiMap<String, Class<? extends QuotedIDFactory>> QUOTED_ID_FACTORIES = ImmutableBiMap.builder().put((Object)"STANDARD", SQLStandardQuotedIDFactory.class).put((Object)"DREMIO", DremioQuotedIDFactory.class).put((Object)"MYSQL-U", MySQLCaseSensitiveTableNamesQuotedIDFactory.class).put((Object)"MYSQL-D", MySQLCaseNotSensitiveTableNamesQuotedIDFactory.class).put((Object)"POSTGRESQL", PostgreSQLQuotedIDFactory.class).put((Object)"MSSQLSERVER", SQLServerQuotedIDFactory.class).build();

        @JsonCreator
        public Parameters(@JsonProperty(value="dbmsProductName") String dbmsProductName, @JsonProperty(value="dbmsVersion") String dbmsVersion, @JsonProperty(value="driverName") String driverName, @JsonProperty(value="driverVersion") String driverVersion, @JsonProperty(value="quotationString") String quotationString, @JsonProperty(value="extractionTime") String extractionTime, @JsonProperty(value="idFactoryType") String idFactoryType) {
            this.dbmsProductName = dbmsProductName;
            this.dbmsVersion = dbmsVersion;
            this.driverName = driverName;
            this.driverVersion = driverVersion;
            this.quotationString = quotationString;
            this.extractionTime = extractionTime;
            this.idFactoryType = idFactoryType;
        }

        public Parameters(DBParameters parameters) {
            this.dbmsProductName = parameters.getDbmsProductName();
            this.dbmsVersion = parameters.getDbmsVersion();
            this.driverName = parameters.getDriverName();
            this.driverVersion = parameters.getDriverVersion();
            QuotedIDFactory idFactory = parameters.getQuotedIDFactory();
            this.quotationString = idFactory.getIDQuotationString();
            String idFactoryType = (String)QUOTED_ID_FACTORIES.inverse().get(idFactory.getClass());
            this.idFactoryType = idFactoryType != null && !idFactoryType.equals("STANDARD") ? idFactoryType : null;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            this.extractionTime = dateFormat.format(Calendar.getInstance().getTime());
        }

        public QuotedIDFactory createQuotedIDFactory() throws MetadataExtractionException {
            try {
                return (QuotedIDFactory)((Class)QUOTED_ID_FACTORIES.getOrDefault((Object)this.idFactoryType, SQLStandardQuotedIDFactory.class)).newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new MetadataExtractionException((Exception)e);
            }
        }
    }
}

