/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMultimap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.AttributeNotFoundException;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.OntopViewDefinition;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.dbschema.impl.AbstractRelationDefinition;
import it.unibz.inf.ontop.dbschema.impl.OntopViewDefinitionImpl;
import it.unibz.inf.ontop.dbschema.impl.RawQuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.json.FunctionalDependencyConstruct;
import it.unibz.inf.ontop.dbschema.impl.json.JsonMetadata;
import it.unibz.inf.ontop.dbschema.impl.json.JsonOpenObject;
import it.unibz.inf.ontop.dbschema.impl.json.JsonView;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.normalization.ConstructionSubstitutionNormalizer;
import it.unibz.inf.ontop.iq.type.UniqueTermTypeExtractor;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.spec.sqlparser.ExpressionParser;
import it.unibz.inf.ontop.spec.sqlparser.RAExpressionAttributes;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonPropertyOrder(value={"relations"})
@JsonDeserialize(as=JsonBasicView.class)
public class JsonBasicView
extends JsonView {
    @Nonnull
    public final Columns columns;
    @Nonnull
    public final List<String> baseRelation;
    @Nonnull
    public final String filterExpression;
    @Nonnull
    public final UniqueConstraints uniqueConstraints;
    @Nonnull
    public final OtherFunctionalDependencies otherFunctionalDependencies;
    @Nonnull
    public final ForeignKeys foreignKeys;
    protected static final Logger LOGGER = LoggerFactory.getLogger(JsonBasicView.class);

    @JsonCreator
    public JsonBasicView(@JsonProperty(value="columns") Columns columns, @JsonProperty(value="name") List<String> name, @JsonProperty(value="baseRelation") List<String> baseRelation, @JsonProperty(value="filterExpression") String filterExpression, @JsonProperty(value="uniqueConstraints") UniqueConstraints uniqueConstraints, @JsonProperty(value="otherFunctionalDependencies") OtherFunctionalDependencies otherFunctionalDependencies, @JsonProperty(value="foreignKeys") ForeignKeys foreignKeys) {
        super(name);
        this.columns = columns;
        this.baseRelation = baseRelation;
        this.filterExpression = filterExpression;
        this.uniqueConstraints = uniqueConstraints;
        this.otherFunctionalDependencies = otherFunctionalDependencies;
        this.foreignKeys = foreignKeys;
    }

    @Override
    public OntopViewDefinition createViewDefinition(DBParameters dbParameters, MetadataLookup parentCacheMetadataLookup) throws MetadataExtractionException {
        QuotedIDFactory quotedIDFactory = dbParameters.getQuotedIDFactory();
        RelationID relationId = quotedIDFactory.createRelationID(this.name.toArray(new String[0]));
        NamedRelationDefinition parentDefinition = parentCacheMetadataLookup.getRelation(quotedIDFactory.createRelationID(this.baseRelation.toArray(new String[0])));
        IQ iq = this.createIQ(relationId, parentDefinition, dbParameters);
        RelationDefinition.AttributeListBuilder attributeBuilder = this.createAttributeBuilder(iq, dbParameters);
        return new OntopViewDefinitionImpl(ImmutableList.of((Object)relationId), attributeBuilder, iq, 1, dbParameters.getCoreSingletons());
    }

    @Override
    public void insertIntegrityConstraints(NamedRelationDefinition relation, ImmutableList<NamedRelationDefinition> baseRelations, MetadataLookup metadataLookupForFK) throws MetadataExtractionException {
        QuotedIDFactory idFactory = metadataLookupForFK.getQuotedIDFactory();
        this.insertUniqueConstraints(relation, idFactory, this.uniqueConstraints.added, baseRelations);
        this.insertFunctionalDependencies(relation, idFactory, this.otherFunctionalDependencies.added, baseRelations);
        for (AddForeignKey fk : this.foreignKeys.added) {
            this.insertForeignKeys(relation, metadataLookupForFK, fk);
        }
    }

    private IQ createIQ(RelationID relationId, NamedRelationDefinition parentDefinition, DBParameters dbParameters) throws MetadataExtractionException {
        ImmutableList<ImmutableExpression> filterConditions;
        CoreSingletons coreSingletons = dbParameters.getCoreSingletons();
        TermFactory termFactory = coreSingletons.getTermFactory();
        IntermediateQueryFactory iqFactory = coreSingletons.getIQFactory();
        AtomFactory atomFactory = coreSingletons.getAtomFactory();
        QuotedIDFactory quotedIdFactory = dbParameters.getQuotedIDFactory();
        ImmutableSet addedVariables = (ImmutableSet)this.columns.added.stream().map(a -> a.name).map(attributeName -> this.normalizeAttributeName((String)attributeName, quotedIdFactory)).map(arg_0 -> ((TermFactory)termFactory).getVariable(arg_0)).collect(ImmutableCollectors.toSet());
        ImmutableList<Variable> projectedVariables = this.extractRelationVariables((ImmutableSet<Variable>)addedVariables, this.columns.hidden, parentDefinition, dbParameters);
        ImmutableMap<Integer, Variable> parentArgumentMap = this.createParentArgumentMap((ImmutableSet<Variable>)addedVariables, parentDefinition, coreSingletons.getCoreUtilsFactory());
        ConstructionSubstitutionNormalizer.ConstructionSubstitutionNormalization normalization = this.createConstructionSubstitution(projectedVariables, parentDefinition, parentArgumentMap, dbParameters);
        ExtensionalDataNode parentDataNode = iqFactory.createExtensionalDataNode((RelationDefinition)parentDefinition, parentArgumentMap);
        ConstructionNode constructionNode = normalization.generateTopConstructionNode().orElseGet(() -> iqFactory.createConstructionNode(ImmutableSet.copyOf((Collection)projectedVariables)));
        try {
            filterConditions = this.filterExpression != null && !this.filterExpression.isEmpty() ? this.extractFilter(parentArgumentMap, parentDefinition, quotedIdFactory, coreSingletons) : ImmutableList.of();
        }
        catch (JSQLParserException e) {
            throw new MetadataExtractionException("Unsupported filter expression for :\n" + (Object)((Object)e));
        }
        IQTree updatedParentDataNode = filterConditions.stream().reduce((x$0, xva$1) -> termFactory.getConjunction(x$0, new ImmutableExpression[]{xva$1})).map(arg_0 -> ((IntermediateQueryFactory)iqFactory).createFilterNode(arg_0)).map(f -> this.updateParentDataNode(normalization, (IQTree)iqFactory.createUnaryIQTree((UnaryOperatorNode)f, (IQTree)parentDataNode))).orElse(this.updateParentDataNode(normalization, (IQTree)parentDataNode));
        UnaryIQTree iqTree = iqFactory.createUnaryIQTree((UnaryOperatorNode)constructionNode, updatedParentDataNode);
        AtomPredicate tmpPredicate = this.createTemporaryPredicate(relationId, projectedVariables.size(), coreSingletons);
        DistinctVariableOnlyDataAtom projectionAtom = atomFactory.getDistinctVariableOnlyDataAtom(tmpPredicate, projectedVariables);
        return iqFactory.createIQ(projectionAtom, (IQTree)iqTree).normalizeForOptimization();
    }

    private ImmutableList<Variable> extractRelationVariables(ImmutableSet<Variable> addedVariables, List<String> hidden, NamedRelationDefinition parentDefinition, DBParameters dbParameters) {
        TermFactory termFactory = dbParameters.getCoreSingletons().getTermFactory();
        QuotedIDFactory quotedIdFactory = dbParameters.getQuotedIDFactory();
        ImmutableList hiddenColumnNames = (ImmutableList)hidden.stream().map(attributeName -> this.normalizeAttributeName((String)attributeName, quotedIdFactory)).collect(ImmutableCollectors.toList());
        ImmutableList inheritedVariableStream = (ImmutableList)parentDefinition.getAttributes().stream().map(a -> a.getID().getName()).filter(n -> !hiddenColumnNames.contains(n)).map(arg_0 -> ((TermFactory)termFactory).getVariable(arg_0)).filter(v -> !addedVariables.contains(v)).collect(ImmutableCollectors.toList());
        return (ImmutableList)Stream.concat(addedVariables.stream(), inheritedVariableStream.stream()).collect(ImmutableCollectors.toList());
    }

    private String normalizeAttributeName(String attributeName, QuotedIDFactory quotedIdFactory) {
        return quotedIdFactory.createAttributeID(attributeName).getName();
    }

    private AtomPredicate createTemporaryPredicate(RelationID relationId, int arity, CoreSingletons coreSingletons) {
        DBTermType dbRootType = coreSingletons.getTypeFactory().getDBTypeFactory().getAbstractRootDBType();
        return new JsonView.TemporaryViewPredicate(relationId.getSQLRendering(), (ImmutableList<TermType>)((ImmutableList)IntStream.range(0, arity).boxed().map(i -> dbRootType).collect(ImmutableCollectors.toList())));
    }

    private ImmutableMap<Integer, Variable> createParentArgumentMap(ImmutableSet<Variable> addedVariables, NamedRelationDefinition parentDefinition, CoreUtilsFactory coreUtilsFactory) {
        VariableGenerator variableGenerator = coreUtilsFactory.createVariableGenerator(addedVariables);
        ImmutableList parentAttributes = parentDefinition.getAttributes();
        return (ImmutableMap)IntStream.range(0, parentAttributes.size()).boxed().collect(ImmutableCollectors.toMap(i -> i, i -> variableGenerator.generateNewVariable(((Attribute)parentAttributes.get(i.intValue())).getID().getName())));
    }

    private IQTree updateParentDataNode(ConstructionSubstitutionNormalizer.ConstructionSubstitutionNormalization normalization, IQTree parentIQTree) {
        return normalization.updateChild(parentIQTree);
    }

    private ConstructionSubstitutionNormalizer.ConstructionSubstitutionNormalization createConstructionSubstitution(ImmutableList<Variable> projectedVariables, NamedRelationDefinition parentDefinition, ImmutableMap<Integer, Variable> parentArgumentMap, DBParameters dbParameters) throws MetadataExtractionException {
        QuotedIDFactory quotedIdFactory = dbParameters.getQuotedIDFactory();
        CoreSingletons coreSingletons = dbParameters.getCoreSingletons();
        TermFactory termFactory = coreSingletons.getTermFactory();
        SubstitutionFactory substitutionFactory = coreSingletons.getSubstitutionFactory();
        ImmutableMap parentAttributeMap = (ImmutableMap)parentArgumentMap.entrySet().stream().collect(ImmutableCollectors.toMap(e -> new QualifiedAttributeID(null, ((Attribute)parentDefinition.getAttributes().get(((Integer)e.getKey()).intValue())).getID()), Map.Entry::getValue));
        ImmutableMap.Builder substitutionMapBuilder = ImmutableMap.builder();
        for (AddColumns a : this.columns.added) {
            Variable v = termFactory.getVariable(this.normalizeAttributeName(a.name, quotedIdFactory));
            try {
                ImmutableTerm value = this.extractExpression(a.expression, (ImmutableMap<QualifiedAttributeID, ImmutableTerm>)parentAttributeMap, quotedIdFactory, coreSingletons);
                substitutionMapBuilder.put((Object)v, (Object)value);
            }
            catch (JSQLParserException e2) {
                throw new MetadataExtractionException("Unsupported expression for " + a.name + " in " + this.name + ":\n" + (Object)((Object)e2));
            }
        }
        ConstructionSubstitutionNormalizer substitutionNormalizer = dbParameters.getCoreSingletons().getConstructionSubstitutionNormalizer();
        return substitutionNormalizer.normalizeSubstitution(substitutionFactory.getSubstitution(substitutionMapBuilder.build()), ImmutableSet.copyOf(projectedVariables));
    }

    private ImmutableTerm extractExpression(String partialExpression, ImmutableMap<QualifiedAttributeID, ImmutableTerm> parentAttributeMap, QuotedIDFactory quotedIdFactory, CoreSingletons coreSingletons) throws JSQLParserException {
        String sqlQuery = "SELECT " + partialExpression + " FROM fakeTable";
        ExpressionParser parser = new ExpressionParser(quotedIdFactory, coreSingletons);
        Statement statement = CCJSqlParserUtil.parse((String)sqlQuery);
        SelectItem si = (SelectItem)((PlainSelect)((Select)statement).getSelectBody()).getSelectItems().get(0);
        Expression exp = ((SelectExpressionItem)si).getExpression();
        return parser.parseTerm(exp, new RAExpressionAttributes(parentAttributeMap, null));
    }

    private ImmutableList<ImmutableExpression> extractFilter(ImmutableMap<Integer, Variable> parentArgumentMap, NamedRelationDefinition parentDefinition, QuotedIDFactory quotedIdFactory, CoreSingletons coreSingletons) throws JSQLParserException {
        ImmutableMap parentAttributeMap = (ImmutableMap)parentArgumentMap.entrySet().stream().collect(ImmutableCollectors.toMap(e -> new QualifiedAttributeID(null, ((Attribute)parentDefinition.getAttributes().get(((Integer)e.getKey()).intValue())).getID()), Map.Entry::getValue));
        String sqlQuery = "SELECT * FROM fakeTable WHERE " + this.filterExpression;
        ExpressionParser parser = new ExpressionParser(quotedIdFactory, coreSingletons);
        Statement statement = CCJSqlParserUtil.parse((String)sqlQuery);
        PlainSelect plainSelect = (PlainSelect)((Select)statement).getSelectBody();
        return plainSelect.getWhere() == null ? ImmutableList.of() : parser.parseBooleanExpression(plainSelect.getWhere(), new RAExpressionAttributes((ImmutableMap<QualifiedAttributeID, ImmutableTerm>)parentAttributeMap, null));
    }

    private RelationDefinition.AttributeListBuilder createAttributeBuilder(IQ iq, DBParameters dbParameters) throws MetadataExtractionException {
        UniqueTermTypeExtractor uniqueTermTypeExtractor = dbParameters.getCoreSingletons().getUniqueTermTypeExtractor();
        QuotedIDFactory quotedIdFactory = dbParameters.getQuotedIDFactory();
        RelationDefinition.AttributeListBuilder builder = AbstractRelationDefinition.attributeListBuilder();
        IQTree iqTree = iq.getTree();
        RawQuotedIDFactory rawQuotedIqFactory = new RawQuotedIDFactory(quotedIdFactory);
        for (Variable v : iqTree.getVariables()) {
            builder.addAttribute(rawQuotedIqFactory.createAttributeID(v.getName()), (DBTermType)uniqueTermTypeExtractor.extractUniqueTermType((ImmutableTerm)v, iqTree).orElseThrow(() -> new MetadataExtractionException("No type inferred for " + v + " in " + iq)), iqTree.getVariableNullability().isPossiblyNullable(v));
        }
        return builder;
    }

    private void insertUniqueConstraints(NamedRelationDefinition relation, QuotedIDFactory idFactory, List<AddUniqueConstraints> addUniqueConstraints, ImmutableList<NamedRelationDefinition> baseRelations) throws MetadataExtractionException {
        List<AddUniqueConstraints> list = this.extractUniqueConstraints(addUniqueConstraints, baseRelations, idFactory);
        for (AddUniqueConstraints addUC : list) {
            if (addUC.isPrimaryKey != null && addUC.isPrimaryKey.booleanValue()) {
                LOGGER.warn("Primary key set in the view file for " + addUC.name);
            }
            FunctionalDependency.Builder builder = UniqueConstraint.builder((NamedRelationDefinition)relation, (String)addUC.name);
            JsonMetadata.deserializeAttributeList(idFactory, addUC.determinants, arg_0 -> ((FunctionalDependency.Builder)builder).addDeterminant(arg_0));
            builder.build();
        }
    }

    private List<AddUniqueConstraints> extractUniqueConstraints(List<AddUniqueConstraints> addUniqueConstraints, ImmutableList<NamedRelationDefinition> baseRelations, QuotedIDFactory idFactory) {
        ImmutableList addedConstraintsColumns = (ImmutableList)this.uniqueConstraints.added.stream().map(a -> a.determinants).flatMap(Collection::stream).map(arg_0 -> ((QuotedIDFactory)idFactory).createAttributeID(arg_0)).collect(ImmutableCollectors.toList());
        ImmutableList addedNewColumns = (ImmutableList)this.columns.added.stream().map(a -> idFactory.createAttributeID(a.name)).collect(ImmutableCollectors.toList());
        ImmutableList hiddenColumnNames = (ImmutableList)this.columns.hidden.stream().map(a -> idFactory.createAttributeID(a)).collect(ImmutableCollectors.toList());
        ImmutableList inheritedConstraints = (ImmutableList)baseRelations.stream().map(RelationDefinition::getUniqueConstraints).flatMap(Collection::stream).filter(c -> c.getAttributes().stream().map(Attribute::getID).noneMatch(arg_0 -> ((ImmutableList)addedConstraintsColumns).contains(arg_0))).filter(c -> c.getAttributes().stream().map(Attribute::getID).noneMatch(arg_0 -> ((ImmutableList)addedNewColumns).contains(arg_0))).filter(c -> c.getAttributes().stream().map(Attribute::getID).noneMatch(arg_0 -> ((ImmutableList)hiddenColumnNames).contains(arg_0))).collect(ImmutableCollectors.toList());
        List inferredUniqueConstraints = inheritedConstraints.stream().map(i -> new AddUniqueConstraints(i.getName(), i.getDeterminants().stream().map(c -> c.getID().getSQLRendering()).collect(Collectors.toList()), false)).collect(Collectors.toList());
        if (!addUniqueConstraints.stream().allMatch(new HashSet()::add)) {
            LOGGER.warn("Duplicate unique constraints found in the viewfile");
        }
        return Stream.concat(addUniqueConstraints.stream(), inferredUniqueConstraints.stream()).distinct().collect(Collectors.toList());
    }

    private void insertFunctionalDependencies(NamedRelationDefinition relation, QuotedIDFactory idFactory, List<AddFunctionalDependency> addFunctionalDependencies, ImmutableList<NamedRelationDefinition> baseRelations) throws MetadataExtractionException {
        ImmutableSet hiddenColumns = (ImmutableSet)this.columns.hidden.stream().map(arg_0 -> ((QuotedIDFactory)idFactory).createAttributeID(arg_0)).collect(ImmutableCollectors.toSet());
        ImmutableSet addedColumns = (ImmutableSet)this.columns.added.stream().map(a -> a.name).map(arg_0 -> ((QuotedIDFactory)idFactory).createAttributeID(arg_0)).collect(ImmutableCollectors.toSet());
        Stream<FunctionalDependencyConstruct> inheritedFDConstructs = baseRelations.stream().map(RelationDefinition::getOtherFunctionalDependencies).flatMap(Collection::stream).filter(f -> this.canFDBeInherited((FunctionalDependency)f, (ImmutableSet<QuotedID>)hiddenColumns, (ImmutableSet<QuotedID>)addedColumns)).map(f -> new FunctionalDependencyConstruct((ImmutableSet<QuotedID>)((ImmutableSet)f.getDeterminants().stream().map(Attribute::getID).collect(ImmutableCollectors.toSet())), (ImmutableSet<QuotedID>)((ImmutableSet)f.getDependents().stream().map(Attribute::getID).flatMap(d -> this.extractNewDependents((QuotedID)d, (ImmutableSet<QuotedID>)addedColumns, (ImmutableSet<QuotedID>)hiddenColumns)).collect(ImmutableCollectors.toSet()))));
        Stream<FunctionalDependencyConstruct> declaredFdDependencies = addFunctionalDependencies.stream().map(jsonFD -> new FunctionalDependencyConstruct((ImmutableSet<QuotedID>)((ImmutableSet)jsonFD.determinants.stream().map(arg_0 -> ((QuotedIDFactory)idFactory).createAttributeID(arg_0)).collect(ImmutableCollectors.toSet())), (ImmutableSet<QuotedID>)((ImmutableSet)jsonFD.dependents.stream().map(arg_0 -> ((QuotedIDFactory)idFactory).createAttributeID(arg_0)).collect(ImmutableCollectors.toSet()))));
        ImmutableMultimap fdMultimap = (ImmutableMultimap)Stream.concat(declaredFdDependencies, inheritedFDConstructs).collect(ImmutableCollectors.toMultimap(FunctionalDependencyConstruct::getDeterminants, fd -> fd));
        ImmutableSet fdConstructs = (ImmutableSet)fdMultimap.asMap().values().stream().map(fds -> (FunctionalDependencyConstruct)fds.stream().reduce((f1, f2) -> f1.merge((FunctionalDependencyConstruct)f2).orElseThrow(() -> new MinorOntopInternalBugException("Should be mergeable as they are having the same determinants"))).get()).collect(ImmutableCollectors.toSet());
        for (FunctionalDependencyConstruct fdConstruct : fdConstructs) {
            this.addFunctionalDependency(relation, idFactory, fdConstruct);
        }
    }

    private Stream<QuotedID> extractNewDependents(QuotedID parentDependentId, ImmutableSet<QuotedID> addedColumns, ImmutableSet<QuotedID> hiddenColumns) {
        return addedColumns.contains((Object)parentDependentId) || hiddenColumns.contains((Object)parentDependentId) ? Stream.empty() : Stream.of(parentDependentId);
    }

    private boolean canFDBeInherited(FunctionalDependency fd, ImmutableSet<QuotedID> hiddenColumns, ImmutableSet<QuotedID> addedColumns) {
        return fd.getDeterminants().stream().map(Attribute::getID).noneMatch(d -> hiddenColumns.contains(d) || addedColumns.contains(d));
    }

    private void addFunctionalDependency(NamedRelationDefinition viewDefinition, QuotedIDFactory idFactory, FunctionalDependencyConstruct fdConstruct) throws MetadataExtractionException {
        FunctionalDependency.Builder builder = FunctionalDependency.defaultBuilder((NamedRelationDefinition)viewDefinition);
        try {
            for (QuotedID determinant : fdConstruct.getDeterminants()) {
                builder.addDeterminant(determinant);
            }
            for (QuotedID dependent : fdConstruct.getDependents()) {
                builder.addDependent(dependent);
            }
        }
        catch (AttributeNotFoundException e) {
            throw new MetadataExtractionException(String.format("Cannot find attribute %s for Functional Dependency %s", e.getAttributeID(), fdConstruct));
        }
        builder.build();
    }

    public void insertForeignKeys(NamedRelationDefinition relation, MetadataLookup lookup, AddForeignKey addForeignKey) throws MetadataExtractionException {
        NamedRelationDefinition targetRelation;
        RelationID targetRelationId = JsonMetadata.deserializeRelationID(lookup.getQuotedIDFactory(), addForeignKey.to.relation);
        try {
            targetRelation = lookup.getRelation(targetRelationId);
        }
        catch (MetadataExtractionException e) {
            LOGGER.info("Cannot find relation {} for FK {}", (Object)targetRelationId, (Object)addForeignKey.name);
            return;
        }
        ForeignKeyConstraint.Builder builder = ForeignKeyConstraint.builder((String)addForeignKey.name, (NamedRelationDefinition)relation, (NamedRelationDefinition)targetRelation);
        try {
            for (String column : addForeignKey.to.columns) {
                builder.add(lookup.getQuotedIDFactory().createAttributeID(addForeignKey.from), lookup.getQuotedIDFactory().createAttributeID(column));
            }
        }
        catch (AttributeNotFoundException e) {
            throw new MetadataExtractionException((Exception)((Object)e));
        }
        builder.build();
    }

    @JsonPropertyOrder(value={"relation", "columns"})
    public static class ForeignKeyPart
    extends JsonOpenObject {
        public final List<String> relation;
        public final List<String> columns;

        @JsonCreator
        public ForeignKeyPart(@JsonProperty(value="relation") List<String> relation, @JsonProperty(value="columns") List<String> columns) {
            this.relation = relation;
            this.columns = columns;
        }
    }

    @JsonPropertyOrder(value={"determinants", "dependents"})
    private static class AddForeignKey
    extends JsonOpenObject {
        @Nonnull
        public final String name;
        @Nonnull
        public final String from;
        @Nonnull
        public final ForeignKeyPart to;

        public AddForeignKey(@JsonProperty(value="name") String name, @JsonProperty(value="from") String from, @JsonProperty(value="to") ForeignKeyPart to) {
            this.name = name;
            this.from = from;
            this.to = to;
        }
    }

    private static class ForeignKeys
    extends JsonOpenObject {
        @Nonnull
        public final List<AddForeignKey> added;

        @JsonCreator
        public ForeignKeys(@JsonProperty(value="added") List<AddForeignKey> added) {
            this.added = added;
        }
    }

    @JsonPropertyOrder(value={"determinants", "dependents"})
    private static class AddFunctionalDependency
    extends JsonOpenObject {
        @Nonnull
        public final List<String> determinants;
        @Nonnull
        public final List<String> dependents;

        public AddFunctionalDependency(@JsonProperty(value="determinants") List<String> determinants, @JsonProperty(value="dependents") List<String> dependents) {
            this.determinants = determinants;
            this.dependents = dependents;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddFunctionalDependency other = (AddFunctionalDependency)obj;
            return Objects.equals(ImmutableMap.of(this.determinants, this.dependents), ImmutableMap.of(other.determinants, other.dependents));
        }

        public int hashCode() {
            return Objects.hash(ImmutableMap.of(this.determinants, this.dependents));
        }
    }

    private static class OtherFunctionalDependencies
    extends JsonOpenObject {
        @Nonnull
        public final List<AddFunctionalDependency> added;

        @JsonCreator
        public OtherFunctionalDependencies(@JsonProperty(value="added") List<AddFunctionalDependency> added) {
            this.added = added;
        }
    }

    @JsonPropertyOrder(value={"name", "determinants", "isPrimaryKey"})
    private static class AddUniqueConstraints
    extends JsonOpenObject {
        @Nonnull
        public final String name;
        @Nonnull
        public final List<String> determinants;
        public final Boolean isPrimaryKey;

        @JsonCreator
        public AddUniqueConstraints(@JsonProperty(value="name") String name, @JsonProperty(value="determinants") List<String> determinants, @JsonProperty(value="isPrimaryKey") Boolean isPrimaryKey) {
            this.name = name;
            this.determinants = determinants;
            this.isPrimaryKey = isPrimaryKey;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddUniqueConstraints other = (AddUniqueConstraints)obj;
            return Objects.equals(this.determinants, other.determinants);
        }

        public int hashCode() {
            return Objects.hash(this.determinants);
        }
    }

    @JsonPropertyOrder(value={"added"})
    private static class UniqueConstraints
    extends JsonOpenObject {
        @Nonnull
        public final List<AddUniqueConstraints> added;

        @JsonCreator
        public UniqueConstraints(@JsonProperty(value="added") List<AddUniqueConstraints> added) {
            this.added = added;
        }
    }

    @JsonPropertyOrder(value={"name", "expression"})
    private static class AddColumns
    extends JsonOpenObject {
        @Nonnull
        public final String name;
        @Nonnull
        public final String expression;

        @JsonCreator
        public AddColumns(@JsonProperty(value="name") String name, @JsonProperty(value="expression") String expression) {
            this.name = name;
            this.expression = expression;
        }
    }

    @JsonPropertyOrder(value={"added", "hidden"})
    private static class Columns
    extends JsonOpenObject {
        @Nonnull
        public final List<AddColumns> added;
        @Nonnull
        public final List<String> hidden;

        @JsonCreator
        public Columns(@JsonProperty(value="added") List<AddColumns> added, @JsonProperty(value="hidden") List<String> hidden) {
            this.added = added;
            this.hidden = hidden;
        }
    }
}

