/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.DefaultSchemaCatalogDBMetadataProvider;
import it.unibz.inf.ontop.dbschema.impl.SQLServerQuotedIDFactory;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import java.sql.Connection;

public class SQLServerDBMetadataProvider
extends DefaultSchemaCatalogDBMetadataProvider {
    private static final ImmutableSet<String> IGNORED_SCHEMAS = ImmutableSet.of((Object)"sys", (Object)"INFORMATION_SCHEMA");

    @AssistedInject
    SQLServerDBMetadataProvider(@Assisted Connection connection, CoreSingletons coreSingletons) throws MetadataExtractionException {
        super(connection, metadata -> new SQLServerQuotedIDFactory(), coreSingletons);
    }

    @Override
    protected boolean isRelationExcluded(RelationID id) {
        return IGNORED_SCHEMAS.contains((Object)this.getRelationSchema(id));
    }
}

