/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.MetadataProvider;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.OntopViewMetadataProvider;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.CachingMetadataLookupWithDependencies;
import it.unibz.inf.ontop.dbschema.impl.DelegatingMetadataProvider;
import it.unibz.inf.ontop.dbschema.impl.json.JsonMetadata;
import it.unibz.inf.ontop.dbschema.impl.json.JsonView;
import it.unibz.inf.ontop.dbschema.impl.json.JsonViews;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;

public class OntopViewMetadataProviderImpl
implements OntopViewMetadataProvider {
    private final MetadataProvider parentMetadataProvider;
    private final CachingMetadataLookupWithDependencies parentCacheMetadataLookup;
    private final ImmutableMap<RelationID, JsonView> jsonMap;

    @AssistedInject
    protected OntopViewMetadataProviderImpl(@Assisted MetadataProvider parentMetadataProvider, @Assisted Reader ontopViewReader) throws MetadataExtractionException {
        this.parentMetadataProvider = new DelegatingMetadataProvider(parentMetadataProvider){
            private final Set<RelationID> completeRelations;
            {
                this.completeRelations = new HashSet<RelationID>();
            }

            public void insertIntegrityConstraints(NamedRelationDefinition relation, MetadataLookup metadataLookup) throws MetadataExtractionException {
                boolean notComplete = this.completeRelations.add(relation.getID());
                if (notComplete) {
                    this.provider.insertIntegrityConstraints(relation, metadataLookup);
                }
            }
        };
        this.parentCacheMetadataLookup = new CachingMetadataLookupWithDependencies(parentMetadataProvider);
        try (Reader viewReader = ontopViewReader;){
            JsonViews jsonViews = OntopViewMetadataProviderImpl.loadAndDeserialize(viewReader);
            QuotedIDFactory quotedIdFactory = parentMetadataProvider.getQuotedIDFactory();
            this.jsonMap = (ImmutableMap)jsonViews.relations.stream().collect(ImmutableCollectors.toMap(t -> JsonMetadata.deserializeRelationID(quotedIdFactory, t.name), t -> t));
        }
        catch (JsonProcessingException e) {
            throw new MetadataExtractionException("problem with JSON processing.\n" + (Object)((Object)e));
        }
        catch (IOException e) {
            throw new MetadataExtractionException((Exception)e);
        }
    }

    protected static JsonViews loadAndDeserialize(Reader viewReader) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new GuavaModule()).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).enable(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT);
        return (JsonViews)objectMapper.readValue(viewReader, JsonViews.class);
    }

    public ImmutableList<RelationID> getRelationIDs() throws MetadataExtractionException {
        return (ImmutableList)Stream.concat(this.jsonMap.keySet().stream(), this.parentMetadataProvider.getRelationIDs().stream()).collect(ImmutableCollectors.toList());
    }

    public NamedRelationDefinition getRelation(RelationID id) throws MetadataExtractionException {
        JsonView jsonView = (JsonView)this.jsonMap.get((Object)id);
        if (jsonView != null) {
            return jsonView.createViewDefinition(this.getDBParameters(), this.parentCacheMetadataLookup.getCachingMetadataLookupFor(id));
        }
        return this.parentCacheMetadataLookup.getRelation(id);
    }

    public void insertIntegrityConstraints(NamedRelationDefinition relation, MetadataLookup metadataLookupForFK) throws MetadataExtractionException {
        JsonView jsonView = (JsonView)this.jsonMap.get((Object)relation.getID());
        if (jsonView != null) {
            ImmutableList<NamedRelationDefinition> baseRelations = this.parentCacheMetadataLookup.getBaseRelations(relation.getID());
            for (NamedRelationDefinition baseRelation : baseRelations) {
                this.parentMetadataProvider.insertIntegrityConstraints(baseRelation, metadataLookupForFK);
            }
            jsonView.insertIntegrityConstraints(relation, baseRelations, metadataLookupForFK);
        } else {
            this.parentMetadataProvider.insertIntegrityConstraints(relation, metadataLookupForFK);
        }
    }

    public QuotedIDFactory getQuotedIDFactory() {
        return this.parentMetadataProvider.getQuotedIDFactory();
    }

    public DBParameters getDBParameters() {
        return this.parentMetadataProvider.getDBParameters();
    }
}

