/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.SerializedMetadataProvider;
import it.unibz.inf.ontop.dbschema.impl.BasicDBParametersImpl;
import it.unibz.inf.ontop.dbschema.impl.json.JsonDatabaseTable;
import it.unibz.inf.ontop.dbschema.impl.json.JsonMetadata;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;

public class JsonSerializedMetadataProvider
implements SerializedMetadataProvider {
    private final DBParameters dbParameters;
    private final ImmutableMap<RelationID, JsonDatabaseTable> relationMap;

    @AssistedInject
    protected JsonSerializedMetadataProvider(@Assisted Reader dbMetadataReader, CoreSingletons coreSingletons) throws MetadataExtractionException, IOException {
        JsonMetadata jsonMetadata = JsonSerializedMetadataProvider.loadAndDeserialize(dbMetadataReader);
        QuotedIDFactory idFactory = jsonMetadata.metadata.createQuotedIDFactory();
        this.dbParameters = new BasicDBParametersImpl(jsonMetadata.metadata.driverName, jsonMetadata.metadata.driverVersion, jsonMetadata.metadata.dbmsProductName, jsonMetadata.metadata.dbmsVersion, idFactory, coreSingletons);
        this.relationMap = (ImmutableMap)jsonMetadata.relations.stream().collect(ImmutableCollectors.toMap(t -> JsonMetadata.deserializeRelationID(idFactory, t.name), t -> t));
    }

    protected static JsonMetadata loadAndDeserialize(Reader dbMetadataReader) throws MetadataExtractionException, IOException {
        try {
            ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new GuavaModule()).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).enable(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT);
            return (JsonMetadata)objectMapper.readValue(dbMetadataReader, JsonMetadata.class);
        }
        catch (JsonProcessingException e) {
            throw new MetadataExtractionException("problem with JSON processing.\n" + (Object)((Object)e));
        }
    }

    public NamedRelationDefinition getRelation(RelationID id) throws MetadataExtractionException {
        JsonDatabaseTable jsonTable = (JsonDatabaseTable)this.relationMap.get((Object)id);
        if (jsonTable == null) {
            throw new IllegalArgumentException("The relation " + id.getSQLRendering() + " is unknown to the JsonSerializedMetadataProvider");
        }
        return jsonTable.createDatabaseTableDefinition(this.dbParameters);
    }

    public QuotedIDFactory getQuotedIDFactory() {
        return this.dbParameters.getQuotedIDFactory();
    }

    public ImmutableList<RelationID> getRelationIDs() throws MetadataExtractionException {
        return ImmutableList.copyOf((Collection)this.relationMap.keySet());
    }

    public void insertIntegrityConstraints(NamedRelationDefinition relation, MetadataLookup metadataLookupForFk) throws MetadataExtractionException {
        JsonDatabaseTable jsonTable = (JsonDatabaseTable)this.relationMap.get((Object)relation.getID());
        if (jsonTable == null) {
            throw new IllegalArgumentException("The relation " + relation.getID().getSQLRendering() + " is unknown to the JsonSerializedMetadataProvider");
        }
        jsonTable.insertIntegrityConstraints(relation, metadataLookupForFk);
    }

    public DBParameters getDBParameters() {
        return this.dbParameters;
    }
}

