/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.DefaultSchemaDBMetadataProvider;
import it.unibz.inf.ontop.dbschema.impl.SQLStandardQuotedIDFactory;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import java.sql.Connection;

public class DB2DBMetadataProvider
extends DefaultSchemaDBMetadataProvider {
    private static final ImmutableSet<String> IGNORED_SCHEMAS = ImmutableSet.of((Object)"SYSTOOLS", (Object)"SYSCAT", (Object)"SYSIBM", (Object)"SYSIBMADM", (Object)"SYSSTAT");

    @AssistedInject
    DB2DBMetadataProvider(@Assisted Connection connection, CoreSingletons coreSingletons) throws MetadataExtractionException {
        super(connection, metadata -> new SQLStandardQuotedIDFactory(), coreSingletons);
    }

    @Override
    protected boolean isRelationExcluded(RelationID id) {
        return IGNORED_SCHEMAS.contains((Object)this.getRelationSchema(id));
    }
}

