/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.MetadataProvider;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.CachingMetadataLookup;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CachingMetadataLookupWithDependencies
extends CachingMetadataLookup {
    private final Map<RelationID, Set<RelationID>> baseRelationIds = new HashMap<RelationID, Set<RelationID>>();

    public CachingMetadataLookupWithDependencies(MetadataProvider provider) {
        super(provider);
    }

    public ImmutableList<NamedRelationDefinition> getBaseRelations(RelationID id) throws MetadataExtractionException {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (RelationID baseId : this.baseRelationIds.get(id)) {
            builder.add((Object)this.getRelation(baseId));
        }
        return builder.build();
    }

    public MetadataLookup getCachingMetadataLookupFor(final RelationID id) {
        return new MetadataLookup(){
            private final Set<RelationID> bases;
            {
                this.bases = CachingMetadataLookupWithDependencies.this.baseRelationIds.computeIfAbsent(id, i -> new HashSet());
            }

            public NamedRelationDefinition getRelation(RelationID baseId) throws MetadataExtractionException {
                NamedRelationDefinition base = CachingMetadataLookupWithDependencies.this.getRelation(baseId);
                this.bases.add(base.getID());
                return base;
            }

            public QuotedIDFactory getQuotedIDFactory() {
                return CachingMetadataLookupWithDependencies.this.getQuotedIDFactory();
            }
        };
    }
}

