/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.AttributeNotFoundException;
import it.unibz.inf.ontop.dbschema.DBMetadataProvider;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.dbschema.impl.BasicDBParametersImpl;
import it.unibz.inf.ontop.dbschema.impl.DatabaseTableDefinition;
import it.unibz.inf.ontop.dbschema.impl.RawQuotedIDFactory;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.exception.RelationNotFoundInMetadataException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDBMetadataProvider
implements DBMetadataProvider {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractDBMetadataProvider.class);
    protected final Connection connection;
    protected final DBParameters dbParameters;
    protected final DatabaseMetaData metadata;
    protected final QuotedIDFactory rawIdFactory;

    AbstractDBMetadataProvider(Connection connection, QuotedIDFactoryFactory idFactoryProvider, CoreSingletons coreSingletons) throws MetadataExtractionException {
        try {
            this.connection = connection;
            this.metadata = connection.getMetaData();
            QuotedIDFactory idFactory = idFactoryProvider.create(this.metadata);
            this.rawIdFactory = new RawQuotedIDFactory(idFactory);
            this.dbParameters = new BasicDBParametersImpl(this.metadata.getDriverName(), this.metadata.getDriverVersion(), this.metadata.getDatabaseProductName(), this.metadata.getDatabaseProductVersion(), idFactory, coreSingletons);
        }
        catch (SQLException e) {
            throw new MetadataExtractionException((Exception)e);
        }
    }

    public QuotedIDFactory getQuotedIDFactory() {
        return this.dbParameters.getQuotedIDFactory();
    }

    public DBParameters getDBParameters() {
        return this.dbParameters;
    }

    protected boolean isRelationExcluded(RelationID id) {
        return false;
    }

    protected ResultSet getRelationIDsResultSet() throws SQLException {
        return this.metadata.getTables(null, null, null, new String[]{"TABLE", "VIEW"});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ImmutableList<RelationID> getRelationIDs() throws MetadataExtractionException {
        try (ResultSet rs = this.getRelationIDsResultSet();){
            ImmutableList.Builder builder = ImmutableList.builder();
            while (rs.next()) {
                RelationID id = this.getRelationID(rs, "TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME");
                if (this.isRelationExcluded(id)) continue;
                builder.add((Object)id);
            }
            ImmutableList immutableList = builder.build();
            return immutableList;
        }
        catch (SQLException e) {
            throw new MetadataExtractionException((Exception)e);
        }
    }

    protected abstract RelationID getRelationID(ResultSet var1, String var2, String var3, String var4) throws SQLException;

    protected void checkSameRelationID(RelationID extractedId, RelationID givenId) throws MetadataExtractionException {
        if (!extractedId.equals(givenId)) {
            throw new MetadataExtractionException("Relation IDs mismatch: " + givenId + " v " + extractedId);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NamedRelationDefinition getRelation(RelationID id0) throws MetadataExtractionException {
        DBTypeFactory dbTypeFactory = this.dbParameters.getDBTypeFactory();
        RelationID id = this.getCanonicalRelationId(id0);
        try (ResultSet rs = this.metadata.getColumns(this.getRelationCatalog(id), this.getRelationSchema(id), this.getRelationName(id), null);){
            Throwable throwable;
            HashMap<RelationID, RelationDefinition.AttributeListBuilder> relations = new HashMap<RelationID, RelationDefinition.AttributeListBuilder>();
            while (rs.next()) {
                String sqlTypeName;
                RelationID extractedId = this.getRelationID(rs, "TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME");
                this.checkSameRelationID(extractedId, id);
                RelationDefinition.AttributeListBuilder builder = relations.computeIfAbsent(extractedId, i -> DatabaseTableDefinition.attributeListBuilder());
                QuotedID attributeId = this.rawIdFactory.createAttributeID(rs.getString("COLUMN_NAME"));
                boolean isNullable = rs.getInt("NULLABLE") != 0;
                String typeName = rs.getString("TYPE_NAME");
                int columnSize = rs.getInt("COLUMN_SIZE");
                DBTermType termType = dbTypeFactory.getDBTermType(typeName, columnSize);
                switch (rs.getInt("DATA_TYPE")) {
                    case -9: 
                    case 1: 
                    case 12: {
                        sqlTypeName = columnSize != 0 ? typeName + "(" + columnSize + ")" : typeName;
                        break;
                    }
                    case 2: 
                    case 3: {
                        int decimalDigits = rs.getInt("DECIMAL_DIGITS");
                        if (columnSize == 0) {
                            sqlTypeName = typeName;
                            break;
                        }
                        if (decimalDigits == 0) {
                            sqlTypeName = typeName + "(" + columnSize + ")";
                            break;
                        }
                        sqlTypeName = typeName + "(" + columnSize + ", " + decimalDigits + ")";
                        break;
                    }
                    default: {
                        sqlTypeName = typeName;
                    }
                }
                builder.addAttribute(attributeId, termType, sqlTypeName, isNullable);
            }
            if (relations.entrySet().size() == 1) {
                Map.Entry r = relations.entrySet().iterator().next();
                DatabaseTableDefinition databaseTableDefinition = new DatabaseTableDefinition(this.getAllIDs((RelationID)r.getKey()), (RelationDefinition.AttributeListBuilder)r.getValue());
                return databaseTableDefinition;
            }
            if (relations.isEmpty()) {
                throwable = new RelationNotFoundInMetadataException(id, this.getRelationIDs());
                throw throwable;
            }
            throwable = new MetadataExtractionException("Cannot resolve ambiguous relation id: " + id + ": " + relations.keySet());
            throw throwable;
        }
        catch (SQLException e) {
            throw new MetadataExtractionException((Exception)e);
        }
    }

    public void insertIntegrityConstraints(NamedRelationDefinition relation, MetadataLookup metadataLookup) throws MetadataExtractionException {
        try {
            this.insertPrimaryKey(relation);
            this.insertUniqueAttributes(relation);
            this.insertForeignKeys(relation, metadataLookup);
        }
        catch (SQLException e) {
            throw new MetadataExtractionException((Exception)e);
        }
    }

    private void insertPrimaryKey(NamedRelationDefinition relation) throws MetadataExtractionException, SQLException {
        block16: {
            RelationID id = this.getCanonicalRelationId(relation.getID());
            try (ResultSet rs = this.metadata.getPrimaryKeys(this.getRelationCatalog(id), this.getRelationSchema(id), this.getRelationName(id));){
                HashMap<Integer, QuotedID> primaryKeyAttributes = new HashMap<Integer, QuotedID>();
                String currentName = null;
                while (rs.next()) {
                    RelationID extractedId = this.getRelationID(rs, "TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME");
                    this.checkSameRelationID(extractedId, id);
                    currentName = rs.getString("PK_NAME");
                    QuotedID attrId = this.rawIdFactory.createAttributeID(rs.getString("COLUMN_NAME"));
                    short seq = rs.getShort("KEY_SEQ");
                    primaryKeyAttributes.put(Integer.valueOf(seq), attrId);
                }
                if (primaryKeyAttributes.isEmpty()) break block16;
                try {
                    FunctionalDependency.Builder builder = UniqueConstraint.primaryKeyBuilder((NamedRelationDefinition)relation, currentName);
                    for (int i = 1; i <= primaryKeyAttributes.size(); ++i) {
                        builder.addDeterminant((QuotedID)primaryKeyAttributes.get(i));
                    }
                    builder.build();
                }
                catch (AttributeNotFoundException e) {
                    throw new MetadataExtractionException((Exception)((Object)e));
                }
            }
        }
    }

    private void insertUniqueAttributes(NamedRelationDefinition relation) throws MetadataExtractionException, SQLException {
        RelationID id = this.getCanonicalRelationId(relation.getID());
        try (ResultSet rs = this.metadata.getIndexInfo(this.getRelationCatalog(id), this.getRelationSchema(id), this.getRelationName(id), true, true);){
            FunctionalDependency.Builder builder = null;
            while (rs.next()) {
                RelationID extractedId = this.getRelationID(rs, "TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME");
                this.checkSameRelationID(extractedId, id);
                if (rs.getShort("TYPE") == 0) {
                    if (builder != null) {
                        builder.build();
                    }
                    builder = null;
                    continue;
                }
                if (rs.getShort("ORDINAL_POSITION") == 1) {
                    if (builder != null) {
                        builder.build();
                    }
                    if (!rs.getBoolean("NON_UNIQUE")) {
                        String name = rs.getString("INDEX_NAME");
                        builder = UniqueConstraint.builder((NamedRelationDefinition)relation, (String)name);
                    } else {
                        builder = null;
                    }
                }
                if (builder == null) continue;
                QuotedID attrId = this.rawIdFactory.createAttributeID(rs.getString("COLUMN_NAME"));
                try {
                    builder.addDeterminant(attrId);
                }
                catch (AttributeNotFoundException e) {
                    try {
                        attrId = this.rawIdFactory.createAttributeID("\"" + rs.getString("COLUMN_NAME") + "\"");
                        builder.addDeterminant(attrId);
                    }
                    catch (AttributeNotFoundException ex) {
                        throw new MetadataExtractionException((Exception)((Object)e));
                    }
                }
            }
            if (builder != null) {
                builder.build();
            }
        }
    }

    private void insertForeignKeys(NamedRelationDefinition relation, MetadataLookup dbMetadata) throws MetadataExtractionException, SQLException {
        RelationID id = this.getCanonicalRelationId(relation.getID());
        try (ResultSet rs = this.metadata.getImportedKeys(this.getRelationCatalog(id), this.getRelationSchema(id), this.getRelationName(id));){
            ForeignKeyConstraint.Builder builder = null;
            while (rs.next()) {
                RelationID extractedId = this.getRelationID(rs, "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME");
                this.checkSameRelationID(extractedId, id);
                RelationID pkId = this.getRelationID(rs, "PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME");
                try {
                    short seq = rs.getShort("KEY_SEQ");
                    if (seq == 1) {
                        if (builder != null) {
                            builder.build();
                        }
                        String name = rs.getString("FK_NAME");
                        NamedRelationDefinition ref = dbMetadata.getRelation(pkId);
                        builder = ForeignKeyConstraint.builder((String)name, (NamedRelationDefinition)relation, (NamedRelationDefinition)ref);
                    }
                    if (builder == null) continue;
                    try {
                        QuotedID attrId = this.rawIdFactory.createAttributeID(rs.getString("FKCOLUMN_NAME"));
                        QuotedID refAttrId = this.rawIdFactory.createAttributeID(rs.getString("PKCOLUMN_NAME"));
                        builder.add(attrId, refAttrId);
                    }
                    catch (AttributeNotFoundException e) {
                        throw new MetadataExtractionException((Exception)((Object)e));
                    }
                }
                catch (MetadataExtractionException e) {
                    LOGGER.warn("Cannot find table {} for FK {}", (Object)pkId, (Object)rs.getString("FK_NAME"));
                    builder = null;
                }
            }
            if (builder != null) {
                builder.build();
            }
        }
    }

    protected abstract RelationID getCanonicalRelationId(RelationID var1);

    protected abstract ImmutableList<RelationID> getAllIDs(RelationID var1);

    protected abstract String getRelationCatalog(RelationID var1);

    protected abstract String getRelationSchema(RelationID var1);

    protected abstract String getRelationName(RelationID var1);

    protected static interface DefaultRelationIdComponentsFactory {
        public String[] getDefaultRelationIdComponents(Connection var1) throws SQLException;
    }

    protected static interface QuotedIDFactoryFactory {
        public QuotedIDFactory create(DatabaseMetaData var1) throws SQLException;
    }
}

