/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.impl;

import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.type.impl.DatetimeDBTermType;
import it.unibz.inf.ontop.model.type.impl.DefaultSQLDBTypeFactory;
import java.util.Map;

public class DenodoDBTypeFactory
extends DefaultSQLDBTypeFactory {
    public static final String TIMESTAMPTZ_STR = "TIMESTAMP_WITH_TIMEZONE";

    @AssistedInject
    protected DenodoDBTypeFactory(@Assisted TermType rootTermType, @Assisted TypeFactory typeFactory) {
        super(DenodoDBTypeFactory.createDenodoTypeMap(rootTermType, typeFactory), DenodoDBTypeFactory.createDenodoCodeMap());
    }

    protected static Map<String, DBTermType> createDenodoTypeMap(TermType rootTermType, TypeFactory typeFactory) {
        DatetimeDBTermType timestampTz = new DatetimeDBTermType(TIMESTAMPTZ_STR, rootTermType.getAncestry(), typeFactory.getXsdDatetimeDatatype());
        Map<String, DBTermType> map = DenodoDBTypeFactory.createDefaultSQLTypeMap(rootTermType, typeFactory);
        map.put(TIMESTAMPTZ_STR, (DBTermType)timestampTz);
        return map;
    }

    protected static ImmutableMap<DefaultSQLDBTypeFactory.DefaultTypeCode, String> createDenodoCodeMap() {
        Map<DefaultSQLDBTypeFactory.DefaultTypeCode, String> map = DenodoDBTypeFactory.createDefaultSQLCodeMap();
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DOUBLE, "DOUBLE PRECISION");
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DATETIMESTAMP, TIMESTAMPTZ_STR);
        return ImmutableMap.copyOf(map);
    }
}

