/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.impl;

import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.model.type.ConcreteNumericRDFDatatype;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeAncestry;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.type.impl.DefaultSQLDBTypeFactory;
import java.util.Map;

public class DB2DBTypeFactory
extends DefaultSQLDBTypeFactory {
    @AssistedInject
    protected DB2DBTypeFactory(@Assisted TermType rootTermType, @Assisted TypeFactory typeFactory) {
        super(DB2DBTypeFactory.createDB2TypeMap(rootTermType, typeFactory), DB2DBTypeFactory.createDB2CodeMap());
    }

    protected static Map<String, DBTermType> createDB2TypeMap(TermType rootTermType, TypeFactory typeFactory) {
        TermTypeAncestry rootAncestry = rootTermType.getAncestry();
        ConcreteNumericRDFDatatype xsdInteger = typeFactory.getXsdIntegerDatatype();
        ConcreteNumericRDFDatatype xsdDouble = typeFactory.getXsdDoubleDatatype();
        RDFDatatype xsdString = typeFactory.getXsdStringDatatype();
        RDFDatatype xsdBoolean = typeFactory.getXsdBooleanDatatype();
        Map<String, DBTermType> map = DB2DBTypeFactory.createDefaultSQLTypeMap(rootTermType, typeFactory);
        return map;
    }

    protected static ImmutableMap<DefaultSQLDBTypeFactory.DefaultTypeCode, String> createDB2CodeMap() {
        Map<DefaultSQLDBTypeFactory.DefaultTypeCode, String> map = DB2DBTypeFactory.createDefaultSQLCodeMap();
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.STRING, "VARCHAR");
        return ImmutableMap.copyOf(map);
    }
}

