/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import it.unibz.inf.ontop.dbschema.DBMetadataProvider;
import it.unibz.inf.ontop.exception.InvalidOntopConfigurationException;
import it.unibz.inf.ontop.generation.normalization.DialectExtraNormalizer;
import it.unibz.inf.ontop.generation.serializer.SelectFromWhereSerializer;
import it.unibz.inf.ontop.injection.OntopSQLCoreSettings;
import it.unibz.inf.ontop.injection.impl.OntopOBDASettingsImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.utils.IDGenerator;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public class OntopSQLCoreSettingsImpl
extends OntopOBDASettingsImpl
implements OntopSQLCoreSettings {
    private static final String DB_PREFIX = "DB-";
    private static final String DB_TYPE_FACTORY_SUFFIX = "-typeFactory";
    private static final String DB_FS_FACTORY_SUFFIX = "-symbolFactory";
    private static final String DIALECT_SERIALIZER_SUFFIX = "-serializer";
    private static final String DIALECT_NORMALIZER_SUFFIX = "-normalizer";
    private static final String DB_MP_FACTORY_SUFFIX = "-metadataProvider";
    private static final String DEFAULT_FILE = "sql-default.properties";
    private final String jdbcUrl = this.getRequiredProperty("jdbc.url");
    private final String jdbcDriver = this.getRequiredProperty("jdbc.driver");
    private final String jdbcName = this.getProperty("jdbc.name").orElseGet(() -> IDGenerator.getNextUniqueID((String)DB_PREFIX));

    protected OntopSQLCoreSettingsImpl(Properties userProperties) {
        super(OntopSQLCoreSettingsImpl.loadSQLCoreProperties(userProperties));
    }

    static Properties loadSQLCoreProperties(Properties userProperties) {
        String jdbcDriver = OntopSQLCoreSettingsImpl.extractJdbcDriver(userProperties);
        Properties properties = OntopSQLCoreSettingsImpl.loadDefaultPropertiesFromFile(OntopSQLCoreSettings.class, (String)DEFAULT_FILE);
        properties.setProperty("jdbc.driver", jdbcDriver);
        properties.putAll((Map<?, ?>)userProperties);
        String typeFactoryKey = jdbcDriver + DB_TYPE_FACTORY_SUFFIX;
        String dbTypeFactoryName = DBTypeFactory.class.getCanonicalName();
        Optional.ofNullable(properties.getProperty(typeFactoryKey)).filter(v -> !userProperties.containsKey(dbTypeFactoryName)).ifPresent(v -> properties.setProperty(dbTypeFactoryName, (String)v));
        String dbFSFactoryKey = jdbcDriver + DB_FS_FACTORY_SUFFIX;
        String dbFSFactoryName = DBFunctionSymbolFactory.class.getCanonicalName();
        Optional.ofNullable(properties.getProperty(dbFSFactoryKey)).filter(v -> !userProperties.containsKey(dbFSFactoryName)).ifPresent(v -> properties.setProperty(dbFSFactoryName, (String)v));
        String serializerKey = jdbcDriver + DIALECT_SERIALIZER_SUFFIX;
        String serializerName = SelectFromWhereSerializer.class.getCanonicalName();
        Optional.ofNullable(properties.getProperty(serializerKey)).filter(v -> !userProperties.containsKey(serializerName)).ifPresent(v -> properties.setProperty(serializerName, (String)v));
        String normalizerKey = jdbcDriver + DIALECT_NORMALIZER_SUFFIX;
        String normalizerName = DialectExtraNormalizer.class.getCanonicalName();
        Optional.ofNullable(properties.getProperty(normalizerKey)).filter(v -> !userProperties.containsKey(normalizerName)).ifPresent(v -> properties.setProperty(normalizerName, (String)v));
        String dbMPFactoryKey = jdbcDriver + DB_MP_FACTORY_SUFFIX;
        String dbMPFactoryName = DBMetadataProvider.class.getCanonicalName();
        Optional.ofNullable(properties.getProperty(dbMPFactoryKey)).filter(v -> !userProperties.containsKey(dbMPFactoryName)).ifPresent(v -> properties.setProperty(dbMPFactoryName, (String)v));
        return properties;
    }

    public static String extractJdbcUrl(Properties userProperties) {
        return Optional.ofNullable(userProperties.getProperty("jdbc.url")).orElseThrow(() -> new InvalidOntopConfigurationException("jdbc.url is required"));
    }

    public static String extractJdbcDriver(Properties userProperties) {
        return Optional.ofNullable(userProperties.getProperty("jdbc.driver")).orElseGet(() -> {
            try {
                return DriverManager.getDriver(OntopSQLCoreSettingsImpl.extractJdbcUrl(userProperties)).getClass().getCanonicalName();
            }
            catch (SQLException e) {
                throw new InvalidOntopConfigurationException("Impossible to get the JDBC driver. Reason: " + e.getMessage());
            }
        });
    }

    @Override
    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    @Override
    public String getJdbcName() {
        return this.jdbcName;
    }

    @Override
    public String getJdbcDriver() {
        return this.jdbcDriver;
    }
}

