/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.normalization.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import it.unibz.inf.ontop.generation.normalization.DialectExtraNormalizer;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.type.UniqueTermTypeExtractor;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Map;
import java.util.Optional;

public class TypingNullsDialectExtraNormalizer
extends DefaultRecursiveIQTreeVisitingTransformer
implements DialectExtraNormalizer {
    private final UniqueTermTypeExtractor uniqueTermTypeExtractor;
    private final TermFactory termFactory;
    private final SubstitutionFactory substitutionFactory;

    @Inject
    protected TypingNullsDialectExtraNormalizer(CoreSingletons coreSingletons, UniqueTermTypeExtractor uniqueTermTypeExtractor) {
        super(coreSingletons);
        this.uniqueTermTypeExtractor = uniqueTermTypeExtractor;
        this.termFactory = coreSingletons.getTermFactory();
        this.substitutionFactory = coreSingletons.getSubstitutionFactory();
    }

    @Override
    public IQTree transform(IQTree tree, VariableGenerator variableGenerator) {
        return this.transform(tree);
    }

    public IQTree transformUnion(IQTree tree, UnionNode rootNode, ImmutableList<IQTree> children) {
        ImmutableList updatedChildren = (ImmutableList)children.stream().map(arg_0 -> ((TypingNullsDialectExtraNormalizer)this).transform(arg_0)).collect(ImmutableCollectors.toList());
        ImmutableSet nullVariables = (ImmutableSet)updatedChildren.stream().map(IQTree::getRootNode).filter(c -> c instanceof ConstructionNode).map(c -> (ConstructionNode)c).flatMap(c -> c.getSubstitution().getImmutableMap().entrySet().stream()).filter(e -> ((ImmutableTerm)e.getValue()).isNull()).map(Map.Entry::getKey).collect(ImmutableCollectors.toSet());
        if (nullVariables.isEmpty()) {
            return updatedChildren.equals(children) ? tree : this.iqFactory.createNaryIQTree((NaryOperatorNode)rootNode, updatedChildren);
        }
        ImmutableMap typeMap = (ImmutableMap)nullVariables.stream().collect(ImmutableCollectors.toMap(v -> v, v -> this.uniqueTermTypeExtractor.extractUniqueTermType((ImmutableTerm)v, tree)));
        ImmutableMap typedNullMap = (ImmutableMap)typeMap.entrySet().stream().filter(e -> ((Optional)e.getValue()).isPresent()).filter(e -> ((Optional)e.getValue()).filter(t -> t instanceof DBTermType).isPresent()).collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.termFactory.getTypedNull((DBTermType)((Optional)e.getValue()).get())));
        ImmutableList newChildren = (ImmutableList)updatedChildren.stream().map(c -> this.updateChild((IQTree)c, (ImmutableMap<Variable, ImmutableFunctionalTerm>)typedNullMap)).collect(ImmutableCollectors.toList());
        return this.iqFactory.createNaryIQTree((NaryOperatorNode)rootNode, newChildren);
    }

    private IQTree updateChild(IQTree child, ImmutableMap<Variable, ImmutableFunctionalTerm> typedNullMap) {
        if (child.getRootNode() instanceof ConstructionNode) {
            ConstructionNode constructionNode = (ConstructionNode)child.getRootNode();
            ImmutableMap newSubstitutionMap = (ImmutableMap)constructionNode.getSubstitution().getImmutableMap().entrySet().stream().map(e -> Optional.ofNullable(typedNullMap.get(e.getKey())).filter(n -> ((ImmutableTerm)e.getValue()).isNull()).map(n -> Maps.immutableEntry(e.getKey(), (Object)n)).orElse((Map.Entry)e)).collect(ImmutableCollectors.toMap());
            ConstructionNode newConstructionNode = this.iqFactory.createConstructionNode(constructionNode.getVariables(), this.substitutionFactory.getSubstitution(newSubstitutionMap));
            return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)newConstructionNode, ((UnaryIQTree)child).getChild());
        }
        return child;
    }
}

