/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.QuotedIDImpl;
import it.unibz.inf.ontop.dbschema.impl.RelationIDImpl;

public class MySQLQuotedIDFactory
implements QuotedIDFactory {
    private static final String MY_SQL_QUOTATION_STRING = "`";
    private final boolean caseSensitiveTableNames;

    MySQLQuotedIDFactory(boolean caseSensitiveTableNames) {
        this.caseSensitiveTableNames = caseSensitiveTableNames;
    }

    public QuotedID createAttributeID(String s) {
        if (s == null) {
            return new QuotedIDImpl(s, "");
        }
        if (s.startsWith(MY_SQL_QUOTATION_STRING) && s.endsWith(MY_SQL_QUOTATION_STRING)) {
            return new QuotedIDImpl(s.substring(1, s.length() - 1), MY_SQL_QUOTATION_STRING, false);
        }
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return new QuotedIDImpl(s.substring(1, s.length() - 1), MY_SQL_QUOTATION_STRING, false);
        }
        return new QuotedIDImpl(s, "", false);
    }

    public RelationID createRelationID(String schema, String table) {
        return new RelationIDImpl(this.createFromString(schema), this.createFromString(table));
    }

    private QuotedID createFromString(String s) {
        if (s == null) {
            return new QuotedIDImpl(s, "");
        }
        if (s.startsWith(MY_SQL_QUOTATION_STRING) && s.endsWith(MY_SQL_QUOTATION_STRING)) {
            return new QuotedIDImpl(s.substring(1, s.length() - 1), MY_SQL_QUOTATION_STRING, this.caseSensitiveTableNames);
        }
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return new QuotedIDImpl(s.substring(1, s.length() - 1), MY_SQL_QUOTATION_STRING, this.caseSensitiveTableNames);
        }
        return new QuotedIDImpl(s, "", this.caseSensitiveTableNames);
    }

    public String getIDQuotationString() {
        return MY_SQL_QUOTATION_STRING;
    }
}

