/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.impl;

import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.model.type.ConcreteNumericRDFDatatype;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeAncestry;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.type.impl.DatetimeDBTermType;
import it.unibz.inf.ontop.model.type.impl.DefaultSQLDBTypeFactory;
import it.unibz.inf.ontop.model.type.impl.NumberDBTermType;
import it.unibz.inf.ontop.model.type.impl.StringDBTermType;
import java.util.Map;

public class OracleDBTypeFactory
extends DefaultSQLDBTypeFactory {
    public static final String NUMBER_STR = "NUMBER";
    public static final String NUMBER_19_STR = "NUMBER(19)";
    public static final String VARCHAR2_STR = "VARCHAR2";
    public static final String NVARCHAR2_STR = "NVARCHAR2";
    public static final String BINARY_FLOAT_STR = "BINARY_FLOAT";
    public static final String BINARY_DOUBLE_STR = "BINARY_DOUBLE";
    public static final String TIMESTAMP_LOCAL_TZ_STR = "TIMESTAMP WITH LOCAL TIME ZONE";
    public static final String TIMESTAMP_TZ_STR = "TIMESTAMP WITH TIME ZONE";

    @AssistedInject
    private OracleDBTypeFactory(@Assisted TermType rootTermType, @Assisted TypeFactory typeFactory) {
        super(OracleDBTypeFactory.createOracleTypeMap(rootTermType, typeFactory), OracleDBTypeFactory.createOracleCodeMap());
    }

    private static Map<String, DBTermType> createOracleTypeMap(TermType rootTermType, TypeFactory typeFactory) {
        TermTypeAncestry rootAncestry = rootTermType.getAncestry();
        NumberDBTermType numberType = new NumberDBTermType(NUMBER_STR, rootAncestry, (RDFDatatype)typeFactory.getXsdDecimalDatatype(), DBTermType.Category.DECIMAL);
        NumberDBTermType number19Type = new NumberDBTermType(NUMBER_19_STR, rootAncestry, (RDFDatatype)typeFactory.getXsdIntegerDatatype(), DBTermType.Category.INTEGER);
        RDFDatatype xsdString = typeFactory.getXsdStringDatatype();
        StringDBTermType varchar2Type = new StringDBTermType(VARCHAR2_STR, rootAncestry, xsdString);
        StringDBTermType nVarchar2Type = new StringDBTermType(NVARCHAR2_STR, rootAncestry, xsdString);
        ConcreteNumericRDFDatatype xsdDouble = typeFactory.getXsdDoubleDatatype();
        NumberDBTermType binaryFloatType = new NumberDBTermType(BINARY_FLOAT_STR, rootTermType.getAncestry(), (RDFDatatype)xsdDouble, DBTermType.Category.FLOAT_DOUBLE);
        NumberDBTermType binaryDoubleType = new NumberDBTermType(BINARY_DOUBLE_STR, rootTermType.getAncestry(), (RDFDatatype)xsdDouble, DBTermType.Category.FLOAT_DOUBLE);
        RDFDatatype xsdDatetime = typeFactory.getXsdDatetimeDatatype();
        DatetimeDBTermType timestampLTZType = new DatetimeDBTermType(TIMESTAMP_LOCAL_TZ_STR, rootAncestry, xsdDatetime);
        DatetimeDBTermType timestampTZType = new DatetimeDBTermType(TIMESTAMP_TZ_STR, rootAncestry, xsdDatetime);
        Map<String, DBTermType> map = OracleDBTypeFactory.createDefaultSQLTypeMap(rootTermType, typeFactory);
        map.put(NUMBER_STR, (DBTermType)numberType);
        map.put(NUMBER_19_STR, (DBTermType)number19Type);
        map.put(VARCHAR2_STR, (DBTermType)varchar2Type);
        map.put(NVARCHAR2_STR, (DBTermType)nVarchar2Type);
        map.put(BINARY_FLOAT_STR, (DBTermType)binaryFloatType);
        map.put(BINARY_DOUBLE_STR, (DBTermType)binaryDoubleType);
        map.put(TIMESTAMP_LOCAL_TZ_STR, (DBTermType)timestampLTZType);
        map.put(TIMESTAMP_TZ_STR, (DBTermType)timestampTZType);
        return map;
    }

    private static ImmutableMap<DefaultSQLDBTypeFactory.DefaultTypeCode, String> createOracleCodeMap() {
        Map<DefaultSQLDBTypeFactory.DefaultTypeCode, String> map = OracleDBTypeFactory.createDefaultSQLCodeMap();
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DECIMAL, NUMBER_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.LARGE_INTEGER, NUMBER_19_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DOUBLE, BINARY_DOUBLE_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DATETIMESTAMP, TIMESTAMP_TZ_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.STRING, VARCHAR2_STR);
        return ImmutableMap.copyOf(map);
    }

    @Override
    public String getDBTrueLexicalValue() {
        return "1";
    }

    @Override
    public String getDBFalseLexicalValue() {
        return "0";
    }
}

