/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.impl;

import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.model.type.ConcreteNumericRDFDatatype;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeAncestry;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.type.impl.BooleanDBTermType;
import it.unibz.inf.ontop.model.type.impl.DatetimeDBTermType;
import it.unibz.inf.ontop.model.type.impl.DefaultSQLDBTypeFactory;
import it.unibz.inf.ontop.model.type.impl.NonStringNonNumberNonBooleanNonDatetimeDBTermType;
import it.unibz.inf.ontop.model.type.impl.NumberDBTermType;
import it.unibz.inf.ontop.model.type.impl.StringDBTermType;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import java.util.Map;
import java.util.Optional;

public class MySQLDBTypeFactory
extends DefaultSQLDBTypeFactory {
    public static final String BIT_STR = "BIT";
    public static final String BIT_ONE_STR = "BIT(1)";
    private static final String TINY_INT_ONE_STR = "TINYINT(1)";
    protected static final String TINYBLOB_STR = "TINYBLOB";
    protected static final String MEDIUMBLOB_STR = "MEDIUMBLOB";
    protected static final String LONGBLOB_STR = "LONGBLOB";
    protected static final String TINYTEXT_STR = "TINYTEXT";
    protected static final String MEDIUMTEXT_STR = "MEDIUMTEXT";
    protected static final String LONGTEXT_STR = "LONGTEXT";
    protected static final String SET_STR = "SET";
    protected static final String ENUM_STR = "ENUM";
    protected static final String MEDIUMINT_STR = "MEDIUMINT";
    protected static final String UNSIGNED_SUFFIX = " UNSIGNED";
    public static final String YEAR_STR = "YEAR";
    public static final String DATETIME_STR = "DATETIME";

    @AssistedInject
    protected MySQLDBTypeFactory(@Assisted TermType rootTermType, @Assisted TypeFactory typeFactory) {
        super(MySQLDBTypeFactory.createMySQLTypeMap(rootTermType, typeFactory), MySQLDBTypeFactory.createMySQLCodeMap());
    }

    protected static Map<String, DBTermType> createMySQLTypeMap(TermType rootTermType, TypeFactory typeFactory) {
        TermTypeAncestry rootAncestry = rootTermType.getAncestry();
        ConcreteNumericRDFDatatype xsdInteger = typeFactory.getXsdIntegerDatatype();
        NumberDBTermType bigIntType = new NumberDBTermType("BIGINT", "SIGNED", rootAncestry, (RDFDatatype)xsdInteger, DBTermType.Category.INTEGER);
        StringDBTermType textType = new StringDBTermType("TEXT", "CHAR CHARACTER SET utf8", rootAncestry, typeFactory.getXsdStringDatatype());
        NumberDBTermType decimalType = new NumberDBTermType("DECIMAL", "DECIMAL(60,30)", rootAncestry, (RDFDatatype)typeFactory.getXsdDecimalDatatype(), DBTermType.Category.DECIMAL);
        RDFDatatype xsdString = typeFactory.getXsdStringDatatype();
        StringDBTermType tinyBlobType = new StringDBTermType(TINYBLOB_STR, rootAncestry, xsdString);
        StringDBTermType mediumBlobType = new StringDBTermType(MEDIUMBLOB_STR, rootAncestry, xsdString);
        StringDBTermType longBlobType = new StringDBTermType(LONGBLOB_STR, rootAncestry, xsdString);
        StringDBTermType tinyTextType = new StringDBTermType(TINYTEXT_STR, rootAncestry, xsdString);
        StringDBTermType mediumTextType = new StringDBTermType(MEDIUMTEXT_STR, rootAncestry, xsdString);
        StringDBTermType longTextType = new StringDBTermType(LONGTEXT_STR, rootAncestry, xsdString);
        StringDBTermType setTextType = new StringDBTermType(SET_STR, rootAncestry, xsdString);
        StringDBTermType enumTextType = new StringDBTermType(ENUM_STR, rootAncestry, xsdString);
        NumberDBTermType mediumIntType = new NumberDBTermType(MEDIUMINT_STR, rootAncestry, (RDFDatatype)xsdInteger, DBTermType.Category.INTEGER);
        NumberDBTermType unsignedTinyIntType = new NumberDBTermType("TINYINT UNSIGNED", rootAncestry, (RDFDatatype)xsdInteger, DBTermType.Category.INTEGER);
        NumberDBTermType unsignedSmallIntType = new NumberDBTermType("SMALLINT UNSIGNED", rootAncestry, (RDFDatatype)xsdInteger, DBTermType.Category.INTEGER);
        NumberDBTermType unsignedMediumIntType = new NumberDBTermType("MEDIUMINT UNSIGNED", rootAncestry, (RDFDatatype)xsdInteger, DBTermType.Category.INTEGER);
        NumberDBTermType unsignedIntType = new NumberDBTermType("INT UNSIGNED", rootAncestry, (RDFDatatype)xsdInteger, DBTermType.Category.INTEGER);
        NumberDBTermType unsignedBigIntType = new NumberDBTermType("BIGINT UNSIGNED", rootAncestry, (RDFDatatype)xsdInteger, DBTermType.Category.INTEGER);
        DatetimeDBTermType datetimeType = new DatetimeDBTermType(DATETIME_STR, rootTermType.getAncestry(), typeFactory.getXsdDatetimeDatatype());
        NonStringNonNumberNonBooleanNonDatetimeDBTermType defaultBitType = new NonStringNonNumberNonBooleanNonDatetimeDBTermType(BIT_STR, rootAncestry, false);
        RDFDatatype xsdBoolean = typeFactory.getXsdBooleanDatatype();
        BooleanDBTermType bitOneType = new BooleanDBTermType(BIT_ONE_STR, rootTermType.getAncestry(), xsdBoolean);
        NonStringNonNumberNonBooleanNonDatetimeDBTermType yearType = new NonStringNonNumberNonBooleanNonDatetimeDBTermType(YEAR_STR, rootAncestry, typeFactory.getDatatype(XSD.GYEAR), NonStringNonNumberNonBooleanNonDatetimeDBTermType.StrictEqSupport.SAME_TYPE);
        Map<String, DBTermType> map = MySQLDBTypeFactory.createDefaultSQLTypeMap(rootTermType, typeFactory);
        map.put(BIT_ONE_STR, (DBTermType)bitOneType);
        map.put(BIT_STR, (DBTermType)defaultBitType);
        map.put(TINYBLOB_STR, (DBTermType)tinyBlobType);
        map.put(MEDIUMBLOB_STR, (DBTermType)mediumBlobType);
        map.put(LONGBLOB_STR, (DBTermType)longBlobType);
        map.put(TINYTEXT_STR, (DBTermType)tinyTextType);
        map.put(MEDIUMTEXT_STR, (DBTermType)mediumTextType);
        map.put(LONGTEXT_STR, (DBTermType)longTextType);
        map.put(SET_STR, (DBTermType)setTextType);
        map.put(ENUM_STR, (DBTermType)enumTextType);
        map.put("TEXT", (DBTermType)textType);
        map.put(MEDIUMINT_STR, (DBTermType)mediumIntType);
        map.put("BIGINT", (DBTermType)bigIntType);
        map.put("TINYINT UNSIGNED", (DBTermType)unsignedTinyIntType);
        map.put("SMALLINT UNSIGNED", (DBTermType)unsignedSmallIntType);
        map.put("MEDIUMINT UNSIGNED", (DBTermType)unsignedMediumIntType);
        map.put("INT UNSIGNED", (DBTermType)unsignedIntType);
        map.put("BIGINT UNSIGNED", (DBTermType)unsignedBigIntType);
        map.put("DECIMAL", (DBTermType)decimalType);
        map.put(DATETIME_STR, (DBTermType)datetimeType);
        map.put(YEAR_STR, (DBTermType)yearType);
        return map;
    }

    protected static ImmutableMap<DefaultSQLDBTypeFactory.DefaultTypeCode, String> createMySQLCodeMap() {
        Map<DefaultSQLDBTypeFactory.DefaultTypeCode, String> map = MySQLDBTypeFactory.createDefaultSQLCodeMap();
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DOUBLE, "DECIMAL");
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DATETIMESTAMP, DATETIME_STR);
        return ImmutableMap.copyOf(map);
    }

    @Override
    public Optional<String> getDBNaNLexicalValue() {
        return Optional.empty();
    }

    @Override
    protected String preprocessTypeName(String typeName) {
        String capitalizedTypeName;
        switch (capitalizedTypeName = typeName.toUpperCase()) {
            case "TINYINT(1)": {
                return "BOOLEAN";
            }
            case "BIT(1)": {
                return capitalizedTypeName;
            }
        }
        return super.preprocessTypeName(capitalizedTypeName);
    }

    @Override
    protected String preprocessTypeName(String typeName, int columnSize) {
        String capitalizedTypeName;
        switch (capitalizedTypeName = typeName.toUpperCase()) {
            case "TINYINT": {
                if (columnSize != 1) break;
                return "BOOLEAN";
            }
            case "BIT": {
                if (columnSize != 1) break;
                return capitalizedTypeName + "(1)";
            }
        }
        return super.preprocessTypeName(capitalizedTypeName);
    }

    @Override
    public String getDBTrueLexicalValue() {
        return "1";
    }

    @Override
    public String getDBFalseLexicalValue() {
        return "0";
    }
}

