/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.impl;

import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.model.type.ConcreteNumericRDFDatatype;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeAncestry;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.type.impl.BooleanDBTermType;
import it.unibz.inf.ontop.model.type.impl.DatetimeDBTermType;
import it.unibz.inf.ontop.model.type.impl.DefaultSQLDBTypeFactory;
import it.unibz.inf.ontop.model.type.impl.NonStringNonNumberNonBooleanNonDatetimeDBTermType;
import it.unibz.inf.ontop.model.type.impl.NumberDBTermType;
import it.unibz.inf.ontop.model.type.impl.StringDBTermType;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import java.util.Map;

public class DenodoDBTypeFactory
extends DefaultSQLDBTypeFactory {
    protected static final String VARBIT_STR = "VARBIT";
    protected static final String BIT_STR = "BIT";
    protected static final String FLOAT4_STR = "FLOAT4";
    protected static final String FLOAT8_STR = "FLOAT8";
    public static final String SERIAL_STR = "SERIAL";
    protected static final String BIGSERIAL_STR = "BIGSERIAL";
    protected static final String BPCHAR_STR = "BPCHAR";
    protected static final String NAME_STR = "NAME";
    public static final String TIMESTAMPTZ_STR = "TIMESTAMP_WITH_TIMEZONE";
    public static final String TIMETZ_STR = "TIMETZ";
    public static final String BOOL_STR = "BOOL";
    public static final String UUID_STR = "UUID";

    @AssistedInject
    protected DenodoDBTypeFactory(@Assisted TermType rootTermType, @Assisted TypeFactory typeFactory) {
        super(DenodoDBTypeFactory.createDenodoTypeMap(rootTermType, typeFactory), DenodoDBTypeFactory.createDenodoCodeMap());
    }

    protected static Map<String, DBTermType> createDenodoTypeMap(TermType rootTermType, TypeFactory typeFactory) {
        TermTypeAncestry rootAncestry = rootTermType.getAncestry();
        ConcreteNumericRDFDatatype xsdInteger = typeFactory.getXsdIntegerDatatype();
        ConcreteNumericRDFDatatype xsdDouble = typeFactory.getXsdDoubleDatatype();
        RDFDatatype xsdString = typeFactory.getXsdStringDatatype();
        RDFDatatype xsdBoolean = typeFactory.getXsdBooleanDatatype();
        BooleanDBTermType bitType = new BooleanDBTermType(BIT_STR, rootAncestry, typeFactory.getXsdBooleanDatatype());
        BooleanDBTermType varBitType = new BooleanDBTermType(VARBIT_STR, rootAncestry, typeFactory.getXsdBooleanDatatype());
        NumberDBTermType serialType = new NumberDBTermType(SERIAL_STR, rootAncestry, (RDFDatatype)xsdInteger, DBTermType.Category.INTEGER);
        NumberDBTermType bigSerialType = new NumberDBTermType(BIGSERIAL_STR, rootAncestry, (RDFDatatype)xsdInteger, DBTermType.Category.INTEGER);
        NumberDBTermType float4Type = new NumberDBTermType(FLOAT4_STR, rootTermType.getAncestry(), (RDFDatatype)xsdDouble, DBTermType.Category.FLOAT_DOUBLE);
        NumberDBTermType float8Type = new NumberDBTermType(FLOAT8_STR, rootTermType.getAncestry(), (RDFDatatype)xsdDouble, DBTermType.Category.FLOAT_DOUBLE);
        StringDBTermType bpCharType = new StringDBTermType(BPCHAR_STR, rootAncestry, xsdString);
        StringDBTermType nameType = new StringDBTermType(NAME_STR, rootAncestry, xsdString);
        DatetimeDBTermType timestampTz = new DatetimeDBTermType(TIMESTAMPTZ_STR, rootTermType.getAncestry(), typeFactory.getXsdDatetimeDatatype());
        NonStringNonNumberNonBooleanNonDatetimeDBTermType timeTzType = new NonStringNonNumberNonBooleanNonDatetimeDBTermType(TIMETZ_STR, rootAncestry, typeFactory.getDatatype(XSD.TIME), NonStringNonNumberNonBooleanNonDatetimeDBTermType.StrictEqSupport.NOTHING);
        BooleanDBTermType boolType = new BooleanDBTermType(BOOL_STR, rootTermType.getAncestry(), xsdBoolean);
        NonStringNonNumberNonBooleanNonDatetimeDBTermType uuidType = new NonStringNonNumberNonBooleanNonDatetimeDBTermType(UUID_STR, rootTermType.getAncestry(), NonStringNonNumberNonBooleanNonDatetimeDBTermType.StrictEqSupport.WITH_ALL);
        Map<String, DBTermType> map = DenodoDBTypeFactory.createDefaultSQLTypeMap(rootTermType, typeFactory);
        map.put(TIMESTAMPTZ_STR, (DBTermType)timestampTz);
        return map;
    }

    protected static ImmutableMap<DefaultSQLDBTypeFactory.DefaultTypeCode, String> createDenodoCodeMap() {
        Map<DefaultSQLDBTypeFactory.DefaultTypeCode, String> map = DenodoDBTypeFactory.createDefaultSQLCodeMap();
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DATETIMESTAMP, TIMESTAMPTZ_STR);
        return ImmutableMap.copyOf(map);
    }
}

