/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractR2RMLSafeIRIEncodeFunctionSymbol;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.utils.R2RMLIRISafeEncoder;
import java.util.Map;
import java.util.function.Function;

public class DefaultSQLR2RMLSafeIRIEncodeFunctionSymbol
extends AbstractR2RMLSafeIRIEncodeFunctionSymbol {
    private final String encodeForIriStart;
    private final String encodeForIriEnd;

    protected DefaultSQLR2RMLSafeIRIEncodeFunctionSymbol(DBTermType dbStringType) {
        super(dbStringType);
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        for (Map.Entry e : R2RMLIRISafeEncoder.TABLE.entrySet()) {
            sb1.append("REPLACE(");
            String value = (String)e.getValue();
            String encode = (String)e.getKey();
            sb2.append(", ").append(this.encodeSQLStringConstant(value)).append(", ").append(this.encodeSQLStringConstant(encode)).append(")");
        }
        this.encodeForIriStart = sb1.toString();
        this.encodeForIriEnd = sb2.toString();
    }

    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return true;
    }

    public String getNativeDBString(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return this.encodeForIriStart + termConverter.apply((ImmutableTerm)terms.get(0)) + this.encodeForIriEnd;
    }

    protected String encodeSQLStringConstant(String constant) {
        return "'" + constant.replaceAll("(?<!')'(?!')", this.getEscapedSingleQuote()) + "'";
    }

    protected String getEscapedSingleQuote() {
        return "''";
    }
}

