/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.serializer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.generation.algebra.SQLOrderComparator;
import it.unibz.inf.ontop.generation.algebra.SelectFromWhereWithModifiers;
import it.unibz.inf.ontop.generation.serializer.SelectFromWhereSerializer;
import it.unibz.inf.ontop.generation.serializer.impl.DefaultSelectFromWhereSerializer;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import java.util.stream.Collectors;

@Singleton
public class DenodoSelectFromWhereSerializer
extends DefaultSelectFromWhereSerializer
implements SelectFromWhereSerializer {
    @Inject
    private DenodoSelectFromWhereSerializer(TermFactory termFactory) {
        super(new DefaultSelectFromWhereSerializer.DefaultSQLTermSerializer(termFactory));
    }

    @Override
    public SelectFromWhereSerializer.QuerySerialization serialize(SelectFromWhereWithModifiers selectFromWhere, DBParameters dbParameters) {
        return selectFromWhere.acceptVisitor(new DefaultSelectFromWhereSerializer.DefaultRelationVisitingSerializer(dbParameters.getQuotedIDFactory()){
            private final String CONTEXT = " CONTEXT('i18n'='us_utc_iso')";
            {
                this.CONTEXT = " CONTEXT('i18n'='us_utc_iso')";
            }

            @Override
            public String serializeLimitOffset(long limit, long offset) {
                return String.format("OFFSET %d ROWS\nFETCH NEXT %d ROWS ONLY", offset, limit);
            }

            @Override
            protected String serializeOffset(long offset) {
                return String.format("OFFSET %d ROWS", offset);
            }

            @Override
            protected String serializeOrderBy(ImmutableList<SQLOrderComparator> sortConditions, ImmutableMap<Variable, QualifiedAttributeID> fromColumnMap) {
                if (sortConditions.isEmpty()) {
                    return "";
                }
                String conditionString = sortConditions.stream().map(c -> DenodoSelectFromWhereSerializer.this.sqlTermSerializer.serialize((ImmutableTerm)c.getTerm(), fromColumnMap) + (c.isAscending() ? " ASC NULLS FIRST" : " DESC NULLS LAST")).collect(Collectors.joining(", "));
                return String.format("ORDER BY %s\n", conditionString);
            }
        });
    }
}

