/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.serializer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.generation.algebra.BinaryJoinExpression;
import it.unibz.inf.ontop.generation.algebra.SQLExpression;
import it.unibz.inf.ontop.generation.algebra.SQLInnerJoinExpression;
import it.unibz.inf.ontop.generation.algebra.SQLLeftJoinExpression;
import it.unibz.inf.ontop.generation.algebra.SQLNaryJoinExpression;
import it.unibz.inf.ontop.generation.algebra.SQLOneTupleDummyQueryExpression;
import it.unibz.inf.ontop.generation.algebra.SQLOrderComparator;
import it.unibz.inf.ontop.generation.algebra.SQLRelationVisitor;
import it.unibz.inf.ontop.generation.algebra.SQLSerializedQuery;
import it.unibz.inf.ontop.generation.algebra.SQLTable;
import it.unibz.inf.ontop.generation.algebra.SQLUnionExpression;
import it.unibz.inf.ontop.generation.algebra.SelectFromWhereWithModifiers;
import it.unibz.inf.ontop.generation.serializer.SQLSerializationException;
import it.unibz.inf.ontop.generation.serializer.SelectFromWhereSerializer;
import it.unibz.inf.ontop.generation.serializer.impl.AttributeAliasFactory;
import it.unibz.inf.ontop.generation.serializer.impl.DefaultAttributeAliasFactory;
import it.unibz.inf.ontop.generation.serializer.impl.SQLTermSerializer;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbol;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;

@Singleton
public class DefaultSelectFromWhereSerializer
implements SelectFromWhereSerializer {
    protected final SQLTermSerializer sqlTermSerializer;

    @Inject
    private DefaultSelectFromWhereSerializer(TermFactory termFactory) {
        this(new DefaultSQLTermSerializer(termFactory));
    }

    protected DefaultSelectFromWhereSerializer(SQLTermSerializer sqlTermSerializer) {
        this.sqlTermSerializer = sqlTermSerializer;
    }

    @Override
    public SelectFromWhereSerializer.QuerySerialization serialize(SelectFromWhereWithModifiers selectFromWhere, DBParameters dbParameters) {
        return selectFromWhere.acceptVisitor(new DefaultRelationVisitingSerializer(dbParameters.getQuotedIDFactory()));
    }

    protected static class DefaultSQLTermSerializer
    implements SQLTermSerializer {
        private final TermFactory termFactory;

        protected DefaultSQLTermSerializer(TermFactory termFactory) {
            this.termFactory = termFactory;
        }

        @Override
        public String serialize(ImmutableTerm term, ImmutableMap<Variable, QualifiedAttributeID> columnIDs) throws SQLSerializationException {
            if (term instanceof Constant) {
                return this.serializeConstant((Constant)term);
            }
            if (term instanceof Variable) {
                return Optional.ofNullable(columnIDs.get((Object)term)).map(QualifiedAttributeID::getSQLRendering).orElseThrow(() -> new SQLSerializationException(String.format("The variable %s does not appear in the columnIDs", term)));
            }
            return Optional.of(term).filter(t -> t instanceof ImmutableFunctionalTerm).map(t -> (ImmutableFunctionalTerm)t).filter(t -> t.getFunctionSymbol() instanceof DBFunctionSymbol).map(t -> ((DBFunctionSymbol)t.getFunctionSymbol()).getNativeDBString(t.getTerms(), t2 -> this.serialize((ImmutableTerm)t2, columnIDs), this.termFactory)).orElseThrow(() -> new SQLSerializationException("Only DBFunctionSymbols must be provided to a SQLTermSerializer"));
        }

        private String serializeConstant(Constant constant) {
            if (constant.isNull()) {
                return constant.getValue();
            }
            if (!(constant instanceof DBConstant)) {
                throw new SQLSerializationException("Only DBConstants or NULLs are expected in sub-tree to be translated into SQL");
            }
            return this.serializeDBConstant((DBConstant)constant);
        }

        protected String serializeDBConstant(DBConstant constant) {
            DBTermType dbType = constant.getType();
            switch (dbType.getCategory()) {
                case DECIMAL: 
                case FLOAT_DOUBLE: {
                    return this.castFloatingConstant(constant.getValue(), dbType);
                }
                case INTEGER: 
                case BOOLEAN: {
                    return constant.getValue();
                }
            }
            return this.serializeStringConstant(constant.getValue());
        }

        protected String castFloatingConstant(String value, DBTermType dbType) {
            return String.format("CAST(%s AS %s)", value, dbType.getCastName());
        }

        protected String serializeStringConstant(String constant) {
            return "'" + constant.replaceAll("(?<!')'(?!')", "''") + "'";
        }
    }

    protected static class QuerySerializationImpl
    implements SelectFromWhereSerializer.QuerySerialization {
        private final String string;
        private final ImmutableMap<Variable, QualifiedAttributeID> columnIDs;

        public QuerySerializationImpl(String string, ImmutableMap<Variable, QualifiedAttributeID> columnIDs) {
            this.string = string;
            this.columnIDs = columnIDs;
        }

        @Override
        public String getString() {
            return this.string;
        }

        @Override
        public ImmutableMap<Variable, QualifiedAttributeID> getColumnIDs() {
            return this.columnIDs;
        }
    }

    protected class DefaultRelationVisitingSerializer
    implements SQLRelationVisitor<SelectFromWhereSerializer.QuerySerialization> {
        private static final String VIEW_PREFIX = "v";
        private static final String SELECT_FROM_WHERE_MODIFIERS_TEMPLATE = "SELECT %s%s\nFROM %s\n%s%s%s%s";
        protected final QuotedIDFactory idFactory;
        private final AtomicInteger viewCounter;

        protected DefaultRelationVisitingSerializer(QuotedIDFactory idFactory) {
            this.idFactory = idFactory;
            this.viewCounter = new AtomicInteger(0);
        }

        @Override
        public SelectFromWhereSerializer.QuerySerialization visit(SelectFromWhereWithModifiers selectFromWhere) {
            SelectFromWhereSerializer.QuerySerialization fromQuerySerialization = this.getSQLSerializationForChild(selectFromWhere.getFromSQLExpression());
            ImmutableMap<Variable, QuotedID> variableAliases = this.createVariableAliases((ImmutableSet<Variable>)selectFromWhere.getProjectedVariables());
            String distinctString = selectFromWhere.isDistinct() ? "DISTINCT " : "";
            ImmutableMap<Variable, QualifiedAttributeID> columnIDs = fromQuerySerialization.getColumnIDs();
            String projectionString = this.serializeProjection(selectFromWhere.getProjectedVariables(), variableAliases, selectFromWhere.getSubstitution(), columnIDs);
            String fromString = fromQuerySerialization.getString();
            String whereString = selectFromWhere.getWhereExpression().map(e -> DefaultSelectFromWhereSerializer.this.sqlTermSerializer.serialize((ImmutableTerm)e, columnIDs)).map(s -> String.format("WHERE %s\n", s)).orElse("");
            String groupByString = this.serializeGroupBy(selectFromWhere.getGroupByVariables(), columnIDs);
            String orderByString = this.serializeOrderBy(selectFromWhere.getSortConditions(), columnIDs);
            String sliceString = this.serializeSlice(selectFromWhere.getLimit(), selectFromWhere.getOffset());
            String sql = String.format(SELECT_FROM_WHERE_MODIFIERS_TEMPLATE, distinctString, projectionString, fromString, whereString, groupByString, orderByString, sliceString);
            RelationID alias = this.generateFreshViewAlias();
            return new QuerySerializationImpl(sql, this.attachRelationAlias(alias, variableAliases));
        }

        protected RelationID generateFreshViewAlias() {
            return this.idFactory.createRelationID(null, VIEW_PREFIX + this.viewCounter.incrementAndGet());
        }

        private ImmutableMap<Variable, QualifiedAttributeID> attachRelationAlias(RelationID alias, ImmutableMap<Variable, QuotedID> variableAliases) {
            return (ImmutableMap)variableAliases.entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> new QualifiedAttributeID(alias, (QuotedID)e.getValue())));
        }

        private ImmutableMap<Variable, QualifiedAttributeID> replaceRelationAlias(RelationID alias, ImmutableMap<Variable, QualifiedAttributeID> columnIDs) {
            return (ImmutableMap)columnIDs.entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> new QualifiedAttributeID(alias, ((QualifiedAttributeID)e.getValue()).getAttribute())));
        }

        private ImmutableMap<Variable, QuotedID> createVariableAliases(ImmutableSet<Variable> variables) {
            AttributeAliasFactory aliasFactory = this.createAtttibuteAliasFactory();
            return (ImmutableMap)variables.stream().collect(ImmutableCollectors.toMap(Function.identity(), v -> aliasFactory.createAttributeAlias(v.getName())));
        }

        protected AttributeAliasFactory createAtttibuteAliasFactory() {
            return new DefaultAttributeAliasFactory(this.idFactory);
        }

        protected String serializeDummyTable() {
            return "";
        }

        protected String serializeProjection(ImmutableSortedSet<Variable> projectedVariables, ImmutableMap<Variable, QuotedID> variableAliases, ImmutableSubstitution<? extends ImmutableTerm> substitution, ImmutableMap<Variable, QualifiedAttributeID> columnIDs) {
            if (projectedVariables.isEmpty()) {
                return "1 AS uselessVariable";
            }
            return projectedVariables.stream().map(v -> DefaultSelectFromWhereSerializer.this.sqlTermSerializer.serialize(Optional.ofNullable(substitution.get(v)).orElse((ImmutableTerm)v), columnIDs) + " AS " + ((QuotedID)variableAliases.get(v)).getSQLRendering()).collect(Collectors.joining(", "));
        }

        protected String serializeGroupBy(ImmutableSet<Variable> groupByVariables, ImmutableMap<Variable, QualifiedAttributeID> columnIDs) {
            if (groupByVariables.isEmpty()) {
                return "";
            }
            String variableString = groupByVariables.stream().map(v -> DefaultSelectFromWhereSerializer.this.sqlTermSerializer.serialize((ImmutableTerm)v, columnIDs)).collect(Collectors.joining(", "));
            return String.format("GROUP BY %s\n", variableString);
        }

        protected String serializeOrderBy(ImmutableList<SQLOrderComparator> sortConditions, ImmutableMap<Variable, QualifiedAttributeID> columnIDs) {
            if (sortConditions.isEmpty()) {
                return "";
            }
            String conditionString = sortConditions.stream().map(c -> DefaultSelectFromWhereSerializer.this.sqlTermSerializer.serialize((ImmutableTerm)c.getTerm(), columnIDs) + (c.isAscending() ? " NULLS FIRST" : " DESC NULLS LAST")).collect(Collectors.joining(", "));
            return String.format("ORDER BY %s\n", conditionString);
        }

        protected String serializeLimitOffset(long limit, long offset) {
            return String.format("LIMIT %d, %d", offset, limit);
        }

        protected String serializeLimit(long limit) {
            return String.format("LIMIT %d", limit);
        }

        protected String serializeOffset(long offset) {
            return String.format("OFFSET %d", offset);
        }

        private String serializeSlice(Optional<Long> limit, Optional<Long> offset) {
            if (!limit.isPresent() && !offset.isPresent()) {
                return "";
            }
            if (limit.isPresent() && offset.isPresent()) {
                return this.serializeLimitOffset(limit.get(), offset.get());
            }
            if (limit.isPresent()) {
                return this.serializeLimit(limit.get());
            }
            return this.serializeOffset(offset.get());
        }

        @Override
        public SelectFromWhereSerializer.QuerySerialization visit(SQLSerializedQuery sqlSerializedQuery) {
            RelationID alias = this.generateFreshViewAlias();
            String sql = String.format("(%s) %s", sqlSerializedQuery.getSQLString(), alias.getSQLRendering());
            return new QuerySerializationImpl(sql, this.attachRelationAlias(alias, sqlSerializedQuery.getColumnNames()));
        }

        @Override
        public SelectFromWhereSerializer.QuerySerialization visit(SQLTable sqlTable) {
            RelationID alias = this.generateFreshViewAlias();
            RelationDefinition relation = sqlTable.getRelationDefinition();
            String relationRendering = relation.getAtomPredicate().getName();
            String sql = String.format("%s %s", relationRendering, alias.getSQLRendering());
            return new QuerySerializationImpl(sql, this.attachRelationAlias(alias, (ImmutableMap<Variable, QuotedID>)((ImmutableMap)sqlTable.getArgumentMap().entrySet().stream().collect(ImmutableCollectors.toMap(e -> (Variable)e.getValue(), e -> relation.getAttribute((Integer)e.getKey() + 1).getID())))));
        }

        @Override
        public SelectFromWhereSerializer.QuerySerialization visit(SQLNaryJoinExpression sqlNaryJoinExpression) {
            ImmutableList querySerializationList = (ImmutableList)sqlNaryJoinExpression.getJoinedExpressions().stream().map(this::getSQLSerializationForChild).collect(ImmutableCollectors.toList());
            String sql = querySerializationList.stream().map(SelectFromWhereSerializer.QuerySerialization::getString).collect(Collectors.joining(", "));
            ImmutableMap columnIDs = (ImmutableMap)querySerializationList.stream().flatMap(m -> m.getColumnIDs().entrySet().stream()).collect(ImmutableCollectors.toMap());
            return new QuerySerializationImpl(sql, (ImmutableMap<Variable, QualifiedAttributeID>)columnIDs);
        }

        @Override
        public SelectFromWhereSerializer.QuerySerialization visit(SQLUnionExpression sqlUnionExpression) {
            ImmutableList querySerializationList = (ImmutableList)sqlUnionExpression.getSubExpressions().stream().map(e -> e.acceptVisitor(this)).collect(ImmutableCollectors.toList());
            RelationID alias = this.generateFreshViewAlias();
            String sql = String.format("(%s) %s", querySerializationList.stream().map(SelectFromWhereSerializer.QuerySerialization::getString).collect(Collectors.joining("UNION ALL \n")), alias.getSQLRendering());
            return new QuerySerializationImpl(sql, this.replaceRelationAlias(alias, ((SelectFromWhereSerializer.QuerySerialization)querySerializationList.get(0)).getColumnIDs()));
        }

        private SelectFromWhereSerializer.QuerySerialization getSQLSerializationForChild(SQLExpression expression) {
            if (expression instanceof SelectFromWhereWithModifiers) {
                SelectFromWhereSerializer.QuerySerialization serialization = expression.acceptVisitor(this);
                RelationID alias = this.generateFreshViewAlias();
                String sql = String.format("(%s) %s", serialization.getString(), alias.getSQLRendering());
                return new QuerySerializationImpl(sql, this.replaceRelationAlias(alias, serialization.getColumnIDs()));
            }
            return expression.acceptVisitor(this);
        }

        @Override
        public SelectFromWhereSerializer.QuerySerialization visit(SQLInnerJoinExpression sqlInnerJoinExpression) {
            return this.visit(sqlInnerJoinExpression, "JOIN");
        }

        @Override
        public SelectFromWhereSerializer.QuerySerialization visit(SQLLeftJoinExpression sqlLeftJoinExpression) {
            return this.visit(sqlLeftJoinExpression, "LEFT OUTER JOIN");
        }

        protected SelectFromWhereSerializer.QuerySerialization visit(BinaryJoinExpression binaryJoinExpression, String operatorString) {
            SelectFromWhereSerializer.QuerySerialization left = this.getSQLSerializationForChild(binaryJoinExpression.getLeft());
            SelectFromWhereSerializer.QuerySerialization right = this.getSQLSerializationForChild(binaryJoinExpression.getRight());
            ImmutableMap columnIDs = (ImmutableMap)ImmutableList.of((Object)left, (Object)right).stream().flatMap(m -> m.getColumnIDs().entrySet().stream()).collect(ImmutableCollectors.toMap());
            String onString = binaryJoinExpression.getFilterCondition().map(e -> DefaultSelectFromWhereSerializer.this.sqlTermSerializer.serialize((ImmutableTerm)e, (ImmutableMap<Variable, QualifiedAttributeID>)columnIDs)).map(s -> String.format("ON %s ", s)).orElse("ON 1 = 1 ");
            String sql = String.format("%s\n %s \n%s %s", left.getString(), operatorString, right.getString(), onString);
            return new QuerySerializationImpl(sql, (ImmutableMap<Variable, QualifiedAttributeID>)columnIDs);
        }

        @Override
        public SelectFromWhereSerializer.QuerySerialization visit(SQLOneTupleDummyQueryExpression sqlOneTupleDummyQueryExpression) {
            String fromString = this.serializeDummyTable();
            String sqlSubString = String.format("(SELECT 1 %s) tdummy", fromString);
            return new QuerySerializationImpl(sqlSubString, (ImmutableMap<Variable, QualifiedAttributeID>)ImmutableMap.of());
        }
    }
}

