/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.serializer.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.generation.algebra.SelectFromWhereWithModifiers;
import it.unibz.inf.ontop.generation.serializer.SelectFromWhereSerializer;
import it.unibz.inf.ontop.generation.serializer.impl.DefaultSelectFromWhereSerializer;
import it.unibz.inf.ontop.generation.serializer.impl.IgnoreNullFirstSelectFromWhereSerializer;
import it.unibz.inf.ontop.model.term.TermFactory;

@Singleton
public class DB2SelectFromWhereSerializer
extends IgnoreNullFirstSelectFromWhereSerializer {
    @Inject
    private DB2SelectFromWhereSerializer(TermFactory termFactory) {
        super(new DefaultSelectFromWhereSerializer.DefaultSQLTermSerializer(termFactory));
    }

    @Override
    public SelectFromWhereSerializer.QuerySerialization serialize(SelectFromWhereWithModifiers selectFromWhere, DBParameters dbParameters) {
        return selectFromWhere.acceptVisitor(new IgnoreNullFirstSelectFromWhereSerializer.IgnoreNullFirstRelationVisitingSerializer(dbParameters.getQuotedIDFactory()){

            @Override
            protected String serializeDummyTable() {
                return "FROM sysibm.sysdummy1";
            }

            @Override
            protected String serializeLimitOffset(long limit, long offset) {
                return String.format("LIMIT %d\nOFFSET %d", limit, offset);
            }

            @Override
            protected String serializeOffset(long offset) {
                return this.serializeLimitOffset(8000L, offset);
            }
        });
    }
}

