/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.google.common.collect.ImmutableList;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.dbschema.AttributeNotFoundException;
import it.unibz.inf.ontop.dbschema.DBMetadataProvider;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.DatabaseRelationDefinition;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.dbschema.impl.BasicDBParametersImpl;
import it.unibz.inf.ontop.dbschema.impl.DatabaseTableDefinition;
import it.unibz.inf.ontop.dbschema.impl.PostgreSQLQuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.QuotedIDImpl;
import it.unibz.inf.ontop.dbschema.impl.RawQuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.SQLServerQuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.SQLStandardQuotedIDFactory;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.TypeFactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDBMetadataProvider
implements DBMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDBMetadataProvider.class);
    protected final Connection connection;
    protected final QuotedIDFactory idFactory;
    protected final DBTypeFactory dbTypeFactory;
    protected final DBParameters dbParameters;
    protected final DatabaseMetaData metadata;
    protected final QuotedIDFactory rawIdFactory;

    DefaultDBMetadataProvider(Connection connection, QuotedIDFactory idFactory, TypeFactory typeFactory) throws MetadataExtractionException {
        this.connection = connection;
        this.dbTypeFactory = typeFactory.getDBTypeFactory();
        try {
            this.metadata = connection.getMetaData();
            this.idFactory = idFactory;
            this.rawIdFactory = new RawQuotedIDFactory(idFactory);
            this.dbParameters = DefaultDBMetadataProvider.getDBParameters(this.metadata, idFactory, this.dbTypeFactory);
        }
        catch (SQLException e) {
            throw new MetadataExtractionException((Exception)e);
        }
    }

    @AssistedInject
    DefaultDBMetadataProvider(@Assisted Connection connection, TypeFactory typeFactory) throws MetadataExtractionException {
        this.connection = connection;
        this.dbTypeFactory = typeFactory.getDBTypeFactory();
        try {
            this.metadata = connection.getMetaData();
            this.idFactory = DefaultDBMetadataProvider.getQuotedIDFactory(this.metadata);
            this.rawIdFactory = new RawQuotedIDFactory(this.idFactory);
            this.dbParameters = DefaultDBMetadataProvider.getDBParameters(this.metadata, this.idFactory, this.dbTypeFactory);
        }
        catch (SQLException e) {
            throw new MetadataExtractionException((Exception)e);
        }
    }

    protected static DBParameters getDBParameters(DatabaseMetaData metadata, QuotedIDFactory idFactory, DBTypeFactory dbTypeFactory) throws SQLException {
        return new BasicDBParametersImpl(metadata.getDriverName(), metadata.getDriverVersion(), metadata.getDatabaseProductName(), metadata.getDatabaseProductVersion(), idFactory, dbTypeFactory);
    }

    protected static QuotedIDFactory getQuotedIDFactory(DatabaseMetaData md) throws SQLException {
        if (md.storesMixedCaseIdentifiers()) {
            return new SQLServerQuotedIDFactory();
        }
        if (md.storesLowerCaseIdentifiers()) {
            return new PostgreSQLQuotedIDFactory();
        }
        if (md.storesUpperCaseIdentifiers()) {
            return new SQLStandardQuotedIDFactory();
        }
        LOGGER.warn("Unknown combination of identifier handling rules: " + md.getDatabaseProductName());
        LOGGER.warn("storesLowerCaseIdentifiers: " + md.storesLowerCaseIdentifiers());
        LOGGER.warn("storesUpperCaseIdentifiers: " + md.storesUpperCaseIdentifiers());
        LOGGER.warn("storesMixedCaseIdentifiers: " + md.storesMixedCaseIdentifiers());
        LOGGER.warn("supportsMixedCaseIdentifiers: " + md.supportsMixedCaseIdentifiers());
        LOGGER.warn("storesLowerCaseQuotedIdentifiers: " + md.storesLowerCaseQuotedIdentifiers());
        LOGGER.warn("storesUpperCaseQuotedIdentifiers: " + md.storesUpperCaseQuotedIdentifiers());
        LOGGER.warn("storesMixedCaseQuotedIdentifiers: " + md.storesMixedCaseQuotedIdentifiers());
        LOGGER.warn("supportsMixedCaseQuotedIdentifiers: " + md.supportsMixedCaseQuotedIdentifiers());
        LOGGER.warn("getIdentifierQuoteString: " + md.getIdentifierQuoteString());
        return new SQLStandardQuotedIDFactory();
    }

    public QuotedIDFactory getQuotedIDFactory() {
        return this.dbParameters.getQuotedIDFactory();
    }

    public DBParameters getDBParameters() {
        return this.dbParameters;
    }

    protected boolean isSchemaIgnored(String schema) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ImmutableList<RelationID> getRelationIDs() throws MetadataExtractionException {
        try (ResultSet rs = this.metadata.getTables(null, null, null, new String[]{"TABLE", "VIEW"});){
            ImmutableList.Builder builder = ImmutableList.builder();
            while (rs.next()) {
                String schema = rs.getString("TABLE_SCHEM");
                String table = rs.getString("TABLE_NAME");
                if (this.isSchemaIgnored(schema)) continue;
                RelationID id = this.rawIdFactory.createRelationID(schema, table);
                builder.add((Object)id);
            }
            ImmutableList immutableList = builder.build();
            return immutableList;
        }
        catch (SQLException e) {
            throw new MetadataExtractionException((Exception)e);
        }
    }

    protected ImmutableList<RelationID> getRelationAllIDs(RelationID id) {
        QuotedID schemaId = id.getSchemaID();
        if (schemaId.equals(this.getDefaultSchema())) {
            return id.getWithSchemalessID();
        }
        return ImmutableList.of((Object)id);
    }

    protected QuotedID getDefaultSchema() {
        return QuotedIDImpl.EMPTY_ID;
    }

    protected QuotedID getEffectiveRelationSchema(RelationID id) {
        QuotedID schemaId = id.getSchemaID();
        if (schemaId.getName() != null) {
            return schemaId;
        }
        return this.getDefaultSchema();
    }

    /*
     * Exception decompiling
     */
    protected final QuotedID retrieveDefaultSchema(String sql) throws MetadataExtractionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void checkSameRelationID(RelationID extractedId, RelationID givenId) throws MetadataExtractionException {
        QuotedID givenSchemaId = this.getEffectiveRelationSchema(givenId);
        QuotedID extractedSchemaId = extractedId.getSchemaID();
        if (!extractedSchemaId.equals(givenSchemaId)) {
            throw new MetadataExtractionException("Relation IDs mismatch: " + givenId + " v " + extractedId + "(" + givenSchemaId + " v " + extractedSchemaId + ")");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DatabaseRelationDefinition getRelation(RelationID id) throws MetadataExtractionException {
        try (ResultSet rs = this.metadata.getColumns(this.getRelationCatalog(id), this.getRelationSchema(id), this.getRelationName(id), null);){
            HashMap<RelationID, RelationDefinition.AttributeListBuilder> relations = new HashMap<RelationID, RelationDefinition.AttributeListBuilder>();
            while (rs.next()) {
                RelationID extractedId = this.getRelationID(rs);
                this.checkSameRelationID(extractedId, id);
                RelationDefinition.AttributeListBuilder builder = relations.computeIfAbsent(extractedId, i -> DatabaseTableDefinition.attributeListBuilder());
                QuotedID attributeId = this.rawIdFactory.createAttributeID(rs.getString("COLUMN_NAME"));
                boolean isNullable = rs.getInt("NULLABLE") != 0;
                String typeName = rs.getString("TYPE_NAME");
                int columnSize = rs.getInt("COLUMN_SIZE");
                DBTermType termType = this.dbTypeFactory.getDBTermType(typeName, columnSize);
                builder.addAttribute(attributeId, termType, typeName, isNullable);
            }
            if (relations.isEmpty()) {
                throw new MetadataExtractionException("Cannot find relation id: " + id);
            }
            if (relations.entrySet().size() == 1) {
                Map.Entry r = relations.entrySet().iterator().next();
                DatabaseTableDefinition databaseTableDefinition = new DatabaseTableDefinition(this.getRelationAllIDs((RelationID)r.getKey()), (RelationDefinition.AttributeListBuilder)r.getValue());
                return databaseTableDefinition;
            }
            throw new MetadataExtractionException("Cannot resolve ambiguous relation id: " + id + ": " + relations.keySet());
        }
        catch (SQLException e) {
            throw new MetadataExtractionException((Exception)e);
        }
    }

    public void insertIntegrityConstraints(DatabaseRelationDefinition relation, MetadataLookup metadataLookup) throws MetadataExtractionException {
        this.insertPrimaryKey(relation);
        this.insertUniqueAttributes(relation);
        this.insertForeignKeys(relation, metadataLookup);
    }

    private void insertPrimaryKey(DatabaseRelationDefinition relation) throws MetadataExtractionException {
        block18: {
            RelationID id = relation.getID();
            try (ResultSet rs = this.metadata.getPrimaryKeys(this.getRelationCatalog(id), this.getRelationSchema(id), this.getRelationName(id));){
                HashMap<Integer, QuotedID> primaryKeyAttributes = new HashMap<Integer, QuotedID>();
                String currentName = null;
                while (rs.next()) {
                    RelationID extractedId = this.getRelationID(rs);
                    this.checkSameRelationID(extractedId, id);
                    currentName = rs.getString("PK_NAME");
                    QuotedID attrId = this.rawIdFactory.createAttributeID(rs.getString("COLUMN_NAME"));
                    short seq = rs.getShort("KEY_SEQ");
                    primaryKeyAttributes.put(Integer.valueOf(seq), attrId);
                }
                if (primaryKeyAttributes.isEmpty()) break block18;
                try {
                    FunctionalDependency.Builder builder = UniqueConstraint.primaryKeyBuilder((DatabaseRelationDefinition)relation, currentName);
                    for (int i = 1; i <= primaryKeyAttributes.size(); ++i) {
                        builder.addDeterminant((QuotedID)primaryKeyAttributes.get(i));
                    }
                    builder.build();
                }
                catch (AttributeNotFoundException e) {
                    throw new MetadataExtractionException((Exception)((Object)e));
                }
            }
            catch (SQLException e) {
                throw new MetadataExtractionException((Exception)e);
            }
        }
    }

    private void insertUniqueAttributes(DatabaseRelationDefinition relation) throws MetadataExtractionException {
        RelationID id = relation.getID();
        try (ResultSet rs = this.metadata.getIndexInfo(this.getRelationCatalog(id), this.getRelationSchema(id), this.getRelationName(id), true, true);){
            FunctionalDependency.Builder builder = null;
            while (rs.next()) {
                RelationID extractedId = this.getRelationID(rs);
                this.checkSameRelationID(extractedId, id);
                if (rs.getShort("TYPE") == 0) {
                    if (builder != null) {
                        builder.build();
                    }
                    builder = null;
                    continue;
                }
                if (rs.getShort("ORDINAL_POSITION") == 1) {
                    if (builder != null) {
                        builder.build();
                    }
                    if (!rs.getBoolean("NON_UNIQUE")) {
                        String name = rs.getString("INDEX_NAME");
                        builder = UniqueConstraint.builder((DatabaseRelationDefinition)relation, (String)name);
                    } else {
                        builder = null;
                    }
                }
                if (builder == null) continue;
                QuotedID attrId = this.rawIdFactory.createAttributeID(rs.getString("COLUMN_NAME"));
                try {
                    builder.addDeterminant(attrId);
                }
                catch (AttributeNotFoundException e) {
                    try {
                        attrId = this.rawIdFactory.createAttributeID("\"" + rs.getString("COLUMN_NAME") + "\"");
                        builder.addDeterminant(attrId);
                    }
                    catch (AttributeNotFoundException ex) {
                        throw new MetadataExtractionException((Exception)((Object)e));
                    }
                }
            }
            if (builder != null) {
                builder.build();
            }
        }
        catch (SQLException e) {
            throw new MetadataExtractionException((Exception)e);
        }
    }

    private void insertForeignKeys(DatabaseRelationDefinition relation, MetadataLookup dbMetadata) throws MetadataExtractionException {
        RelationID id = relation.getID();
        try (ResultSet rs = this.metadata.getImportedKeys(this.getRelationCatalog(id), this.getRelationSchema(id), this.getRelationName(id));){
            ForeignKeyConstraint.Builder builder = null;
            while (rs.next()) {
                RelationID extractedId = this.getFKRelationID(rs);
                this.checkSameRelationID(extractedId, id);
                try {
                    short seq = rs.getShort("KEY_SEQ");
                    if (seq == 1) {
                        if (builder != null) {
                            builder.build();
                        }
                        String name = rs.getString("FK_NAME");
                        DatabaseRelationDefinition ref = dbMetadata.getRelation(this.getPKRelationID(rs));
                        builder = ForeignKeyConstraint.builder((String)name, (DatabaseRelationDefinition)relation, (DatabaseRelationDefinition)ref);
                    }
                    if (builder == null) continue;
                    try {
                        QuotedID attrId = this.rawIdFactory.createAttributeID(rs.getString("FKCOLUMN_NAME"));
                        QuotedID refAttrId = this.rawIdFactory.createAttributeID(rs.getString("PKCOLUMN_NAME"));
                        builder.add(attrId, refAttrId);
                    }
                    catch (AttributeNotFoundException e) {
                        throw new MetadataExtractionException((Exception)((Object)e));
                    }
                }
                catch (MetadataExtractionException e) {
                    LOGGER.warn("Cannot find table {} for FK {}", (Object)this.getPKRelationID(rs), (Object)rs.getString("FK_NAME"));
                    builder = null;
                }
            }
            if (builder != null) {
                builder.build();
            }
        }
        catch (SQLException e) {
            throw new MetadataExtractionException((Exception)e);
        }
    }

    protected String getRelationCatalog(RelationID relationID) {
        return null;
    }

    protected String getRelationSchema(RelationID relationID) {
        return this.getEffectiveRelationSchema(relationID).getName();
    }

    protected String getRelationName(RelationID relationID) {
        return relationID.getTableID().getName();
    }

    protected RelationID getRelationID(ResultSet rs) throws SQLException {
        return this.getRelationID(rs, "TABLE_SCHEM", "TABLE_NAME");
    }

    protected RelationID getPKRelationID(ResultSet rs) throws SQLException {
        return this.getRelationID(rs, "PKTABLE_SCHEM", "PKTABLE_NAME");
    }

    protected RelationID getFKRelationID(ResultSet rs) throws SQLException {
        return this.getRelationID(rs, "FKTABLE_SCHEM", "FKTABLE_NAME");
    }

    protected final RelationID getRelationID(ResultSet rs, String schemaNameColumn, String tableNameColumn) throws SQLException {
        return this.rawIdFactory.createRelationID(rs.getString(schemaNameColumn), rs.getString(tableNameColumn));
    }
}

