/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.google.common.collect.ImmutableSet;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.impl.DefaultDBMetadataProvider;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.model.type.TypeFactory;
import java.sql.Connection;

public class DB2DBMetadataProvider
extends DefaultDBMetadataProvider {
    private final ImmutableSet<String> ignoredSchemas = ImmutableSet.of((Object)"SYSTOOLS", (Object)"SYSCAT", (Object)"SYSIBM", (Object)"SYSIBMADM", (Object)"SYSSTAT");
    private final QuotedID defaultSchema = this.retrieveDefaultSchema("select CURRENT SCHEMA  from  SYSIBM.SYSDUMMY1");

    @AssistedInject
    DB2DBMetadataProvider(@Assisted Connection connection, TypeFactory typeFactory) throws MetadataExtractionException {
        super(connection, typeFactory);
    }

    @Override
    public QuotedID getDefaultSchema() {
        return this.defaultSchema;
    }

    @Override
    protected boolean isSchemaIgnored(String schema) {
        return this.ignoredSchemas.contains((Object)schema);
    }
}

