/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import it.unibz.inf.ontop.exception.InvalidOntopConfigurationException;
import it.unibz.inf.ontop.injection.OntopSQLCoreSettings;
import it.unibz.inf.ontop.injection.impl.OntopOBDASettingsImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.utils.IDGenerator;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public class OntopSQLCoreSettingsImpl
extends OntopOBDASettingsImpl
implements OntopSQLCoreSettings {
    private static final String DB_PREFIX = "DB-";
    private static final String DB_TYPE_FACTORY_SUFFIX = "-typeFactory";
    private static final String DB_FS_FACTORY_SUFFIX = "-symbolFactory";
    private static final String DEFAULT_FILE = "sql-default.properties";
    private final String jdbcUrl = this.getRequiredProperty("jdbc.url");
    private final String jdbcDriver = this.getRequiredProperty("jdbc.driver");
    private final String jdbcName = this.getProperty("jdbc.name").orElseGet(() -> IDGenerator.getNextUniqueID((String)DB_PREFIX));

    protected OntopSQLCoreSettingsImpl(Properties userProperties) {
        super(OntopSQLCoreSettingsImpl.loadSQLCoreProperties(userProperties));
    }

    static Properties loadSQLCoreProperties(Properties userProperties) {
        String jdbcUrl = Optional.ofNullable(userProperties.getProperty("jdbc.url")).orElseThrow(() -> new InvalidOntopConfigurationException("jdbc.url is required"));
        String jdbcDriver = Optional.ofNullable(userProperties.getProperty("jdbc.driver")).orElseGet(() -> {
            try {
                return DriverManager.getDriver(jdbcUrl).getClass().getCanonicalName();
            }
            catch (SQLException e) {
                throw new InvalidOntopConfigurationException("Impossible to get the JDBC driver. Reason: " + e.getMessage());
            }
        });
        Properties properties = OntopSQLCoreSettingsImpl.loadDefaultPropertiesFromFile(OntopSQLCoreSettings.class, (String)DEFAULT_FILE);
        properties.setProperty("jdbc.driver", jdbcDriver);
        properties.putAll((Map<?, ?>)userProperties);
        String typeFactoryKey = jdbcDriver + DB_TYPE_FACTORY_SUFFIX;
        String dbTypeFactoryName = DBTypeFactory.class.getCanonicalName();
        Optional.ofNullable(properties.getProperty(typeFactoryKey)).filter(v -> !userProperties.containsKey(dbTypeFactoryName)).ifPresent(v -> properties.setProperty(dbTypeFactoryName, (String)v));
        String dbFSFactoryKey = jdbcDriver + DB_FS_FACTORY_SUFFIX;
        String dbFSFactoryName = DBFunctionSymbolFactory.class.getCanonicalName();
        Optional.ofNullable(properties.getProperty(dbFSFactoryKey)).filter(v -> !userProperties.containsKey(dbFSFactoryName)).ifPresent(v -> properties.setProperty(dbFSFactoryName, (String)v));
        return properties;
    }

    @Override
    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    @Override
    public String getJdbcName() {
        return this.jdbcName;
    }

    @Override
    public String getJdbcDriver() {
        return this.jdbcDriver;
    }
}

