/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema;

import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.DBMetadata;
import it.unibz.inf.ontop.dbschema.DatabaseRelationDefinition;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.QuotedIDFactoryIdentity;
import it.unibz.inf.ontop.dbschema.QuotedIDFactoryLowerCase;
import it.unibz.inf.ontop.dbschema.QuotedIDFactoryMySQL;
import it.unibz.inf.ontop.dbschema.QuotedIDFactoryStandardSQL;
import it.unibz.inf.ontop.dbschema.RDBMetadata;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TypeFactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBMetadataExtractionTools {
    private static final boolean printouts = false;
    private static Logger log = LoggerFactory.getLogger(RDBMetadataExtractionTools.class);
    private static final DatatypeNormalizer DefaultTypeFixer = new DatatypeNormalizer(){

        @Override
        public int getCorrectedDatatype(int dataType, String typeName) {
            return dataType;
        }
    };
    private static final DatatypeNormalizer MySQLTypeFixer = new DatatypeNormalizer(){

        @Override
        public int getCorrectedDatatype(int dataType, String typeName) {
            if (dataType == 91 && typeName.equals("YEAR")) {
                return -10000;
            }
            return dataType;
        }
    };
    private static final DatatypeNormalizer OracleTypeFixer = new DatatypeNormalizer(){

        @Override
        public int getCorrectedDatatype(int dataType, String typeName) {
            if (dataType == 93 && typeName.equals("DATE")) {
                return 91;
            }
            if (typeName.equals("TIMESTAMP(6) WITH TIME ZONE")) {
                return 2014;
            }
            return dataType;
        }
    };
    private static final DatatypeNormalizer SQLServerTypeFixer = (dataType, typeName) -> {
        if (typeName.equals("datetimeoffset")) {
            return 93;
        }
        return dataType;
    };

    public static RDBMetadata createMetadata(Connection conn, TypeFactory typeFactory) throws SQLException {
        QuotedIDFactoryMySQL idfac;
        DatabaseMetaData md = conn.getMetaData();
        String productName = md.getDatabaseProductName();
        if (productName.contains("MySQL")) {
            idfac = new QuotedIDFactoryMySQL(md.storesMixedCaseIdentifiers(), "`");
        } else if (md.storesMixedCaseIdentifiers()) {
            idfac = new QuotedIDFactoryIdentity("\"");
        } else if (md.storesLowerCaseIdentifiers()) {
            idfac = new QuotedIDFactoryLowerCase("\"");
        } else if (md.storesUpperCaseIdentifiers()) {
            idfac = new QuotedIDFactoryStandardSQL("\"");
        } else {
            log.warn("Unknown combination of identifier handling rules: " + md.getDatabaseProductName());
            log.warn("storesLowerCaseIdentifiers: " + md.storesLowerCaseIdentifiers());
            log.warn("storesUpperCaseIdentifiers: " + md.storesUpperCaseIdentifiers());
            log.warn("storesMixedCaseIdentifiers: " + md.storesMixedCaseIdentifiers());
            log.warn("supportsMixedCaseIdentifiers: " + md.supportsMixedCaseIdentifiers());
            log.warn("storesLowerCaseQuotedIdentifiers: " + md.storesLowerCaseQuotedIdentifiers());
            log.warn("storesUpperCaseQuotedIdentifiers: " + md.storesUpperCaseQuotedIdentifiers());
            log.warn("storesMixedCaseQuotedIdentifiers: " + md.storesMixedCaseQuotedIdentifiers());
            log.warn("supportsMixedCaseQuotedIdentifiers: " + md.supportsMixedCaseQuotedIdentifiers());
            log.warn("getIdentifierQuoteString: " + md.getIdentifierQuoteString());
            idfac = new QuotedIDFactoryStandardSQL("\"");
        }
        RDBMetadata metadata = new RDBMetadata(md.getDriverName(), md.getDriverVersion(), productName, md.getDatabaseProductVersion(), idfac, typeFactory);
        return metadata;
    }

    public static void loadMetadata(RDBMetadata metadata, Connection conn, Set<RelationID> realTables) throws SQLException {
        List<RelationID> seedRelationIds;
        DatabaseMetaData md = conn.getMetaData();
        String productName = md.getDatabaseProductName();
        QuotedIDFactory idfac = metadata.getQuotedIDFactory();
        if (productName.contains("Oracle")) {
            String defaultSchema = RDBMetadataExtractionTools.getOracleDefaultOwner(conn);
            seedRelationIds = realTables == null || realTables.isEmpty() ? RDBMetadataExtractionTools.getTableList(conn, new OracleRelationListProvider(idfac, defaultSchema), idfac) : RDBMetadataExtractionTools.getTableList(defaultSchema, realTables, idfac);
        } else {
            seedRelationIds = realTables == null || realTables.isEmpty() ? (productName.contains("DB2") ? RDBMetadataExtractionTools.getTableListDefault(md, (ImmutableSet<String>)ImmutableSet.of((Object)"SYSTOOLS", (Object)"SYSCAT", (Object)"SYSIBM", (Object)"SYSIBMADM", (Object)"SYSSTAT"), idfac) : (productName.contains("SQL Server") ? RDBMetadataExtractionTools.getTableListDefault(md, (ImmutableSet<String>)ImmutableSet.of((Object)"sys", (Object)"INFORMATION_SCHEMA"), idfac) : RDBMetadataExtractionTools.getTableListDefault(md, (ImmutableSet<String>)ImmutableSet.of(), idfac))) : RDBMetadataExtractionTools.getTableList(null, realTables, idfac);
        }
        DatatypeNormalizer dt = DefaultTypeFixer;
        if (productName.contains("Oracle")) {
            dt = OracleTypeFixer;
        } else if (productName.contains("MySQL")) {
            dt = MySQLTypeFixer;
        } else if (productName.contains("Microsoft SQL Server")) {
            dt = SQLServerTypeFixer;
        }
        LinkedList<DatabaseRelationDefinition> extractedRelations = new LinkedList<DatabaseRelationDefinition>();
        String catalog = RDBMetadataExtractionTools.getCatalog(metadata, conn);
        for (RelationID seedId : seedRelationIds) {
            DatabaseRelationDefinition currentRelation = null;
            ResultSet rs = md.getColumns(catalog, seedId.getSchemaName(), seedId.getTableName(), null);
            Throwable throwable = null;
            try {
                while (rs.next()) {
                    String schema = rs.getString("TABLE_SCHEM");
                    if (schema == null) {
                        schema = rs.getString("TABLE_CAT");
                    }
                    RelationID relationId = RelationID.createRelationIdFromDatabaseRecord((QuotedIDFactory)idfac, (String)schema, (String)rs.getString("TABLE_NAME"));
                    QuotedID attributeId = QuotedID.createIdFromDatabaseRecord((QuotedIDFactory)idfac, (String)rs.getString("COLUMN_NAME"));
                    if (currentRelation == null || !currentRelation.getID().equals((Object)relationId)) {
                        currentRelation = metadata.createDatabaseRelation(relationId);
                        extractedRelations.add(currentRelation);
                    }
                    boolean isNullable = rs.getInt("NULLABLE") != 0;
                    String typeName = rs.getString("TYPE_NAME");
                    int columnSize = rs.getInt("COLUMN_SIZE");
                    DBTermType termType = metadata.getDBTypeFactory().getDBTermType(typeName, columnSize);
                    currentRelation.addAttribute(attributeId, typeName, termType, isNullable);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rs == null) continue;
                if (throwable != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                rs.close();
            }
        }
        for (DatabaseRelationDefinition relation : extractedRelations) {
            RDBMetadataExtractionTools.getPrimaryKey(md, relation, metadata.getQuotedIDFactory());
            RDBMetadataExtractionTools.getUniqueAttributes(md, relation, metadata.getQuotedIDFactory());
            RDBMetadataExtractionTools.getForeignKeys(md, relation, (DBMetadata)metadata);
        }
    }

    private static String getCatalog(RDBMetadata metadata, Connection conn) throws SQLException {
        String catalog = null;
        Statement statement = conn.createStatement();
        if (metadata.getDbmsProductName().contains("MySQL")) {
            try (ResultSet rs = statement.executeQuery("SELECT DATABASE()");){
                if (rs.next()) {
                    catalog = rs.getString(1);
                }
            }
        }
        return catalog;
    }

    private static List<RelationID> getTableList(String defaultTableSchema, Set<RelationID> realTables, QuotedIDFactory idfac) throws SQLException {
        LinkedList<RelationID> fks = new LinkedList<RelationID>();
        for (RelationID table : realTables) {
            if (table.hasSchema() || defaultTableSchema == null || table.getTableName().equals("DUAL")) {
                fks.add(table);
                continue;
            }
            RelationID qualifiedTableId = idfac.createRelationID(defaultTableSchema, table.getTableNameSQLRendering());
            fks.add(qualifiedTableId);
        }
        return fks;
    }

    private static List<RelationID> getTableListDefault(DatabaseMetaData md, ImmutableSet<String> ignoredSchemas, QuotedIDFactory idfac) throws SQLException {
        LinkedList<RelationID> relationIds = new LinkedList<RelationID>();
        try (ResultSet rs = md.getTables(null, null, null, new String[]{"TABLE", "VIEW"});){
            while (rs.next()) {
                String schema = rs.getString("TABLE_SCHEM");
                String table = rs.getString("TABLE_NAME");
                if (ignoredSchemas.contains((Object)schema)) continue;
                RelationID id = RelationID.createRelationIdFromDatabaseRecord((QuotedIDFactory)idfac, (String)schema, (String)table);
                relationIds.add(id);
            }
        }
        return relationIds;
    }

    private static List<RelationID> getTableList(Connection conn, RelationListProvider relationListProvider, QuotedIDFactory idfac) throws SQLException {
        LinkedList<RelationID> relationIds = new LinkedList<RelationID>();
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(relationListProvider.getQuery());){
            while (rs.next()) {
                relationIds.add(relationListProvider.getTableID(rs));
            }
        }
        return relationIds;
    }

    private static String getOracleDefaultOwner(Connection conn) throws SQLException {
        String loggedUser = "SYSTEM";
        try (Statement stmt = conn.createStatement();
             ResultSet resultSet = stmt.executeQuery("SELECT user FROM dual");){
            if (resultSet.next()) {
                loggedUser = resultSet.getString("user");
            }
        }
        return loggedUser.toUpperCase();
    }

    private static void getPrimaryKey(DatabaseMetaData md, DatabaseRelationDefinition relation, QuotedIDFactory idfac) throws SQLException {
        RelationID id = relation.getID();
        try (ResultSet rs = md.getPrimaryKeys(null, id.getSchemaName(), id.getTableName());){
            RDBMetadataExtractionTools.extractPrimaryKey(relation, idfac, id, rs);
        }
        catch (SQLSyntaxErrorException e) {
            try (ResultSet rs2 = md.getPrimaryKeys(id.getSchemaName(), null, id.getTableName());){
                RDBMetadataExtractionTools.extractPrimaryKey(relation, idfac, id, rs2);
            }
        }
    }

    private static void extractPrimaryKey(DatabaseRelationDefinition relation, QuotedIDFactory idfac, RelationID id, ResultSet rs) throws SQLException {
        HashMap<Integer, String> primaryKeyAttributes = new HashMap<Integer, String>();
        String currentName = null;
        while (rs.next()) {
            RelationID id2 = RelationID.createRelationIdFromDatabaseRecord((QuotedIDFactory)idfac, (String)rs.getString("TABLE_SCHEM"), (String)rs.getString("TABLE_NAME"));
            if (!id2.equals((Object)id)) continue;
            currentName = rs.getString("PK_NAME");
            String attr = rs.getString("COLUMN_NAME");
            short seq = rs.getShort("KEY_SEQ");
            primaryKeyAttributes.put(Integer.valueOf(seq), attr);
        }
        if (!primaryKeyAttributes.isEmpty()) {
            UniqueConstraint.Builder builder = UniqueConstraint.builder((DatabaseRelationDefinition)relation);
            for (int i = 1; i <= primaryKeyAttributes.size(); ++i) {
                QuotedID attrId = QuotedID.createIdFromDatabaseRecord((QuotedIDFactory)idfac, (String)((String)primaryKeyAttributes.get(i)));
                builder.add(relation.getAttribute(attrId));
            }
            relation.addUniqueConstraint(builder.build(currentName, true));
        }
    }

    private static void getUniqueAttributes(DatabaseMetaData md, DatabaseRelationDefinition relation, QuotedIDFactory idfac) throws SQLException {
        RelationID id = relation.getID();
        try (ResultSet rs = md.getIndexInfo(null, id.getSchemaName(), id.getTableName(), true, true);){
            RDBMetadataExtractionTools.extractUniqueAttributes(relation, idfac, rs);
        }
        catch (Exception e) {
            try (ResultSet rs2 = md.getIndexInfo(id.getSchemaName(), null, id.getTableName(), true, true);){
                RDBMetadataExtractionTools.extractUniqueAttributes(relation, idfac, rs2);
            }
        }
    }

    private static void extractUniqueAttributes(DatabaseRelationDefinition relation, QuotedIDFactory idfac, ResultSet rs) throws SQLException {
        UniqueConstraint.Builder builder = null;
        String currentName = null;
        while (rs.next()) {
            if (rs.getShort("TYPE") == 0) {
                if (builder != null) {
                    relation.addUniqueConstraint(builder.build(currentName, false));
                }
                builder = null;
                continue;
            }
            if (rs.getShort("ORDINAL_POSITION") == 1) {
                if (builder != null) {
                    relation.addUniqueConstraint(builder.build(currentName, false));
                }
                if (!rs.getBoolean("NON_UNIQUE")) {
                    builder = UniqueConstraint.builder((DatabaseRelationDefinition)relation);
                    currentName = rs.getString("INDEX_NAME");
                } else {
                    builder = null;
                }
            }
            if (builder == null) continue;
            QuotedID attrId = QuotedID.createIdFromDatabaseRecord((QuotedIDFactory)idfac, (String)rs.getString("COLUMN_NAME"));
            Attribute attr = relation.getAttribute(attrId);
            if (attr == null) {
                attrId = QuotedID.createIdFromDatabaseRecord((QuotedIDFactory)idfac, (String)("\"" + rs.getString("COLUMN_NAME") + "\""));
                attr = relation.getAttribute(attrId);
            }
            builder.add(attr);
        }
        if (builder != null) {
            relation.addUniqueConstraint(builder.build(currentName, false));
        }
    }

    private static void getForeignKeys(DatabaseMetaData md, DatabaseRelationDefinition relation, DBMetadata metadata) throws SQLException {
        QuotedIDFactory idfac = metadata.getQuotedIDFactory();
        RelationID relationId = relation.getID();
        try (ResultSet rs = md.getImportedKeys(null, relationId.getSchemaName(), relationId.getTableName());){
            RDBMetadataExtractionTools.extractForeignKeys(relation, metadata, idfac, rs);
        }
        catch (Exception ex) {
            try (ResultSet rs2 = md.getImportedKeys(relationId.getSchemaName(), null, relationId.getTableName());){
                RDBMetadataExtractionTools.extractForeignKeys(relation, metadata, idfac, rs2);
            }
        }
    }

    private static void extractForeignKeys(DatabaseRelationDefinition relation, DBMetadata metadata, QuotedIDFactory idfac, ResultSet rs) throws SQLException {
        ForeignKeyConstraint.Builder builder = null;
        String currentName = null;
        while (rs.next()) {
            String schemaName = rs.getString("PKTABLE_SCHEM");
            if (schemaName == null) {
                schemaName = rs.getString("PKTABLE_CAT");
            }
            RelationID refId = RelationID.createRelationIdFromDatabaseRecord((QuotedIDFactory)idfac, (String)schemaName, (String)rs.getString("PKTABLE_NAME"));
            DatabaseRelationDefinition ref = metadata.getDatabaseRelation(refId);
            short seq = rs.getShort("KEY_SEQ");
            if (seq == 1) {
                if (builder != null) {
                    relation.addForeignKeyConstraint(builder.build(currentName));
                }
                currentName = rs.getString("FK_NAME");
                if (ref != null) {
                    builder = new ForeignKeyConstraint.Builder(relation, ref);
                } else {
                    builder = null;
                    log.warn("Cannot find table: " + refId + " for FK " + currentName);
                }
            }
            if (builder == null) continue;
            QuotedID attrId = QuotedID.createIdFromDatabaseRecord((QuotedIDFactory)idfac, (String)rs.getString("FKCOLUMN_NAME"));
            QuotedID refAttrId = QuotedID.createIdFromDatabaseRecord((QuotedIDFactory)idfac, (String)rs.getString("PKCOLUMN_NAME"));
            builder.add(relation.getAttribute(attrId), ref.getAttribute(refAttrId));
        }
        if (builder != null) {
            relation.addForeignKeyConstraint(builder.build(currentName));
        }
    }

    private static interface DatatypeNormalizer {
        public int getCorrectedDatatype(int var1, String var2);
    }

    private static final class OracleRelationListProvider
    implements RelationListProvider {
        private final String defaultTableOwner;
        private final QuotedIDFactory idfac;

        public OracleRelationListProvider(QuotedIDFactory idfac, String defaultTableOwner) {
            this.defaultTableOwner = defaultTableOwner;
            this.idfac = idfac;
        }

        @Override
        public String getQuery() {
            return "SELECT table_name as object_name FROM user_tables WHERE    NOT table_name LIKE 'MVIEW$_%' AND    NOT table_name LIKE 'LOGMNR_%' AND    NOT table_name LIKE 'AQ$_%' AND    NOT table_name LIKE 'DEF$_%' AND    NOT table_name LIKE 'REPCAT$_%' AND    NOT table_name LIKE 'LOGSTDBY$%' AND    NOT table_name LIKE 'OL$%' UNION ALL SELECT view_name as object_name FROM user_views WHERE    NOT view_name LIKE 'MVIEW_%' AND    NOT view_name LIKE 'LOGMNR_%' AND    NOT view_name LIKE 'AQ$_%'";
        }

        @Override
        public RelationID getTableID(ResultSet rs) throws SQLException {
            return RelationID.createRelationIdFromDatabaseRecord((QuotedIDFactory)this.idfac, (String)this.defaultTableOwner, (String)rs.getString("object_name"));
        }
    }

    private static interface RelationListProvider {
        public String getQuery();

        public RelationID getTableID(ResultSet var1) throws SQLException;
    }
}

