/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.BasicDBMetadata;
import it.unibz.inf.ontop.dbschema.DatabaseRelationDefinition;
import it.unibz.inf.ontop.dbschema.ParserViewDefinition;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.TypeFactory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RDBMetadata
extends BasicDBMetadata {
    private int parserViewCounter;
    private final TypeFactory typeFactory;

    RDBMetadata(String driverName, String driverVersion, String databaseProductName, String databaseVersion, QuotedIDFactory idfac, TypeFactory typeFactory) {
        super(driverName, driverVersion, databaseProductName, databaseVersion, idfac);
        this.typeFactory = typeFactory;
    }

    private RDBMetadata(String driverName, String driverVersion, String databaseProductName, String databaseVersion, QuotedIDFactory idfac, Map<RelationID, DatabaseRelationDefinition> tables, Map<RelationID, RelationDefinition> relations, List<DatabaseRelationDefinition> listOfTables, int parserViewCounter, TypeFactory typeFactory) {
        super(driverName, driverVersion, databaseProductName, databaseVersion, tables, relations, listOfTables, idfac);
        this.parserViewCounter = parserViewCounter;
        this.typeFactory = typeFactory;
    }

    public ParserViewDefinition createParserView(String sql, ImmutableList<QuotedID> attributes) {
        if (!this.isStillMutable()) {
            throw new IllegalStateException("Too late! Parser views must be created before freezing the DBMetadata");
        }
        RelationID id = this.getQuotedIDFactory().createRelationID(null, String.format("view_%s", this.parserViewCounter++));
        ParserViewDefinition view = new ParserViewDefinition(id, attributes, sql, this.typeFactory.getDBTypeFactory());
        this.add(view, this.relations);
        return view;
    }

    @Deprecated
    public RDBMetadata clone() {
        return new RDBMetadata(this.getDriverName(), this.getDriverVersion(), this.getDbmsProductName(), this.getDbmsVersion(), this.getQuotedIDFactory(), new HashMap<RelationID, DatabaseRelationDefinition>(this.getTables()), new HashMap<RelationID, RelationDefinition>(this.relations), new LinkedList<DatabaseRelationDefinition>(this.getDatabaseRelations()), this.parserViewCounter, this.typeFactory);
    }

    public DBTypeFactory getDBTypeFactory() {
        return this.typeFactory.getDBTypeFactory();
    }
}

