/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema;

import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationID;

public class QuotedIDFactoryMySQL
implements QuotedIDFactory {
    private final String quotationString;
    private final boolean caseSensitiveTableNames;

    QuotedIDFactoryMySQL(boolean caseSensitiveTableNames, String quotationString) {
        this.quotationString = quotationString;
        this.caseSensitiveTableNames = caseSensitiveTableNames;
    }

    public QuotedID createAttributeID(String s) {
        if (s == null) {
            return new QuotedID(s, "");
        }
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return new QuotedID(s.substring(1, s.length() - 1), this.quotationString, false);
        }
        if (s.startsWith("`") && s.endsWith("`")) {
            return new QuotedID(s.substring(1, s.length() - 1), this.quotationString, false);
        }
        if (s.startsWith("[") && s.endsWith("]")) {
            return new QuotedID(s.substring(1, s.length() - 1), this.quotationString, false);
        }
        if (s.startsWith("'") && s.endsWith("'")) {
            return new QuotedID(s.substring(1, s.length() - 1), this.quotationString, false);
        }
        return new QuotedID(s, "", false);
    }

    public RelationID createRelationID(String schema, String table) {
        return new RelationID(this.createFromString(schema), this.createFromString(table));
    }

    public QuotedID createFromString(String s) {
        if (s == null) {
            return new QuotedID(s, "");
        }
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return new QuotedID(s.substring(1, s.length() - 1), this.quotationString, this.caseSensitiveTableNames);
        }
        if (s.startsWith("`") && s.endsWith("`")) {
            return new QuotedID(s.substring(1, s.length() - 1), this.quotationString, this.caseSensitiveTableNames);
        }
        if (s.startsWith("[") && s.endsWith("]")) {
            return new QuotedID(s.substring(1, s.length() - 1), this.quotationString, this.caseSensitiveTableNames);
        }
        if (s.startsWith("'") && s.endsWith("'")) {
            return new QuotedID(s.substring(1, s.length() - 1), this.quotationString, this.caseSensitiveTableNames);
        }
        return new QuotedID(s, "", this.caseSensitiveTableNames);
    }

    public String getIDQuotationString() {
        return this.quotationString;
    }
}

