/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import java.util.List;

public class ParserViewDefinition
extends RelationDefinition {
    private final ImmutableList<Attribute> attributes;
    private final ImmutableMap<QuotedID, Attribute> attributeMap;
    private final String statement;

    public ParserViewDefinition(RelationID name, ImmutableList<QuotedID> attrs, String statement, DBTypeFactory dbTypeFactory) {
        super(name);
        this.statement = statement;
        ImmutableList.Builder attributeBuilder = ImmutableList.builder();
        ImmutableMap.Builder attributeMapBuilder = ImmutableMap.builder();
        int c = 1;
        for (QuotedID id : attrs) {
            Attribute att = new Attribute((RelationDefinition)this, new QualifiedAttributeID(name, id), c, null, true, dbTypeFactory);
            ++c;
            attributeMapBuilder.put((Object)id, (Object)att);
            attributeBuilder.add((Object)att);
        }
        this.attributes = attributeBuilder.build();
        this.attributeMap = attributeMapBuilder.build();
    }

    public String getStatement() {
        return this.statement;
    }

    public Attribute getAttribute(int index) {
        return (Attribute)this.attributes.get(index - 1);
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public ImmutableList<UniqueConstraint> getUniqueConstraints() {
        return ImmutableList.of();
    }

    public ImmutableList<FunctionalDependency> getOtherFunctionalDependencies() {
        return ImmutableList.of();
    }

    public UniqueConstraint getPrimaryKey() {
        return null;
    }

    public ImmutableList<ForeignKeyConstraint> getForeignKeys() {
        return ImmutableList.of();
    }

    public String toString() {
        StringBuilder bf = new StringBuilder();
        bf.append(this.getID()).append(" [");
        Joiner.on((String)", ").appendTo(bf, this.attributes);
        bf.append("]").append(" (").append(this.statement).append(")");
        return bf.toString();
    }
}

