/*
 * Decompiled with CFR 0.152.
 */
package org.protege.osgi.jdbc.preferences;

import it.unibz.inf.ontop.protege.jdbc.JdbcDriverInfo;
import it.unibz.inf.ontop.protege.jdbc.JdbcDriverTableModel;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.protege.osgi.jdbc.JdbcRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcPreferencesPanelBundleActivator
implements BundleActivator {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcPreferencesPanelBundleActivator.class);
    private static BundleContext context;

    public void start(BundleContext context) throws Exception {
        JdbcPreferencesPanelBundleActivator.context = context;
        ServiceReference sr = context.getServiceReference(JdbcRegistry.class);
        if (sr != null) {
            JdbcPreferencesPanelBundleActivator.installDrivers((ServiceReference<JdbcRegistry>)sr);
        } else {
            context.addServiceListener(evt -> {
                if (evt.getType() == 1) {
                    ServiceReference sr1 = evt.getServiceReference();
                    JdbcPreferencesPanelBundleActivator.installDrivers((ServiceReference<JdbcRegistry>)sr1);
                }
            }, "(objectclass=" + JdbcRegistry.class.getName() + ")");
        }
    }

    public void stop(BundleContext context) {
        JdbcPreferencesPanelBundleActivator.context = null;
    }

    public static BundleContext getContext() {
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installDrivers(ServiceReference<JdbcRegistry> sr) {
        if (sr != null) {
            JdbcRegistry registry = (JdbcRegistry)context.getService(sr);
            try {
                for (JdbcDriverInfo driver : JdbcDriverTableModel.getDriverInfoFromPreferences()) {
                    try {
                        registry.addJdbcDriver(driver.getClassName(), driver.getDriverURL());
                    }
                    catch (Exception e) {
                        LOGGER.warn("Exception caught installing JDBC driver: ", (Throwable)e);
                    }
                }
            }
            finally {
                context.ungetService(sr);
            }
        }
    }
}

