/*
 * Decompiled with CFR 0.152.
 */
package org.protege.osgi.jdbc.impl;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.protege.osgi.jdbc.JdbcRegistry;

public class OSGiJdbcDriver
implements Driver {
    private final Version version;
    private final JdbcRegistry registry;

    public OSGiJdbcDriver(BundleContext context, JdbcRegistry registry) {
        this.registry = registry;
        String versionString = (String)context.getBundle().getHeaders().get("Bundle-Version");
        this.version = new Version(versionString);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return this.getDelegate(url) != null;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        Driver delegate = this.getDelegate(url);
        return delegate == null ? null : delegate.connect(url, info);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Driver delegate = this.getDelegate(url);
        return delegate == null ? null : delegate.getPropertyInfo(url, info);
    }

    private Driver getDelegate(String url) throws SQLException {
        for (Driver delegate : this.registry.getJdbcDrivers()) {
            if (!delegate.acceptsURL(url)) continue;
            return delegate;
        }
        return null;
    }

    @Override
    public boolean jdbcCompliant() {
        return this.registry.getJdbcDrivers().stream().allMatch(Driver::jdbcCompliant);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getMajorVersion() {
        return this.version.getMajor();
    }

    @Override
    public int getMinorVersion() {
        return this.version.getMinor();
    }
}

