/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.utils;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.exception.TargetQueryParserException;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.protege.core.OBDAModelManager;
import it.unibz.inf.ontop.protege.core.OntologyPrefixManager;
import it.unibz.inf.ontop.protege.core.OntologySignature;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import java.awt.Color;
import java.awt.Font;
import java.util.Optional;
import java.util.function.Consumer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.commons.rdf.api.IRI;

public class TargetQueryStyledDocument
extends DefaultStyledDocument {
    public static final Font TARGET_QUERY_FONT = new Font("Lucida Grande", 0, 14);
    private final SimpleAttributeSet plainStyle = new SimpleAttributeSet();
    private final SimpleAttributeSet punctuationStyle = new SimpleAttributeSet();
    private final SimpleAttributeSet classStyle = new SimpleAttributeSet();
    private final SimpleAttributeSet objectPropertyStyle = new SimpleAttributeSet();
    private final SimpleAttributeSet dataPropertyStyle = new SimpleAttributeSet();
    private final SimpleAttributeSet annotationPropertyStyle = new SimpleAttributeSet();
    private final SimpleAttributeSet individualStyle = new SimpleAttributeSet();
    private final SimpleAttributeSet templateArgumentStyle = new SimpleAttributeSet();
    private final SimpleAttributeSet selectedTemplateArgumentStyle = new SimpleAttributeSet();
    private final SimpleAttributeSet errorStyle = new SimpleAttributeSet();
    private final OBDAModelManager obdaModelManager;
    private final Consumer<TargetQueryStyledDocument> validationCallback;
    private ImmutableList<String> invalidPlaceholders = ImmutableList.of();
    private boolean isSelected = false;

    public TargetQueryStyledDocument(OBDAModelManager obdaModelManager, Consumer<TargetQueryStyledDocument> validationCallback) {
        this.obdaModelManager = obdaModelManager;
        this.validationCallback = validationCallback;
        StyleConstants.setFontFamily(this.plainStyle, TARGET_QUERY_FONT.getFamily());
        StyleConstants.setFontSize(this.plainStyle, TARGET_QUERY_FONT.getSize());
        StyleConstants.setBold(this.punctuationStyle, true);
        StyleConstants.setForeground(this.punctuationStyle, Color.GRAY);
        StyleConstants.setForeground(this.annotationPropertyStyle, new Color(109, 159, 162));
        StyleConstants.setBold(this.annotationPropertyStyle, true);
        StyleConstants.setForeground(this.dataPropertyStyle, new Color(41, 167, 121));
        StyleConstants.setBold(this.dataPropertyStyle, true);
        StyleConstants.setForeground(this.objectPropertyStyle, new Color(41, 119, 167));
        StyleConstants.setBold(this.objectPropertyStyle, true);
        StyleConstants.setForeground(this.classStyle, new Color(199, 155, 41));
        StyleConstants.setBold(this.classStyle, true);
        StyleConstants.setForeground(this.individualStyle, new Color(83, 24, 82));
        StyleConstants.setBold(this.individualStyle, true);
        StyleConstants.setBold(this.templateArgumentStyle, true);
        StyleConstants.setForeground(this.templateArgumentStyle, new Color(97, 66, 151));
        StyleConstants.setBold(this.selectedTemplateArgumentStyle, true);
        StyleConstants.setForeground(this.selectedTemplateArgumentStyle, Color.LIGHT_GRAY);
        StyleConstants.setForeground(this.errorStyle, Color.RED);
        StyleConstants.setBold(this.errorStyle, true);
        StyleConstants.setUnderline(this.errorStyle, true);
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        super.insertString(offset, str, a);
        this.validationCallback.accept(this);
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        super.remove(offs, len);
        this.validationCallback.accept(this);
    }

    public void setInvalidPlaceholders(ImmutableList<String> invalidPlaceholders) {
        this.invalidPlaceholders = invalidPlaceholders;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public ImmutableSet<IRI> validate() throws TargetQueryParserException {
        ImmutableSet.Builder unrecognisedIRIsBuilder = ImmutableSet.builder();
        try {
            this.setCharacterAttributes(0, this.getLength(), this.plainStyle, true);
            this.highlight("(", this.punctuationStyle);
            this.highlight(")", this.punctuationStyle);
            this.highlight("{", this.punctuationStyle);
            this.highlight("}", this.punctuationStyle);
            this.highlight(".", this.punctuationStyle);
            this.highlight(",", this.punctuationStyle);
            this.highlight(";", this.punctuationStyle);
            this.highlight("a", this.punctuationStyle);
            this.highlight("GRAPH", this.punctuationStyle);
            for (TargetAtom atom : this.getTargetAtoms()) {
                unrecognisedIRIsBuilder.addAll(this.validateTargetAtom(atom));
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return unrecognisedIRIsBuilder.build();
    }

    private ImmutableSet<IRI> validateTargetAtom(TargetAtom atom) throws BadLocationException {
        ImmutableSet.Builder unrecognisedIRIsBuilder = ImmutableSet.builder();
        OntologySignature vocabulary = this.obdaModelManager.getCurrentOBDAModel().getOntologySignature();
        ImmutableList substitutedTerms = atom.getSubstitutedTerms();
        RDFAtomPredicate atomPredicate = (RDFAtomPredicate)atom.getProjectionAtom().getPredicate();
        ImmutableTerm term1 = atomPredicate.getSubject(substitutedTerms);
        this.highlightTemplateArguments(term1);
        if (term1 instanceof IRIConstant) {
            this.highlight(((IRIConstant)term1).getIRI(), this.individualStyle);
        }
        ImmutableTerm term2 = atomPredicate.getProperty(substitutedTerms);
        this.highlightTemplateArguments(term2);
        if (term2 instanceof IRIConstant) {
            IRI predicateIri = ((IRIConstant)term2).getIRI();
            if (predicateIri.getIRIString().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) {
                ImmutableTerm term3 = atomPredicate.getObject(substitutedTerms);
                if (term3 instanceof IRIConstant) {
                    IRI classIri = ((IRIConstant)term3).getIRI();
                    if (vocabulary.containsClass(classIri)) {
                        this.highlight(classIri, this.classStyle);
                    } else {
                        this.highlight(classIri, this.errorStyle);
                        unrecognisedIRIsBuilder.add((Object)classIri);
                    }
                }
            } else {
                if (vocabulary.containsObjectProperty(predicateIri)) {
                    this.highlight(predicateIri, this.objectPropertyStyle);
                } else if (vocabulary.containsDataProperty(predicateIri)) {
                    this.highlight(predicateIri, this.dataPropertyStyle);
                } else if (vocabulary.containsAnnotationProperty(predicateIri)) {
                    this.highlight(predicateIri, this.annotationPropertyStyle);
                } else if (vocabulary.isBuiltinProperty(predicateIri)) {
                    this.highlight(predicateIri, this.punctuationStyle);
                } else {
                    this.highlight(predicateIri, this.errorStyle);
                    unrecognisedIRIsBuilder.add((Object)predicateIri);
                }
                ImmutableTerm term3 = atomPredicate.getObject(substitutedTerms);
                this.highlightTemplateArguments(term3);
                if (term3 instanceof IRIConstant) {
                    this.highlight(((IRIConstant)term3).getIRI(), this.individualStyle);
                }
            }
        } else {
            ImmutableTerm term3 = atomPredicate.getObject(substitutedTerms);
            this.highlightTemplateArguments(term3);
            if (term3 instanceof IRIConstant) {
                this.highlight(((IRIConstant)term3).getIRI(), this.individualStyle);
            }
        }
        Optional term4 = atomPredicate.getGraph(substitutedTerms);
        if (term4.isPresent()) {
            this.highlightTemplateArguments((ImmutableTerm)term4.get());
        }
        return unrecognisedIRIsBuilder.build();
    }

    private ImmutableList<TargetAtom> getTargetAtoms() throws TargetQueryParserException, BadLocationException {
        try {
            String input = this.getText(0, this.getLength());
            if (!input.isEmpty()) {
                return this.obdaModelManager.getCurrentOBDAModel().getTriplesMapCollection().parseTargetQuery(input);
            }
        }
        catch (TargetQueryParserException e) {
            if (e.getLine() > 0) {
                int column = e.getColumn();
                int line = e.getLine();
                String input = this.getText(0, this.getLength());
                int lineStart = 0;
                for (int i = 1; i < line; ++i) {
                    lineStart = input.indexOf(10, lineStart) + 1;
                }
                int pos = lineStart + column;
                this.setCharacterAttributes(pos >= input.length() ? pos - 1 : pos, 1, this.errorStyle, false);
            }
            throw e;
        }
        return ImmutableList.of();
    }

    private Optional<ImmutableFunctionalTerm> getTemplateImmutableFunctionalTerm(ImmutableTerm term) {
        if (term instanceof ImmutableFunctionalTerm) {
            return Optional.of((ImmutableFunctionalTerm)term);
        }
        return Optional.empty();
    }

    private void highlightTemplateArguments(ImmutableTerm term) throws BadLocationException {
        Optional<ImmutableFunctionalTerm> template = this.getTemplateImmutableFunctionalTerm(term);
        if (template.isPresent()) {
            String input = this.getText(0, this.getLength());
            for (Variable v : template.get().getVariables()) {
                int p;
                String arg = "{" + v.getName() + "}";
                SimpleAttributeSet style = this.invalidPlaceholders.contains((Object)v.getName()) ? this.errorStyle : (this.isSelected ? this.selectedTemplateArgumentStyle : this.templateArgumentStyle);
                int po = 0;
                while ((p = input.indexOf(arg, po)) != -1) {
                    this.setCharacterAttributes(p + 1, arg.length() - 2, style, false);
                    po = p + arg.length();
                }
            }
        }
    }

    private void highlight(IRI iri, SimpleAttributeSet attributeSet) throws BadLocationException {
        OntologyPrefixManager prefixManager = this.obdaModelManager.getCurrentOBDAModel().getMutablePrefixManager();
        String rendered = prefixManager.getShortForm(iri.getIRIString());
        this.highlight(rendered, attributeSet);
    }

    private void highlight(String s, SimpleAttributeSet attributeSet) throws BadLocationException {
        String input = this.getText(0, this.getLength());
        int total = input.length();
        int len = s.length();
        int pos = input.indexOf(s, 0);
        while (pos != -1) {
            if ((pos == 0 || TargetQueryStyledDocument.isDelimiter(input.charAt(pos - 1))) && (pos + len == total || TargetQueryStyledDocument.isDelimiter(input.charAt(pos + len)))) {
                this.setCharacterAttributes(pos, len, attributeSet, false);
            }
            pos = input.indexOf(s, pos + len);
        }
    }

    private static boolean isDelimiter(char c) {
        return Character.isWhitespace(c) || c == '.' || c == ';' || c == ',' || c == '<' || c == '>' || c == '\"' || c == '{' || c == '}';
    }
}

