/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.utils;

import it.unibz.inf.ontop.protege.utils.AbstractProgressMonitor;
import it.unibz.inf.ontop.protege.utils.DialogProgressMonitor;
import it.unibz.inf.ontop.protege.utils.SwingWorkerWithMonitor;
import java.awt.Component;

public abstract class SwingWorkerWithTimeIntervalMonitor<T, V>
extends SwingWorkerWithMonitor<T, V> {
    private final long monitorUpdateInterval;
    private long previousTime;
    private int count;

    protected SwingWorkerWithTimeIntervalMonitor(Component parent, Object message, long monitorUpdateInterval) {
        this(new DialogProgressMonitor(parent, message, true), monitorUpdateInterval);
    }

    protected SwingWorkerWithTimeIntervalMonitor(AbstractProgressMonitor progressMonitor, long monitorUpdateInterval) {
        super(progressMonitor);
        this.monitorUpdateInterval = monitorUpdateInterval;
        this.previousTime = this.startTime;
    }

    @Override
    protected void tick() throws SwingWorkerWithMonitor.CancelActionException {
        ++this.count;
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.previousTime > this.monitorUpdateInterval) {
            this.previousTime = currentTime;
            this.notifyProgressMonitor();
        }
        super.tick();
    }

    public int getCount() {
        return this.count;
    }
}

