/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.utils;

import it.unibz.inf.ontop.protege.utils.AbstractProgressMonitor;
import it.unibz.inf.ontop.protege.utils.DialogProgressMonitor;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public abstract class SwingWorkerWithMonitor<T, V>
extends SwingWorker<T, V> {
    protected final AbstractProgressMonitor progressMonitor;
    protected final long startTime;
    private PropertyChangeListener listener;
    private Supplier<String> statusSupplier;
    private Supplier<Integer> progressSupplier;

    protected SwingWorkerWithMonitor(Component parent, Object message, boolean indeterminate) {
        this(new DialogProgressMonitor(parent, message, indeterminate));
    }

    protected SwingWorkerWithMonitor(AbstractProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
        this.startTime = System.currentTimeMillis();
    }

    public long elapsedTimeMillis() {
        return System.currentTimeMillis() - this.startTime;
    }

    protected void start(String startProgressNote) {
        this.progressMonitor.open(startProgressNote);
    }

    protected void startLoop(Supplier<Integer> progressSupplier, Supplier<String> statusSupplier) throws CancelActionException {
        this.terminateIfCancelled();
        this.statusSupplier = statusSupplier;
        this.progressSupplier = progressSupplier;
        this.listener = evt -> {
            if ("progress".equals(evt.getPropertyName())) {
                this.progressMonitor.setProgress((Integer)progressSupplier.get(), (String)statusSupplier.get());
            }
        };
        this.addPropertyChangeListener(this.listener);
        this.notifyProgressMonitor();
    }

    protected void notifyProgressMonitor() {
        SwingUtilities.invokeLater(() -> this.progressMonitor.setProgress(this.progressSupplier.get(), this.statusSupplier.get()));
    }

    protected void endLoop(String endLoopMessage) throws CancelActionException {
        this.removePropertyChangeListener(this.listener);
        try {
            SwingUtilities.invokeAndWait(() -> this.progressMonitor.prepareClosing(endLoopMessage));
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
        if (this.progressMonitor.isCancelled()) {
            throw new CancelActionException();
        }
    }

    protected void end() {
        this.closeProgressMonitorAndWait();
    }

    protected T complete() throws ExecutionException, InterruptedException {
        this.progressMonitor.close();
        try {
            return this.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CancelActionException) {
                throw new CancellationException();
            }
            throw e;
        }
    }

    protected void tick() throws CancelActionException {
        this.terminateIfCancelled();
    }

    private void terminateIfCancelled() throws CancelActionException {
        if (this.progressMonitor.isCancelled()) {
            this.closeProgressMonitorAndWait();
            throw new CancelActionException();
        }
    }

    private void closeProgressMonitorAndWait() {
        try {
            SwingUtilities.invokeAndWait(this.progressMonitor::close);
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public static class CancelActionException
    extends Exception {
    }
}

