/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.utils;

import java.awt.Color;
import java.awt.Font;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class SQLQueryStyledDocument
extends DefaultStyledDocument {
    private static final Font SQL_FONT = new Font("Courier", 0, 14);
    private static final Color SQL_COLOR = new Color(38, 128, 2);
    private final SimpleAttributeSet plainStyle = new SimpleAttributeSet();
    private final SimpleAttributeSet boldStyle = new SimpleAttributeSet();

    public SQLQueryStyledDocument() {
        StyleConstants.setFontSize(this.plainStyle, SQL_FONT.getSize());
        StyleConstants.setFontFamily(this.plainStyle, SQL_FONT.getFamily());
        StyleConstants.setBold(this.boldStyle, true);
        StyleConstants.setForeground(this.boldStyle, SQL_COLOR);
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        super.insertString(offset, str, a);
        this.highlightKeywords();
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        super.remove(offs, len);
        this.highlightKeywords();
    }

    private void highlightKeywords() throws BadLocationException {
        this.setCharacterAttributes(0, this.getLength(), this.plainStyle, true);
        this.highlight("SELECT");
        this.highlight("FROM");
        this.highlight("WHERE");
        this.highlight("ON");
        this.highlight("JOIN");
        this.highlight("AND");
        this.highlight("AS");
    }

    private void highlight(String keyword) throws BadLocationException {
        int index;
        int length = keyword.length();
        String pattern = IntStream.range(0, length).mapToObj(keyword::charAt).map(c -> "[" + Character.toUpperCase(c.charValue()) + Character.toLowerCase(c.charValue()) + "]").collect(Collectors.joining("", "(", ")"));
        String input = this.getText(0, this.getLength()).replaceAll(pattern, keyword.toUpperCase());
        int total = input.length();
        int offset = 0;
        while ((index = input.indexOf(keyword, offset)) != -1) {
            offset = index + length;
            if (index != 0 && !Character.isWhitespace(input.charAt(index - 1)) || offset < total && !Character.isWhitespace(input.charAt(offset))) continue;
            this.setCharacterAttributes(index, length, this.boldStyle, false);
        }
    }
}

