/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.utils;

import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.exception.OntopQueryEvaluationException;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.owlapi.connection.OntopOWLStatement;
import it.unibz.inf.ontop.owlapi.exception.OntopOWLException;
import it.unibz.inf.ontop.protege.core.OntopProtegeReasoner;
import it.unibz.inf.ontop.protege.utils.AbstractProgressMonitor;
import it.unibz.inf.ontop.protege.utils.DialogProgressMonitor;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.protege.utils.EmbeddedProgressMonitor;
import it.unibz.inf.ontop.protege.utils.SwingWorkerWithMonitor;
import it.unibz.inf.ontop.protege.utils.SwingWorkerWithTimeIntervalMonitor;
import java.awt.Component;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OntopQuerySwingWorker<T, V>
extends SwingWorkerWithTimeIntervalMonitor<Map.Entry<T, String>, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OntopQuerySwingWorker.class);
    private static final int MONITOR_UPDATE_INTERVAL = 300;
    private final String query;
    private final Component parent;
    private final String title;
    private final OntopProtegeReasoner ontop;
    private OntopOWLStatement statement;

    protected OntopQuerySwingWorker(OntopProtegeReasoner ontop, String query, Component parent, String title) {
        this(ontop, query, parent, title, new DialogProgressMonitor(parent, "<html><h3>" + title + "</h3></html>", true));
    }

    protected OntopQuerySwingWorker(OntopProtegeReasoner ontop, String query, Component parent, String title, JButton startButton, JButton stopButton, JLabel statusLabel) {
        this(ontop, query, parent, title, new EmbeddedProgressMonitor(startButton, stopButton, statusLabel));
    }

    protected OntopQuerySwingWorker(OntopProtegeReasoner ontop, String query, Component parent, String title, AbstractProgressMonitor progressMonitor) {
        super(progressMonitor, 300L);
        this.parent = parent;
        this.title = title;
        this.query = query;
        this.ontop = ontop;
        progressMonitor.setCancelAction(this::cancelStatementQuietly);
    }

    protected abstract T runQuery(OntopOWLStatement var1, String var2) throws Exception;

    protected abstract void onCompletion(T var1, String var2);

    @Override
    protected Map.Entry<T, String> doInBackground() throws Exception {
        try {
            this.start("Rewriting the query...");
            this.statement = this.ontop.getStatement();
            if (this.statement == null) {
                throw new NullPointerException("OntopQuerySwingWorker received a null OntopOWLStatement object from the reasoner");
            }
            IQ sqlExecutableQuery = this.statement.getExecutableQuery(this.query);
            String sql = sqlExecutableQuery.toString();
            this.startLoop(() -> 50, () -> this.getCount() == 0 ? "Started retrieving results..." : String.format("%d results retrieved...", this.getCount()));
            T value = this.runQuery(this.statement, this.query);
            this.endLoop("Completed results retrieval.");
            this.end();
            Map.Entry entry = Maps.immutableEntry(value, (Object)sql);
            return entry;
        }
        catch (OntopOWLException e) {
            if (e.getCause() instanceof OntopQueryEvaluationException && "Query execution was cancelled".equals(e.getCause().getMessage())) {
                throw new SwingWorkerWithMonitor.CancelActionException();
            }
            throw e;
        }
        finally {
            this.closeStatementQuietly();
        }
    }

    @Override
    protected void done() {
        try {
            Map.Entry result = (Map.Entry)this.complete();
            this.onCompletion(result.getKey(), (String)result.getValue());
        }
        catch (InterruptedException | CancellationException ignore) {
            this.progressMonitor.setStatus("Query processing was cancelled.");
        }
        catch (ExecutionException e) {
            DialogUtils.showErrorDialog(this.parent, this.title, this.title + " error.", LOGGER, e, null);
        }
        catch (Exception e) {
            DialogUtils.showQuickErrorDialog(this.parent, e, this.title + " error.");
        }
    }

    private void closeStatementQuietly() {
        try {
            if (this.statement != null && !this.statement.isClosed()) {
                this.statement.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void cancelStatementQuietly() {
        try {
            if (this.statement != null && !this.statement.isClosed()) {
                this.statement.cancel();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

