/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventListenerList<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventListenerList.class);
    private final List<T> listeners = new ArrayList<T>();

    public void add(T listener) {
        Objects.requireNonNull(listener);
        if (this.listeners.contains(listener)) {
            throw new IllegalArgumentException("ListenerList " + this.listeners + " already contains " + listener);
        }
        this.listeners.add(listener);
    }

    public void remove(T listener) {
        boolean result = this.listeners.remove(listener);
        if (!result) {
            throw new IllegalArgumentException("ListenerList " + this.listeners + " did not contain " + listener);
        }
    }

    public void fire(Consumer<? super T> consumer) {
        this.listeners.forEach(listener -> {
            try {
                consumer.accept(listener);
            }
            catch (Exception e) {
                LOGGER.debug("Badly behaved listener: {}", (Object)listener.getClass().toString());
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        });
    }
}

