/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.utils;

import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.protege.connection.DataSource;
import it.unibz.inf.ontop.protege.core.OntopProtegeReasoner;
import it.unibz.inf.ontop.protege.mapping.DuplicateTriplesMapException;
import it.unibz.inf.ontop.protege.utils.OntopAbstractAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.sql.SQLException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import org.protege.editor.core.ProtegeManager;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.ui.workspace.WorkspaceFrame;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.slf4j.Logger;

public class DialogUtils {
    public static final String CANCEL_BUTTON_TEXT = UIManager.getString("OptionPane.cancelButtonText");
    public static final String OK_BUTTON_TEXT = UIManager.getString("OptionPane.okButtonText");
    public static final String HTML_TAB = "&nbsp;&nbsp;&nbsp;&nbsp;";

    public static ImageIcon getImageIcon(String path) {
        URL imgURL = DialogUtils.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        return null;
    }

    public static ImageIcon getOntopIcon() {
        return DialogUtils.getImageIcon("images/ontop-logo.png");
    }

    public static void setLocationRelativeToProtegeAndOpen(EditorKit editorKit, JDialog dialog) {
        dialog.setDefaultCloseOperation(2);
        dialog.pack();
        WorkspaceFrame protegeFrame = ProtegeManager.getInstance().getFrame(editorKit.getWorkspace());
        dialog.setLocationRelativeTo((Component)protegeFrame);
        dialog.setVisible(true);
    }

    public static boolean confirmation(Component parent, String message, String title) {
        return JOptionPane.showConfirmDialog(parent, message, title, 0, 3, DialogUtils.getOntopIcon()) == 0;
    }

    public static OntopAbstractAction getStandardCloseWindowAction(String text, final Window source) {
        return new OntopAbstractAction(text, null, null, KeyStroke.getKeyStroke(27, 0)){

            @Override
            public void actionPerformed(ActionEvent e) {
                source.dispatchEvent(new WindowEvent(source, 201));
            }
        };
    }

    public static JButton getButton(OntopAbstractAction action) {
        JButton button = new JButton(action);
        button.setIconTextGap(5);
        button.setMargin(new Insets(3, 7, 3, 7));
        if (button.getToolTipText() != null) {
            if (action.getAccelerator() == null) {
                button.setToolTipText(action.getTooltip());
            } else {
                button.setToolTipText(action.getTooltip() + " (" + DialogUtils.keyStroke2String(action.getAccelerator()) + ")");
            }
        }
        return button;
    }

    public static JMenuItem getMenuItem(Action action) {
        return new JMenuItem(action);
    }

    public static JMenuItem getMenuItem(String text, Action action) {
        JMenuItem menuItem = new JMenuItem(action);
        menuItem.setText(text);
        menuItem.setIcon(null);
        return menuItem;
    }

    public static KeyStroke getKeyStrokeWithCtrlMask(int keyCode) {
        return KeyStroke.getKeyStroke(keyCode, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    public static void setUpPopUpMenu(JComponent component, JPopupMenu popupMenu) {
        int c = popupMenu.getComponentCount();
        for (int i = 0; i < c; ++i) {
            Component current = popupMenu.getComponent(i);
            if (!(current instanceof JMenuItem)) continue;
            JMenuItem menuItem = (JMenuItem)current;
            DialogUtils.setUpAccelerator(component, menuItem.getAction());
        }
        component.setComponentPopupMenu(popupMenu);
    }

    public static void setUpAccelerator(JComponent component, Action action) {
        KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
        if (keyStroke != null) {
            DialogUtils.setUpAccelerator(component, action, keyStroke);
        }
    }

    public static void setUpAccelerator(JComponent component, Action action, KeyStroke keyStroke) {
        component.getInputMap(1).put(keyStroke, action.getValue("Name"));
        component.getActionMap().put(action.getValue("Name"), action);
    }

    private static String keyStroke2String(KeyStroke keyStroke) {
        return KeyEvent.getKeyModifiersText(keyStroke.getModifiers()) + KeyEvent.getKeyText(keyStroke.getKeyCode());
    }

    public static JButton createStandardButton(String text, boolean enabled) {
        JButton button = new JButton(text);
        button.addActionListener(e -> DialogUtils.getOptionPaneParent((JComponent)e.getSource()).setValue(button));
        button.setEnabled(enabled);
        return button;
    }

    private static JOptionPane getOptionPaneParent(Container parent) {
        return parent instanceof JOptionPane ? (JOptionPane)parent : DialogUtils.getOptionPaneParent(parent.getParent());
    }

    public static DefaultTableModel createNonEditableTableModel(Object[] columnNames) {
        return new DefaultTableModel(columnNames, 0){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
    }

    public static String htmlEscape(String s) {
        return s.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\t", HTML_TAB).replaceAll("\n", "<br>");
    }

    public static String renderElapsedTime(long millis) {
        if (millis < 1000L) {
            return String.format("%dms", millis);
        }
        if (millis < 10000L) {
            return String.format("%d.%02ds", millis / 1000L, (millis % 1000L + 5L) / 10L);
        }
        if (millis < 100000L) {
            return String.format("%d.%01ds", millis / 1000L, (millis % 1000L + 50L) / 100L);
        }
        return String.format("%ds", (millis + 500L) / 1000L);
    }

    public static Function<String, String> getExtensionReplacer(String replacement) {
        return shortForm -> {
            int i = shortForm.lastIndexOf(".");
            String filename = i < 1 ? shortForm : shortForm.substring(0, i);
            return filename + replacement;
        };
    }

    public static JFileChooser getFileChooser(EditorKit editorKit, Function<String, String> filenameTransformer) {
        OWLEditorKit owlEditorKit = (OWLEditorKit)editorKit;
        OWLModelManager modelManager = owlEditorKit.getOWLWorkspace().getOWLModelManager();
        OWLOntology activeOntology = modelManager.getActiveOntology();
        IRI documentIRI = modelManager.getOWLOntologyManager().getOntologyDocumentIRI(activeOntology);
        File ontologyDir = new File(documentIRI.toURI().getPath());
        JFileChooser fc = new JFileChooser(ontologyDir);
        if (filenameTransformer != null) {
            fc.setSelectedFile(new File(filenameTransformer.apply(documentIRI.getShortForm())));
        }
        return fc;
    }

    public static boolean confirmCanWrite(File file, Container parent, String title) {
        return !file.exists() || JOptionPane.showConfirmDialog(parent, "<html><br>The file " + file.getPath() + " exists.<br><br>Do you want to <b>overwrite</b> it?<br></html>", title, 0, 3, DialogUtils.getOntopIcon()) == 0;
    }

    public static void showPrettyMessageDialog(Component parent, Object message, String title, int type) {
        JOptionPane narrowPane = new JOptionPane(message, type);
        JDialog errorDialog = narrowPane.createDialog(parent, title);
        errorDialog.setVisible(true);
    }

    public static Optional<OntopProtegeReasoner> getOntopProtegeReasoner(EditorKit editorKit) {
        if (!(editorKit instanceof OWLEditorKit)) {
            throw new MinorOntopInternalBugException("EditorKit is not an OWLEditorKit");
        }
        OWLEditorKit owlEditorKit = (OWLEditorKit)editorKit;
        OWLReasoner reasoner = owlEditorKit.getModelManager().getOWLReasonerManager().getCurrentReasoner();
        if (!(reasoner instanceof OntopProtegeReasoner)) {
            JOptionPane.showMessageDialog((Component)editorKit.getWorkspace(), "<html><b>Ontop reasoner</b> must be started before using this feature. To proceed<br><br>&nbsp;&nbsp;&nbsp;&nbsp; * select Ontop in the <b>\"Reasoner\"</b> menu and<br>&nbsp;&nbsp;&nbsp;&nbsp; * click <b>\"Start reasoner\"</b> in the same menu.<br></html>", "Warning", 2);
            return Optional.empty();
        }
        return Optional.of((OntopProtegeReasoner)reasoner);
    }

    public static void showCancelledActionDialog(Component parent, String title) {
        JOptionPane.showMessageDialog(parent, "<html><b>Process cancelled.</b> No changes made.<br></html>", title, 2);
    }

    public static void showErrorDialog(Component parent, String title, String message, Logger log, ExecutionException e, DataSource datasource) {
        Throwable cause = e.getCause();
        if (cause instanceof SQLException && datasource != null) {
            JOptionPane.showMessageDialog(parent, "<html><b>Error connecting to the database:</b> " + DialogUtils.htmlEscape(cause.getMessage()) + ".<br><br>" + HTML_TAB + "JDBC driver: " + datasource.getDriver() + "<br>" + HTML_TAB + "Connection URL: " + datasource.getURL() + "<br>" + HTML_TAB + "Username: " + datasource.getUsername() + "</html>", title, 0);
        } else if (cause instanceof DuplicateTriplesMapException) {
            DuplicateTriplesMapException dm = (DuplicateTriplesMapException)cause;
            JOptionPane.showMessageDialog(parent, "<html><b>Duplicate mapping ID found.</b><br><br>&nbsp;&nbsp;&nbsp;&nbsp;Please correct the Resource node name: <b>" + dm.getMessage() + "</b>.<br></html>", title, 0);
        } else if (cause instanceof OWLException) {
            OWLException owlException = (OWLException)cause;
            Throwable owlExceptionCause = owlException.getCause();
            JOptionPane.showMessageDialog(parent, "<html><b>Error executing SPARQL query.</b><br><br>&nbsp;&nbsp;&nbsp;&nbsp;" + DialogUtils.htmlEscape(owlExceptionCause.getMessage()) + "</b>.<br></html>", title, 0);
        } else {
            DialogUtils.showSeeLogErrorDialog(parent, title, message, log, cause);
        }
    }

    public static void showSeeLogErrorDialog(Component parent, String title, String message, Logger log, Throwable e) {
        String text = message + "\n" + e.getMessage() + "\nFor more information, see the log.";
        JOptionPane narrowPane = new JOptionPane(text, 0);
        JDialog errorDialog = narrowPane.createDialog(parent, title);
        errorDialog.setModal(true);
        errorDialog.setVisible(true);
        log.error(e.getMessage(), e);
        e.printStackTrace();
    }

    public static void showSeeLogErrorDialog(Component parent, String message, Logger log, Throwable e) {
        DialogUtils.showSeeLogErrorDialog(parent, "Error", message, log, e);
    }

    public static void showQuickErrorDialog(Component parent, Exception e, String message) {
        SwingUtilities.invokeLater(() -> {
            JTextArea textArea = new JTextArea();
            textArea.setBackground(Color.WHITE);
            textArea.setFont(new Font("Monaco", 0, 11));
            textArea.setEditable(false);
            textArea.setWrapStyleWord(true);
            String debugInfo = e.getLocalizedMessage() + "\n\n###################################################\n##    Debugging information for developers    ##\n###################################################\n\n" + Stream.of(e.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n\t", "\t", ""));
            textArea.setText(debugInfo);
            textArea.setCaretPosition(0);
            JScrollPane scrollPane = new JScrollPane(textArea);
            scrollPane.setPreferredSize(new Dimension(800, 450));
            JOptionPane.showMessageDialog(parent, scrollPane, message, 0);
        });
    }

    public static void showInfoDialog(Component parent, String message, String title) {
        JOptionPane.showMessageDialog(parent, message, title, 1, DialogUtils.getOntopIcon());
    }
}

